/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.parallel;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class CollectionsThreadFactory
implements ThreadFactory {
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;
    private boolean isDaemon = true;

    CollectionsThreadFactory(String poolPrefix, boolean useDaemonThreads) {
        this.isDaemon = useDaemonThreads;
        SecurityManager securityManager = System.getSecurityManager();
        this.group = securityManager == null ? Thread.currentThread().getThreadGroup() : securityManager.getThreadGroup();
        this.namePrefix = poolPrefix + " pool- thread-";
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t2 = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        t2.setDaemon(this.isDaemon);
        if (t2.getPriority() != 5) {
            t2.setPriority(5);
        }
        return t2;
    }
}

