/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.ByteIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.LazyByteIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.bag.primitive.MutableByteBag;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.ByteBags;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.ByteLists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.ByteSets;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.primitive.MutableByteList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.MutableByteSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import java.util.Arrays;

public abstract class AbstractByteIterable
implements ByteIterable {
    @Override
    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    @Override
    public byte minIfEmpty(byte defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    @Override
    public byte maxIfEmpty(byte defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    @Override
    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    @Override
    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        byte[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            byte first = sortedArray[middleIndex];
            byte second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    @Override
    public byte[] toSortedArray() {
        byte[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableByteList toSortedList() {
        return this.toList().sortThis();
    }

    @Override
    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter(this);
    }

    @Override
    public MutableByteList toList() {
        return ByteLists.mutable.withAll(this);
    }

    @Override
    public MutableByteSet toSet() {
        return ByteSets.mutable.withAll(this);
    }

    @Override
    public MutableByteBag toBag() {
        return ByteBags.mutable.withAll(this);
    }
}

