/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.LazyIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.RichIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function3;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.Predicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.Predicate2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Sets;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.map.MutableMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.MutableSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.Pool;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.SetIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.UnsortedSetIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.tuple.Pair;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.collection.mutable.AbstractMutableCollection;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.map.mutable.UnifiedMap;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.parallel.BatchIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.mutable.SynchronizedMutableSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.mutable.UnifiedSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.mutable.UnmodifiableMutableSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.Iterate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.internal.MutableCollectionIterate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.internal.SetIterables;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;

public abstract class AbstractUnifiedSet<T>
extends AbstractMutableCollection<T>
implements MutableSet<T>,
Pool<T>,
BatchIterable<T> {
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected static final int DEFAULT_INITIAL_CAPACITY = 8;
    protected float loadFactor = 0.75f;
    protected int maxSize;

    protected abstract Object[] getTable();

    protected abstract void allocateTable(int var1);

    protected abstract void rehash(int var1);

    protected abstract T detect(Predicate<? super T> var1, int var2, int var3);

    protected abstract Optional<T> detectOptional(Predicate<? super T> var1, int var2, int var3);

    @Override
    public abstract MutableSet<T> clone();

    public abstract MutableSet<T> newEmpty(int var1);

    protected abstract boolean shortCircuit(Predicate<? super T> var1, boolean var2, boolean var3, boolean var4, int var5, int var6);

    protected abstract <P> boolean shortCircuitWith(Predicate2<? super T, ? super P> var1, P var2, boolean var3, boolean var4, boolean var5);

    protected int init(int initialCapacity) {
        int capacity;
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        return this.allocate(capacity);
    }

    protected int allocate(int capacity) {
        this.allocateTable(capacity);
        this.computeMaxSize(capacity);
        return capacity;
    }

    protected void computeMaxSize(int capacity) {
        this.maxSize = Math.min(capacity - 1, (int)((float)capacity * this.loadFactor));
    }

    protected void rehash() {
        this.rehash(this.getTable().length << 1);
    }

    protected boolean shortCircuit(Predicate<? super T> predicate, boolean expected, boolean onShortCircuit, boolean atEnd) {
        return this.shortCircuit(predicate, expected, onShortCircuit, atEnd, 0, this.getTable().length);
    }

    @Override
    public int getBatchCount(int batchSize) {
        return Math.max(1, this.getTable().length / batchSize);
    }

    @Override
    public <V> UnifiedSet<V> collect(Function<? super T, ? extends V> function) {
        return this.collect(function, UnifiedSet.newSet());
    }

    @Override
    public <V> UnifiedSet<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return this.flatCollect(function, UnifiedSet.newSet());
    }

    @Override
    public <P, A> UnifiedSet<A> collectWith(Function2<? super T, ? super P, ? extends A> function, P parameter) {
        return this.collectWith(function, parameter, UnifiedSet.newSet());
    }

    @Override
    public <V> UnifiedSet<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return this.collectIf(predicate, function, UnifiedSet.newSet());
    }

    @Override
    public T detect(Predicate<? super T> predicate) {
        return this.detect(predicate, 0, this.getTable().length);
    }

    @Override
    public Optional<T> detectOptional(Predicate<? super T> predicate) {
        return this.detectOptional(predicate, 0, this.getTable().length);
    }

    @Override
    public boolean anySatisfy(Predicate<? super T> predicate) {
        return this.shortCircuit(predicate, true, true, false);
    }

    @Override
    public <P> boolean anySatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.shortCircuitWith(predicate, parameter, true, true, false);
    }

    @Override
    public boolean allSatisfy(Predicate<? super T> predicate) {
        return this.shortCircuit(predicate, false, false, true);
    }

    @Override
    public <P> boolean allSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.shortCircuitWith(predicate, parameter, false, false, true);
    }

    @Override
    public boolean noneSatisfy(Predicate<? super T> predicate) {
        return this.shortCircuit(predicate, true, false, true);
    }

    @Override
    public <P> boolean noneSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.shortCircuitWith(predicate, parameter, true, false, true);
    }

    @Override
    public <IV, P> IV injectIntoWith(IV injectValue, Function3<? super IV, ? super T, ? super P, ? extends IV> function, P parameter) {
        return (IV)this.injectInto(injectValue, (? super IV argument1, ? super T argument2) -> function.value((Object)argument1, (Object)argument2, (Object)parameter));
    }

    @Override
    public MutableSet<T> asUnmodifiable() {
        return UnmodifiableMutableSet.of(this);
    }

    @Override
    public MutableSet<T> asSynchronized() {
        return SynchronizedMutableSet.of(this);
    }

    @Override
    public boolean removeAllIterable(Iterable<?> iterable) {
        boolean changed = false;
        for (Object each : iterable) {
            changed |= this.remove(each);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.retainAllIterable(collection);
    }

    @Override
    public <V> MutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        return this.groupByUniqueKey(function, UnifiedMap.newMap(this.size()));
    }

    @Override
    @Deprecated
    public <S> MutableSet<Pair<T, S>> zip(Iterable<S> that) {
        if (that instanceof Collection || that instanceof RichIterable) {
            int thatSize = Iterate.sizeOf(that);
            UnifiedSet target = UnifiedSet.newSet(Math.min(this.size(), thatSize));
            return this.zip(that, target);
        }
        return this.zip(that, UnifiedSet.newSet());
    }

    @Override
    @Deprecated
    public MutableSet<Pair<T, Integer>> zipWithIndex() {
        return this.zipWithIndex(Sets.mutable.withInitialCapacity(this.size()));
    }

    @Override
    public RichIterable<RichIterable<T>> chunk(int size) {
        return MutableCollectionIterate.chunk(this, size);
    }

    @Override
    public MutableSet<T> union(SetIterable<? extends T> set) {
        return (MutableSet)SetIterables.unionInto(this, set, this.newEmpty());
    }

    @Override
    public <R extends Set<T>> R unionInto(SetIterable<? extends T> set, R targetSet) {
        return SetIterables.unionInto(this, set, targetSet);
    }

    @Override
    public MutableSet<T> intersect(SetIterable<? extends T> set) {
        return (MutableSet)SetIterables.intersectInto(this, set, this.newEmpty());
    }

    @Override
    public <R extends Set<T>> R intersectInto(SetIterable<? extends T> set, R targetSet) {
        return SetIterables.intersectInto(this, set, targetSet);
    }

    @Override
    public MutableSet<T> difference(SetIterable<? extends T> subtrahendSet) {
        return (MutableSet)SetIterables.differenceInto(this, subtrahendSet, this.newEmpty());
    }

    @Override
    public <R extends Set<T>> R differenceInto(SetIterable<? extends T> subtrahendSet, R targetSet) {
        return SetIterables.differenceInto(this, subtrahendSet, targetSet);
    }

    @Override
    public MutableSet<T> symmetricDifference(SetIterable<? extends T> setB) {
        return (MutableSet)SetIterables.symmetricDifferenceInto(this, setB, this.newEmpty());
    }

    @Override
    public <R extends Set<T>> R symmetricDifferenceInto(SetIterable<? extends T> set, R targetSet) {
        return SetIterables.symmetricDifferenceInto(this, set, targetSet);
    }

    @Override
    public boolean isSubsetOf(SetIterable<? extends T> candidateSuperset) {
        return SetIterables.isSubsetOf(this, candidateSuperset);
    }

    @Override
    public boolean isProperSubsetOf(SetIterable<? extends T> candidateSuperset) {
        return SetIterables.isProperSubsetOf(this, candidateSuperset);
    }

    @Override
    public MutableSet<UnsortedSetIterable<T>> powerSet() {
        return SetIterables.powerSet(this);
    }

    @Override
    public <B> LazyIterable<Pair<T, B>> cartesianProduct(SetIterable<B> set) {
        return SetIterables.cartesianProduct(this, set);
    }
}

