/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.immutable;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Sets;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.ImmutableSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.MutableSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.procedure.checked.CheckedProcedure;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

class ImmutableSetSerializationProxy<T>
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private ImmutableSet<T> set;

    public ImmutableSetSerializationProxy() {
    }

    ImmutableSetSerializationProxy(ImmutableSet<T> set) {
        this.set = set;
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeInt(this.set.size());
        try {
            this.set.forEach(new CheckedProcedure<T>(){

                @Override
                public void safeValue(T value) throws IOException {
                    out.writeObject(value);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        MutableSet deserializedSet = Sets.mutable.withInitialCapacity(size);
        for (int i = 0; i < size; ++i) {
            deserializedSet.add(in.readObject());
        }
        this.set = deserializedSet.toImmutable();
    }

    protected Object readResolve() {
        return this.set;
    }
}

