/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.immutable.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.CharIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.RichIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Lists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.CharSets;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.iterator.CharIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.MutableList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.CharSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.ImmutableCharSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.MutableCharSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.primitive.AbstractCharSet;

public abstract class AbstractImmutableCharSet
extends AbstractCharSet
implements ImmutableCharSet {
    @Override
    public ImmutableCharSet newWith(char element) {
        return CharHashSet.newSet(this).with(element).toImmutable();
    }

    @Override
    public ImmutableCharSet newWithout(char element) {
        return CharHashSet.newSet(this).without(element).toImmutable();
    }

    @Override
    public ImmutableCharSet newWithAll(CharIterable elements) {
        return CharHashSet.newSet(this).withAll(elements).toImmutable();
    }

    @Override
    public ImmutableCharSet newWithoutAll(CharIterable elements) {
        return CharHashSet.newSet(this).withoutAll(elements).toImmutable();
    }

    @Override
    public CharSet freeze() {
        return this;
    }

    @Override
    public ImmutableCharSet toImmutable() {
        return this;
    }

    @Override
    public RichIterable<CharIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add(this);
            } else {
                CharIterator iterator = this.charIterator();
                while (iterator.hasNext()) {
                    MutableCharSet batch = CharSets.mutable.empty();
                    for (int i = 0; i < size && iterator.hasNext(); ++i) {
                        batch.add(iterator.next());
                    }
                    result.add(batch.toImmutable());
                }
            }
        }
        return result.toImmutable();
    }
}

