/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.immutable.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.FloatIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.RichIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Lists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.FloatSets;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.iterator.FloatIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.MutableList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.FloatSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.ImmutableFloatSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.MutableFloatSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.primitive.AbstractFloatSet;

public abstract class AbstractImmutableFloatSet
extends AbstractFloatSet
implements ImmutableFloatSet {
    @Override
    public ImmutableFloatSet newWith(float element) {
        return FloatHashSet.newSet(this).with(element).toImmutable();
    }

    @Override
    public ImmutableFloatSet newWithout(float element) {
        return FloatHashSet.newSet(this).without(element).toImmutable();
    }

    @Override
    public ImmutableFloatSet newWithAll(FloatIterable elements) {
        return FloatHashSet.newSet(this).withAll(elements).toImmutable();
    }

    @Override
    public ImmutableFloatSet newWithoutAll(FloatIterable elements) {
        return FloatHashSet.newSet(this).withoutAll(elements).toImmutable();
    }

    @Override
    public FloatSet freeze() {
        return this;
    }

    @Override
    public ImmutableFloatSet toImmutable() {
        return this;
    }

    @Override
    public RichIterable<FloatIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add(this);
            } else {
                FloatIterator iterator = this.floatIterator();
                while (iterator.hasNext()) {
                    MutableFloatSet batch = FloatSets.mutable.empty();
                    for (int i = 0; i < size && iterator.hasNext(); ++i) {
                        batch.add(iterator.next());
                    }
                    result.add(batch.toImmutable());
                }
            }
        }
        return result.toImmutable();
    }
}

