/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.immutable.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.RichIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.ShortIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Lists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.primitive.ShortSets;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.iterator.ShortIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.MutableList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.ImmutableShortSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.MutableShortSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.ShortSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.primitive.AbstractShortSet;

public abstract class AbstractImmutableShortSet
extends AbstractShortSet
implements ImmutableShortSet {
    @Override
    public ImmutableShortSet newWith(short element) {
        return ShortHashSet.newSet(this).with(element).toImmutable();
    }

    @Override
    public ImmutableShortSet newWithout(short element) {
        return ShortHashSet.newSet(this).without(element).toImmutable();
    }

    @Override
    public ImmutableShortSet newWithAll(ShortIterable elements) {
        return ShortHashSet.newSet(this).withAll(elements).toImmutable();
    }

    @Override
    public ImmutableShortSet newWithoutAll(ShortIterable elements) {
        return ShortHashSet.newSet(this).withoutAll(elements).toImmutable();
    }

    @Override
    public ShortSet freeze() {
        return this;
    }

    @Override
    public ImmutableShortSet toImmutable() {
        return this;
    }

    @Override
    public RichIterable<ShortIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add(this);
            } else {
                ShortIterator iterator = this.shortIterator();
                while (iterator.hasNext()) {
                    MutableShortSet batch = ShortSets.mutable.empty();
                    for (int i = 0; i < size && iterator.hasNext(); ++i) {
                        batch.add(iterator.next());
                    }
                    result.add(batch.toImmutable());
                }
            }
        }
        return result.toImmutable();
    }
}

