/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.immutable.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.ByteSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedByteProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class ImmutableByteSetSerializationProxy
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private ByteSet set;

    public ImmutableByteSetSerializationProxy() {
    }

    public ImmutableByteSetSerializationProxy(ByteSet set) {
        this.set = set;
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeInt(this.set.size());
        try {
            this.set.forEach(new CheckedByteProcedure(){

                @Override
                public void safeValue(byte item) throws Exception {
                    out.writeByte(item);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        ByteHashSet deserializedSet = new ByteHashSet(size);
        for (int i = 0; i < size; ++i) {
            deserializedSet.add(in.readByte());
        }
        this.set = deserializedSet;
    }

    private Object readResolve() {
        return this.set.toImmutable();
    }
}

