/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.mutable.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.CharIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.set.primitive.MutableCharSetFactory;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.primitive.MutableCharSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.factory.primitive.CharSets;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.Iterate;

public class MutableCharSetFactoryImpl
implements MutableCharSetFactory {
    public static final MutableCharSetFactory INSTANCE = new MutableCharSetFactoryImpl();

    @Override
    public MutableCharSet empty() {
        return new CharHashSet();
    }

    @Override
    public MutableCharSet of() {
        return this.empty();
    }

    @Override
    public MutableCharSet with() {
        return this.empty();
    }

    @Override
    public MutableCharSet withInitialCapacity(int capacity) {
        return new CharHashSet(capacity);
    }

    @Override
    public MutableCharSet of(char ... items) {
        return this.with(items);
    }

    @Override
    public MutableCharSet with(char ... items) {
        if (items == null || items.length == 0) {
            return this.empty();
        }
        return CharHashSet.newSetWith(items);
    }

    @Override
    public MutableCharSet ofAll(CharIterable items) {
        return this.withAll(items);
    }

    @Override
    public MutableCharSet withAll(CharIterable items) {
        return CharHashSet.newSet(items);
    }

    @Override
    public MutableCharSet ofAll(Iterable<Character> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public MutableCharSet withAll(Iterable<Character> iterable) {
        return Iterate.collectChar(iterable, Character::charValue, CharSets.mutable.empty());
    }
}

