/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.sorted.immutable;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.sorted.ImmutableSortedSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.procedure.checked.CheckedProcedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.sorted.mutable.TreeSortedSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Comparator;

class ImmutableSortedSetSerializationProxy<T>
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private ImmutableSortedSet<T> set;

    public ImmutableSortedSetSerializationProxy() {
    }

    ImmutableSortedSetSerializationProxy(ImmutableSortedSet<T> set) {
        this.set = set;
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeObject(this.set.comparator());
        out.writeInt(this.set.size());
        try {
            this.set.forEach(new CheckedProcedure<T>(){

                @Override
                public void safeValue(T each) throws IOException {
                    out.writeObject(each);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Comparator comparator = (Comparator)in.readObject();
        int size = in.readInt();
        TreeSortedSet deserializedSet = new TreeSortedSet(comparator);
        for (int i = 0; i < size; ++i) {
            deserializedSet.add(in.readObject());
        }
        this.set = deserializedSet.toImmutable();
    }

    protected Object readResolve() {
        return this.set.toImmutable();
    }
}

