/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.stack.immutable.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.DoubleIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.stack.primitive.ImmutableDoubleStackFactory;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.stack.primitive.ImmutableDoubleStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.factory.primitive.DoubleStacks;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.stack.immutable.primitive.ImmutableDoubleArrayStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.stack.immutable.primitive.ImmutableDoubleEmptyStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.stack.immutable.primitive.ImmutableDoubleSingletonStack;
import java.util.stream.DoubleStream;

public class ImmutableDoubleStackFactoryImpl
implements ImmutableDoubleStackFactory {
    public static final ImmutableDoubleStackFactory INSTANCE = new ImmutableDoubleStackFactoryImpl();

    @Override
    public ImmutableDoubleStack empty() {
        return ImmutableDoubleEmptyStack.INSTANCE;
    }

    @Override
    public ImmutableDoubleStack of() {
        return this.empty();
    }

    @Override
    public ImmutableDoubleStack with() {
        return this.empty();
    }

    @Override
    public ImmutableDoubleStack of(double one) {
        return this.with(one);
    }

    @Override
    public ImmutableDoubleStack with(double one) {
        return new ImmutableDoubleSingletonStack(one);
    }

    @Override
    public ImmutableDoubleStack of(double ... items) {
        return this.with(items);
    }

    @Override
    public ImmutableDoubleStack with(double ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableDoubleArrayStack.newStackWith(items);
    }

    @Override
    public ImmutableDoubleStack ofAll(DoubleIterable items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableDoubleStack withAll(DoubleIterable items) {
        if (items instanceof ImmutableDoubleStack) {
            return (ImmutableDoubleStack)items;
        }
        return this.with(items.toArray());
    }

    @Override
    public ImmutableDoubleStack ofAll(Iterable<Double> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public ImmutableDoubleStack withAll(Iterable<Double> iterable) {
        return DoubleStacks.mutable.withAll(iterable).toImmutable();
    }

    @Override
    public ImmutableDoubleStack ofAllReversed(DoubleIterable items) {
        return this.withAllReversed(items);
    }

    @Override
    public ImmutableDoubleStack withAllReversed(DoubleIterable items) {
        if (items == null || items.isEmpty()) {
            return this.with();
        }
        if (items.size() == 1) {
            return this.with(items.toArray());
        }
        return ImmutableDoubleArrayStack.newStackFromTopToBottom(items);
    }

    @Override
    public ImmutableDoubleStack ofAll(DoubleStream items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableDoubleStack withAll(DoubleStream items) {
        return this.with(items.toArray());
    }
}

