/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.stack.mutable.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.LongIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.iterator.LongIterator;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.primitive.LongList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.primitive.MutableLongList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.stack.MutableStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.stack.primitive.ImmutableLongStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.stack.primitive.LongStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.stack.primitive.MutableLongStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.factory.primitive.LongStacks;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.stack.mutable.ArrayStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.stack.mutable.primitive.SynchronizedLongStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.stack.mutable.primitive.UnmodifiableLongStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.stack.primitive.AbstractLongStack;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class LongArrayStack
extends AbstractLongStack
implements MutableLongStack,
Externalizable {
    private static final long serialVersionUID = 1L;
    private transient LongArrayList delegate;

    public LongArrayStack() {
        this.delegate = new LongArrayList();
    }

    private LongArrayStack(int size) {
        this.delegate = new LongArrayList(size);
    }

    private LongArrayStack(long ... items) {
        this.delegate = new LongArrayList(items);
    }

    public static LongArrayStack newStackFromTopToBottom(long ... items) {
        LongArrayStack stack = new LongArrayStack(items.length);
        for (int i = items.length - 1; i >= 0; --i) {
            stack.push(items[i]);
        }
        return stack;
    }

    public static LongArrayStack newStackWith(long ... items) {
        return new LongArrayStack(items);
    }

    public static LongArrayStack newStack(LongIterable items) {
        LongArrayStack stack = new LongArrayStack(items.size());
        stack.delegate = LongArrayList.newList(items);
        return stack;
    }

    public static LongArrayStack newStackFromTopToBottom(LongIterable items) {
        LongArrayStack stack = new LongArrayStack(items.size());
        stack.delegate = LongArrayList.newList(items).reverseThis();
        return stack;
    }

    @Override
    protected LongArrayList getDelegate() {
        return this.delegate;
    }

    @Override
    public void push(long item) {
        this.delegate.add(item);
    }

    @Override
    public long pop() {
        this.checkEmptyStack();
        return this.delegate.removeAtIndex(this.delegate.size() - 1);
    }

    @Override
    public LongList pop(int count) {
        this.checkPositiveValueForCount(count);
        this.checkSizeLessThanCount(count);
        if (count == 0) {
            return new LongArrayList(0);
        }
        LongArrayList subList = new LongArrayList(count);
        while (count > 0) {
            subList.add(this.pop());
            --count;
        }
        return subList;
    }

    @Override
    public MutableLongStack select(LongPredicate predicate) {
        return LongArrayStack.newStackFromTopToBottom(this.delegate.asReversed().select(predicate));
    }

    @Override
    public MutableLongStack reject(LongPredicate predicate) {
        return LongArrayStack.newStackFromTopToBottom(this.delegate.asReversed().reject(predicate));
    }

    @Override
    public <V> MutableStack<V> collect(LongToObjectFunction<? extends V> function) {
        return ArrayStack.newStackFromTopToBottom(this.delegate.asReversed().collect((LongToObjectFunction)function));
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public MutableLongList toSortedList() {
        return LongArrayList.newList(this).sortThis();
    }

    @Override
    public MutableLongStack asUnmodifiable() {
        return new UnmodifiableLongStack(this);
    }

    @Override
    public MutableLongStack asSynchronized() {
        return new SynchronizedLongStack(this);
    }

    @Override
    public ImmutableLongStack toImmutable() {
        return LongStacks.immutable.withAll(this.delegate);
    }

    @Override
    public LongArrayStack newEmpty() {
        return new LongArrayStack();
    }

    @Override
    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof LongStack)) {
            return false;
        }
        LongStack stack = (LongStack)otherStack;
        if (this.size() != stack.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.peekAt(i) == stack.peekAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (int i = this.size() - 1; i >= 0; --i) {
            long item = this.delegate.get(i);
            hashCode = 31 * hashCode + (int)(item ^ item >>> 32);
        }
        return hashCode;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        LongIterator iterator = this.delegate.asReversed().longIterator();
        while (iterator.hasNext()) {
            long each = iterator.next();
            out.writeLong(each);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        long[] array = new long[size];
        for (int i = size - 1; i >= 0; --i) {
            array[i] = in.readLong();
        }
        this.delegate = LongArrayList.newListWith(array);
    }
}

