/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.stack.mutable.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.CharIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.stack.primitive.MutableCharStackFactory;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.stack.primitive.MutableCharStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.factory.primitive.CharStacks;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.stack.mutable.primitive.CharArrayStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.Iterate;

public class MutableCharStackFactoryImpl
implements MutableCharStackFactory {
    public static final MutableCharStackFactory INSTANCE = new MutableCharStackFactoryImpl();

    @Override
    public MutableCharStack empty() {
        return new CharArrayStack();
    }

    @Override
    public MutableCharStack of() {
        return this.empty();
    }

    @Override
    public MutableCharStack with() {
        return this.empty();
    }

    @Override
    public MutableCharStack of(char ... items) {
        return this.with(items);
    }

    @Override
    public MutableCharStack with(char ... items) {
        if (items.length == 0) {
            return this.empty();
        }
        return CharArrayStack.newStackWith(items);
    }

    @Override
    public MutableCharStack ofAll(CharIterable items) {
        return this.withAll(items);
    }

    @Override
    public MutableCharStack withAll(CharIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return CharArrayStack.newStack(items);
    }

    @Override
    public MutableCharStack ofAll(Iterable<Character> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public MutableCharStack withAll(Iterable<Character> iterable) {
        MutableCharStack stack = CharStacks.mutable.empty();
        Iterate.forEach(iterable, stack::push);
        return stack;
    }

    @Override
    public MutableCharStack ofAllReversed(CharIterable items) {
        return this.withAllReversed(items);
    }

    @Override
    public MutableCharStack withAllReversed(CharIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return CharArrayStack.newStackFromTopToBottom(items);
    }
}

