/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.stack.mutable.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.FloatIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.stack.primitive.MutableFloatStackFactory;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.stack.primitive.MutableFloatStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.factory.primitive.FloatStacks;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.stack.mutable.primitive.FloatArrayStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.Iterate;

public class MutableFloatStackFactoryImpl
implements MutableFloatStackFactory {
    public static final MutableFloatStackFactory INSTANCE = new MutableFloatStackFactoryImpl();

    @Override
    public MutableFloatStack empty() {
        return new FloatArrayStack();
    }

    @Override
    public MutableFloatStack of() {
        return this.empty();
    }

    @Override
    public MutableFloatStack with() {
        return this.empty();
    }

    @Override
    public MutableFloatStack of(float ... items) {
        return this.with(items);
    }

    @Override
    public MutableFloatStack with(float ... items) {
        if (items.length == 0) {
            return this.empty();
        }
        return FloatArrayStack.newStackWith(items);
    }

    @Override
    public MutableFloatStack ofAll(FloatIterable items) {
        return this.withAll(items);
    }

    @Override
    public MutableFloatStack withAll(FloatIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return FloatArrayStack.newStack(items);
    }

    @Override
    public MutableFloatStack ofAll(Iterable<Float> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public MutableFloatStack withAll(Iterable<Float> iterable) {
        MutableFloatStack stack = FloatStacks.mutable.empty();
        Iterate.forEach(iterable, stack::push);
        return stack;
    }

    @Override
    public MutableFloatStack ofAllReversed(FloatIterable items) {
        return this.withAllReversed(items);
    }

    @Override
    public MutableFloatStack withAllReversed(FloatIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return FloatArrayStack.newStackFromTopToBottom(items);
    }
}

