/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.tuple;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Lists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.FixedSizeList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.ImmutableList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.list.MutableList;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.tuple.Pair;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.tuple.Triple;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.tuple.Triplet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.tuple.Twin;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.tuple.PairImpl;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.tuple.TripleImpl;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.tuple.TripletImpl;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.tuple.TwinImpl;
import java.util.Map;

public final class Tuples {
    private Tuples() {
    }

    public static <K, V> Pair<K, V> pairFrom(Map.Entry<K, V> entry) {
        return Tuples.pair(entry.getKey(), entry.getValue());
    }

    public static <T> MutableList<T> pairToList(Pair<T, T> pair) {
        return Lists.mutable.with(pair.getOne(), pair.getTwo());
    }

    public static <T> FixedSizeList<T> pairToFixedSizeList(Pair<T, T> pair) {
        return Lists.fixedSize.with(pair.getOne(), pair.getTwo());
    }

    public static <T> ImmutableList<T> pairToImmutableList(Pair<T, T> pair) {
        return Lists.immutable.with(pair.getOne(), pair.getTwo());
    }

    public static <T> MutableList<T> tripleToList(Triple<T, T, T> triple) {
        return Lists.mutable.with(triple.getOne(), triple.getTwo(), triple.getThree());
    }

    public static <T> FixedSizeList<T> tripleToFixedSizeList(Triple<T, T, T> triple) {
        return Lists.fixedSize.with(triple.getOne(), triple.getTwo(), triple.getThree());
    }

    public static <T> ImmutableList<T> tripleToImmutableList(Triple<T, T, T> triple) {
        return Lists.immutable.with(triple.getOne(), triple.getTwo(), triple.getThree());
    }

    public static <T1, T2> Pair<T1, T2> pair(T1 one, T2 two) {
        return new PairImpl<T1, T2>(one, two);
    }

    public static <T> Twin<T> twin(T one, T two) {
        return new TwinImpl<T>(one, two);
    }

    public static <T> Twin<T> identicalTwin(T each) {
        return new TwinImpl<T>(each, each);
    }

    public static <T1, T2, T3> Triple<T1, T2, T3> triple(T1 one, T2 two, T3 three) {
        return new TripleImpl<T1, T2, T3>(one, two, three);
    }

    public static <T> Triplet<T> triplet(T one, T two, T three) {
        return new TripletImpl<T>(one, two, three);
    }

    public static <T> Triplet<T> identicalTriplet(T each) {
        return new TripletImpl<T>(each, each, each);
    }
}

