/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.tuple.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.tuple.primitive.FloatCharPair;

public class FloatCharPairImpl
implements FloatCharPair {
    private static final long serialVersionUID = 1L;
    private final float one;
    private final char two;

    FloatCharPairImpl(float newOne, char newTwo) {
        this.one = newOne;
        this.two = newTwo;
    }

    @Override
    public float getOne() {
        return this.one;
    }

    @Override
    public char getTwo() {
        return this.two;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FloatCharPair)) {
            return false;
        }
        FloatCharPair that = (FloatCharPair)o;
        return Float.compare(this.one, that.getOne()) == 0 && this.two == that.getTwo();
    }

    public int hashCode() {
        return 29 * Float.floatToIntBits(this.one) + this.two;
    }

    public String toString() {
        return this.one + ":" + this.two;
    }

    @Override
    public int compareTo(FloatCharPair that) {
        int i = Float.compare(this.one, that.getOne());
        if (i != 0) {
            return i;
        }
        return this.two - that.getTwo();
    }
}

