/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.tuple.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.tuple.primitive.ObjectFloatPair;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.factory.Comparators;

public class ObjectFloatPairImpl<T>
implements ObjectFloatPair<T> {
    private static final long serialVersionUID = 1L;
    private final T one;
    private final float two;

    ObjectFloatPairImpl(T newOne, float newTwo) {
        this.one = newOne;
        this.two = newTwo;
    }

    @Override
    public T getOne() {
        return this.one;
    }

    @Override
    public float getTwo() {
        return this.two;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectFloatPair)) {
            return false;
        }
        ObjectFloatPair that = (ObjectFloatPair)o;
        return Comparators.nullSafeEquals(this.one, that.getOne()) && Float.compare(this.two, that.getTwo()) == 0;
    }

    public int hashCode() {
        int result = this.one == null ? 0 : this.one.hashCode();
        result = 29 * result + Float.floatToIntBits(this.two);
        return result;
    }

    public String toString() {
        return this.one + ":" + this.two;
    }

    @Override
    public int compareTo(ObjectFloatPair<T> that) {
        int i = ((Comparable)this.one).compareTo(that.getOne());
        if (i != 0) {
            return i;
        }
        return Float.compare(this.two, that.getTwo());
    }
}

