/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.LazyIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.RichIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.function.Function2;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.predicate.Predicate;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.procedure.Procedure;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.Lists;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.tuple.Pair;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.ChunkIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.CollectIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.CompositeIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.DistinctIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.DropIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.DropWhileIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.FlatCollectIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.LazyIterableAdapter;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.RejectIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.SelectInstancesOfIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.SelectIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.TakeIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.TakeWhileIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.TapIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.ZipIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.lazy.ZipWithIndexIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.tuple.Tuples;

public final class LazyIterate {
    private static final LazyIterable<?> EMPTY_ITERABLE = Lists.immutable.empty().asLazy();

    private LazyIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <T> LazyIterable<T> adapt(Iterable<T> iterable) {
        return new LazyIterableAdapter<T>(iterable);
    }

    public static <T> LazyIterable<T> select(Iterable<T> iterable, Predicate<? super T> predicate) {
        return new SelectIterable<T>(iterable, predicate);
    }

    public static <T> LazyIterable<T> reject(Iterable<T> iterable, Predicate<? super T> predicate) {
        return new RejectIterable<T>(iterable, predicate);
    }

    public static <T> LazyIterable<T> selectInstancesOf(Iterable<?> iterable, Class<T> clazz) {
        return new SelectInstancesOfIterable<T>(iterable, clazz);
    }

    public static <T, V> LazyIterable<V> collect(Iterable<T> iterable, Function<? super T, ? extends V> function) {
        return new CollectIterable<T, V>(iterable, function);
    }

    public static <T, V> LazyIterable<V> flatCollect(Iterable<T> iterable, Function<? super T, ? extends Iterable<V>> function) {
        return new FlatCollectIterable(iterable, function);
    }

    public static <T, V> LazyIterable<V> collectIf(Iterable<T> iterable, Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return LazyIterate.select(iterable, predicate).collect((Function)function);
    }

    public static <T> LazyIterable<T> take(Iterable<T> iterable, int count) {
        return new TakeIterable<T>(iterable, count);
    }

    public static <T> LazyIterable<T> drop(Iterable<T> iterable, int count) {
        return new DropIterable<T>(iterable, count);
    }

    public static <T> LazyIterable<T> takeWhile(Iterable<T> iterable, Predicate<? super T> predicate) {
        return new TakeWhileIterable<T>(iterable, predicate);
    }

    public static <T> LazyIterable<T> dropWhile(Iterable<T> iterable, Predicate<? super T> predicate) {
        return new DropWhileIterable<T>(iterable, predicate);
    }

    public static <T> LazyIterable<T> distinct(Iterable<T> iterable) {
        return new DistinctIterable<T>(iterable);
    }

    public static <T> LazyIterable<T> concatenate(Iterable<T> ... iterables) {
        return CompositeIterable.with(iterables);
    }

    public static <T> LazyIterable<T> empty() {
        return EMPTY_ITERABLE;
    }

    public static <A, B> LazyIterable<Pair<A, B>> zip(Iterable<A> as, Iterable<B> bs) {
        return new ZipIterable<A, B>(as, bs);
    }

    public static <T> LazyIterable<Pair<T, Integer>> zipWithIndex(Iterable<T> iterable) {
        return new ZipWithIndexIterable<T>(iterable);
    }

    public static <T> LazyIterable<RichIterable<T>> chunk(Iterable<T> iterable, int size) {
        return new ChunkIterable<T>(iterable, size);
    }

    public static <T> LazyIterable<T> tap(Iterable<T> iterable, Procedure<? super T> procedure) {
        return new TapIterable<T>(iterable, procedure);
    }

    public static <A, B> LazyIterable<Pair<A, B>> cartesianProduct(Iterable<A> iterable1, Iterable<B> iterable2) {
        return LazyIterate.cartesianProduct(iterable1, iterable2, Tuples::pair);
    }

    public static <A, B, C> LazyIterable<C> cartesianProduct(Iterable<A> iterable1, Iterable<B> iterable2, Function2<? super A, ? super B, ? extends C> function) {
        return LazyIterate.flatCollect(iterable1, first -> LazyIterate.collect(iterable2, second -> function.value((Object)first, (Object)second)));
    }
}

