/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.spark.bigquery.BigQueryInsertableRelation$;
import com.google.cloud.spark.bigquery.BigQueryWriteHelper;
import com.google.cloud.spark.bigquery.SchemaConverters$;
import com.google.cloud.spark.bigquery.SparkBigQueryOptions;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.math.BigInteger;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.InsertableRelation;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t-a\u0001B\u0001\u0003\u00016\u0011!DQ5h#V,'/_%og\u0016\u0014H/\u00192mKJ+G.\u0019;j_:T!a\u0001\u0003\u0002\u0011\tLw-];fefT!!\u0002\u0004\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dA\u0011!B2m_V$'BA\u0005\u000b\u0003\u00199wn\\4mK*\t1\"A\u0002d_6\u001c\u0001aE\u0003\u0001\u001dmqB\u0005\u0005\u0002\u001035\t\u0001C\u0003\u0002\u0012%\u000591o\\;sG\u0016\u001c(BA\n\u0015\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000bUQ!AF\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0012aA8sO&\u0011!\u0004\u0005\u0002\r\u0005\u0006\u001cXMU3mCRLwN\u001c\t\u0003\u001fqI!!\b\t\u0003%%s7/\u001a:uC\ndWMU3mCRLwN\u001c\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\b!J|G-^2u!\tyR%\u0003\u0002'A\ta1+\u001a:jC2L'0\u00192mK\"A\u0001\u0006\u0001BK\u0002\u0013\u0005\u0011&\u0001\u0005cS\u001e\fV/\u001a:z+\u0005Q\u0003CA\u0016.\u001b\u0005a#BA\u0002\u0007\u0013\tqCF\u0001\u0005CS\u001e\fV/\u001a:z\u0011!\u0001\u0004A!E!\u0002\u0013Q\u0013!\u00032jOF+XM]=!\u0011!\u0011\u0004A!f\u0001\n\u0003\u0019\u0014AC:rY\u000e{g\u000e^3yiV\tA\u0007\u0005\u00026m5\t!#\u0003\u00028%\tQ1+\u0015'D_:$X\r\u001f;\t\u0011e\u0002!\u0011#Q\u0001\nQ\n1b]9m\u0007>tG/\u001a=uA!A1\b\u0001BK\u0002\u0013\u0005A(A\u0004paRLwN\\:\u0016\u0003u\u0002\"AP \u000e\u0003\tI!\u0001\u0011\u0002\u0003)M\u0003\u0018M]6CS\u001e\fV/\u001a:z\u001fB$\u0018n\u001c8t\u0011!\u0011\u0005A!E!\u0002\u0013i\u0014\u0001C8qi&|gn\u001d\u0011\t\u000b\u0011\u0003A\u0011A#\u0002\rqJg.\u001b;?)\u00111u\tS%\u0011\u0005y\u0002\u0001\"\u0002\u0015D\u0001\u0004Q\u0003\"\u0002\u001aD\u0001\u0004!\u0004\"B\u001eD\u0001\u0004i\u0004bB&\u0001\u0005\u0004%I\u0001T\u0001\u0007Y><w-\u001a:\u0016\u00035\u0003\"AT*\u000e\u0003=S!\u0001U)\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005IS\u0011\u0001\u0003;za\u0016\u001c\u0018MZ3\n\u0005Q{%A\u0002'pO\u001e,'\u000f\u0003\u0004W\u0001\u0001\u0006I!T\u0001\bY><w-\u001a:!\u0011\u0015A\u0006\u0001\"\u0011Z\u0003\u0019Ign]3siR\u0019!,X9\u0011\u0005}Y\u0016B\u0001/!\u0005\u0011)f.\u001b;\t\u000by;\u0006\u0019A0\u0002\t\u0011\fG/\u0019\t\u0003A:t!!\u00197\u000f\u0005\t\\gBA2k\u001d\t!\u0017N\u0004\u0002fQ6\taM\u0003\u0002h\u0019\u00051AH]8pizJ\u0011\u0001G\u0005\u0003-]I!!B\u000b\n\u0005M!\u0012BA7\u0013\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001c9\u0003\u0013\u0011\u000bG/\u0019$sC6,'BA7\u0013\u0011\u0015\u0011x\u000b1\u0001t\u0003%yg/\u001a:xe&$X\r\u0005\u0002 i&\u0011Q\u000f\t\u0002\b\u0005>|G.Z1o\u0011\u00159\b\u0001\"\u0001y\u0003\u0019)\u00070[:ugV\t1\u000fC\u0003{\u0001\u0011\u0005\u00010A\u0004jg\u0016k\u0007\u000f^=\t\u000bq\u0004A\u0011B?\u0002\u00199,XNY3s\u001f\u001a\u0014vn^:\u0016\u0003y\u0004BaH@\u0002\u0004%\u0019\u0011\u0011\u0001\u0011\u0003\r=\u0003H/[8o!\u0011\t)!a\u0004\u000e\u0005\u0005\u001d!\u0002BA\u0005\u0003\u0017\tA!\\1uQ*\u0011\u0011QB\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0012\u0005\u001d!A\u0003\"jO&sG/Z4fe\"9\u0011Q\u0003\u0001\u0005\n\u0005]\u0011\u0001C4fiR\u000b'\r\\3\u0016\u0005\u0005e\u0001\u0003B\u0010\u0000\u00037\u00012aKA\u000f\u0013\r\ty\u0002\f\u0002\u0006)\u0006\u0014G.\u001a\u0005\b\u0003G\u0001A\u0011IA\u0013\u0003\u0019\u00198\r[3nCV\u0011\u0011q\u0005\t\u0005\u0003S\ty#\u0004\u0002\u0002,)\u0019\u0011Q\u0006\n\u0002\u000bQL\b/Z:\n\t\u0005E\u00121\u0006\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\"CA\u001b\u0001\u0005\u0005I\u0011AA\u001c\u0003\u0011\u0019w\u000e]=\u0015\u000f\u0019\u000bI$a\u000f\u0002>!A\u0001&a\r\u0011\u0002\u0003\u0007!\u0006\u0003\u00053\u0003g\u0001\n\u00111\u00015\u0011!Y\u00141\u0007I\u0001\u0002\u0004i\u0004\"CA!\u0001E\u0005I\u0011AA\"\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u0012+\u0007)\n9e\u000b\u0002\u0002JA!\u00111JA+\u001b\t\tiE\u0003\u0003\u0002P\u0005E\u0013!C;oG\",7m[3e\u0015\r\t\u0019\u0006I\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA,\u0003\u001b\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\tY\u0006AI\u0001\n\u0003\ti&\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005}#f\u0001\u001b\u0002H!I\u00111\r\u0001\u0012\u0002\u0013\u0005\u0011QM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t9GK\u0002>\u0003\u000fB\u0011\"a\u001b\u0001\u0003\u0003%\t%!\u001c\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\u0007\u0005\u0003\u0002r\u0005]TBAA:\u0015\u0011\t)(a\u0003\u0002\t1\fgnZ\u0005\u0005\u0003s\n\u0019H\u0001\u0004TiJLgn\u001a\u0005\n\u0003{\u0002\u0011\u0011!C\u0001\u0003\u007f\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!!\u0011\u0007}\t\u0019)C\u0002\u0002\u0006\u0002\u00121!\u00138u\u0011%\tI\tAA\u0001\n\u0003\tY)\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u00055\u00151\u0013\t\u0004?\u0005=\u0015bAAIA\t\u0019\u0011I\\=\t\u0015\u0005U\u0015qQA\u0001\u0002\u0004\t\t)A\u0002yIEB\u0011\"!'\u0001\u0003\u0003%\t%a'\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!(\u0011\r\u0005}\u0015QUAG\u001b\t\t\tKC\u0002\u0002$\u0002\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9+!)\u0003\u0011%#XM]1u_JD\u0011\"a+\u0001\u0003\u0003%\t!!,\u0002\u0011\r\fg.R9vC2$2a]AX\u0011)\t)*!+\u0002\u0002\u0003\u0007\u0011Q\u0012\u0005\n\u0003g\u0003\u0011\u0011!C!\u0003k\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003\u0003C\u0011\"!/\u0001\u0003\u0003%\t%a/\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u001c\t\u0013\u0005}\u0006!!A\u0005B\u0005\u0005\u0017AB3rk\u0006d7\u000fF\u0002t\u0003\u0007D!\"!&\u0002>\u0006\u0005\t\u0019AAG\u000f%\t9MAA\u0001\u0012\u0003\tI-\u0001\u000eCS\u001e\fV/\u001a:z\u0013:\u001cXM\u001d;bE2,'+\u001a7bi&|g\u000eE\u0002?\u0003\u00174\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011QZ\n\u0006\u0003\u0017\fy\r\n\t\t\u0003#\f9N\u000b\u001b>\r6\u0011\u00111\u001b\u0006\u0004\u0003+\u0004\u0013a\u0002:v]RLW.Z\u0005\u0005\u00033\f\u0019NA\tBEN$(/Y2u\rVt7\r^5p]NBq\u0001RAf\t\u0003\ti\u000e\u0006\u0002\u0002J\"Q\u0011\u0011XAf\u0003\u0003%)%a/\t\u0015\u0005\r\u00181ZA\u0001\n\u0003\u000b)/A\u0003baBd\u0017\u0010F\u0004G\u0003O\fI/a;\t\r!\n\t\u000f1\u0001+\u0011\u0019\u0011\u0014\u0011\u001da\u0001i!11(!9A\u0002uB!\"a<\u0002L\u0006\u0005I\u0011QAy\u0003\u001d)h.\u00199qYf$B!a=\u0002|B!qd`A{!\u0019y\u0012q\u001f\u00165{%\u0019\u0011\u0011 \u0011\u0003\rQ+\b\u000f\\34\u0011%\ti0!<\u0002\u0002\u0003\u0007a)A\u0002yIAB!B!\u0001\u0002L\u0006\u0005I\u0011\u0002B\u0002\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\u0015\u0001\u0003BA9\u0005\u000fIAA!\u0003\u0002t\t1qJ\u00196fGR\u0004")
public class BigQueryInsertableRelation
extends BaseRelation
implements InsertableRelation,
Product,
Serializable {
    private final BigQuery bigQuery;
    private final SQLContext sqlContext;
    private final SparkBigQueryOptions options;
    private final Logger logger;

    public static Option<Tuple3<BigQuery, SQLContext, SparkBigQueryOptions>> unapply(BigQueryInsertableRelation bigQueryInsertableRelation) {
        return BigQueryInsertableRelation$.MODULE$.unapply(bigQueryInsertableRelation);
    }

    public static BigQueryInsertableRelation apply(BigQuery bigQuery, SQLContext sQLContext, SparkBigQueryOptions sparkBigQueryOptions) {
        return BigQueryInsertableRelation$.MODULE$.apply(bigQuery, sQLContext, sparkBigQueryOptions);
    }

    public static Function1<Tuple3<BigQuery, SQLContext, SparkBigQueryOptions>, BigQueryInsertableRelation> tupled() {
        return BigQueryInsertableRelation$.MODULE$.tupled();
    }

    public static Function1<BigQuery, Function1<SQLContext, Function1<SparkBigQueryOptions, BigQueryInsertableRelation>>> curried() {
        return BigQueryInsertableRelation$.MODULE$.curried();
    }

    public BigQuery bigQuery() {
        return this.bigQuery;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public SparkBigQueryOptions options() {
        return this.options;
    }

    private Logger logger() {
        return this.logger;
    }

    public void insert(Dataset<Row> data, boolean overwrite) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("insert data={}, overwrite={}", new Object[]{data, BoxesRunTime.boxToBoolean((boolean)overwrite)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        SaveMode saveMode = overwrite ? SaveMode.Overwrite : SaveMode.Append;
        BigQueryWriteHelper helper = new BigQueryWriteHelper(this.bigQuery(), this.sqlContext(), saveMode, this.options(), data);
        helper.writeDataFrameToBigQuery();
    }

    public boolean exists() {
        Option<Table> table = this.getTable();
        return table.isDefined();
    }

    public boolean isEmpty() {
        return BoxesRunTime.unboxToBoolean((Object)this.numberOfRows().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(BigInteger n) {
                return n.longValue() == 0L;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return true;
            }
        }));
    }

    private Option<BigInteger> numberOfRows() {
        return this.getTable().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BigInteger apply(Table t) {
                return t.getNumRows();
            }
        });
    }

    private Option<Table> getTable() {
        return Option$.MODULE$.apply((Object)this.bigQuery().getTable(this.options().tableId(), new BigQuery.TableOption[0]));
    }

    public StructType schema() {
        Table tableInfo = this.bigQuery().getTable(this.options().tableId(), new BigQuery.TableOption[0]);
        TableDefinition tableDefinition = tableInfo.getDefinition();
        return SchemaConverters$.MODULE$.toSpark(tableDefinition.getSchema());
    }

    public BigQueryInsertableRelation copy(BigQuery bigQuery, SQLContext sqlContext, SparkBigQueryOptions options) {
        return new BigQueryInsertableRelation(bigQuery, sqlContext, options);
    }

    public BigQuery copy$default$1() {
        return this.bigQuery();
    }

    public SQLContext copy$default$2() {
        return this.sqlContext();
    }

    public SparkBigQueryOptions copy$default$3() {
        return this.options();
    }

    public String productPrefix() {
        return "BigQueryInsertableRelation";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        SparkBigQueryOptions sparkBigQueryOptions;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                sparkBigQueryOptions = this.options();
                break;
            }
            case 1: {
                sparkBigQueryOptions = this.sqlContext();
                break;
            }
            case 0: {
                sparkBigQueryOptions = this.bigQuery();
            }
        }
        return sparkBigQueryOptions;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BigQueryInsertableRelation;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BigQueryInsertableRelation)) return false;
        boolean bl = true;
        if (!bl) return false;
        BigQueryInsertableRelation bigQueryInsertableRelation = (BigQueryInsertableRelation)((Object)x$1);
        BigQuery bigQuery = this.bigQuery();
        BigQuery bigQuery2 = bigQueryInsertableRelation.bigQuery();
        if (bigQuery == null) {
            if (bigQuery2 != null) {
                return false;
            }
        } else if (!bigQuery.equals(bigQuery2)) return false;
        SQLContext sQLContext = this.sqlContext();
        SQLContext sQLContext2 = bigQueryInsertableRelation.sqlContext();
        if (sQLContext == null) {
            if (sQLContext2 != null) {
                return false;
            }
        } else if (!sQLContext.equals(sQLContext2)) return false;
        SparkBigQueryOptions sparkBigQueryOptions = this.options();
        SparkBigQueryOptions sparkBigQueryOptions2 = bigQueryInsertableRelation.options();
        if (sparkBigQueryOptions == null) {
            if (sparkBigQueryOptions2 != null) {
                return false;
            }
        } else if (!((Object)sparkBigQueryOptions).equals(sparkBigQueryOptions2)) return false;
        if (!bigQueryInsertableRelation.canEqual((Object)this)) return false;
        return true;
    }

    public BigQueryInsertableRelation(BigQuery bigQuery, SQLContext sqlContext, SparkBigQueryOptions options) {
        this.bigQuery = bigQuery;
        this.sqlContext = sqlContext;
        this.options = options;
        Product.class.$init$((Product)this);
        this.logger = Logger$.MODULE$.apply(((Object)((Object)this)).getClass());
    }
}

