/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.BigQueryError;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.TableId;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.runtime.Nothing$;
import scala.util.matching.Regex;

public final class BigQueryUtil$ {
    public static final BigQueryUtil$ MODULE$;
    private final String PROJECT_PATTERN;
    private final String DATASET_PATTERN;
    private final String TABLE_PATTERN;
    private final Regex QUALIFIED_TABLE_REGEX;
    private final Seq<String> InternalErrorMessages;

    static {
        new BigQueryUtil$();
    }

    private String PROJECT_PATTERN() {
        return this.PROJECT_PATTERN;
    }

    private String DATASET_PATTERN() {
        return this.DATASET_PATTERN;
    }

    private String TABLE_PATTERN() {
        return this.TABLE_PATTERN;
    }

    public Regex QUALIFIED_TABLE_REGEX() {
        return this.QUALIFIED_TABLE_REGEX;
    }

    public String friendlyTableName(TableId tableId) {
        Tuple3 tuple3;
        block4: {
            String string;
            block3: {
                block2: {
                    tuple3 = new Tuple3((Object)Option$.MODULE$.apply((Object)tableId.getProject()), (Object)tableId.getDataset(), (Object)tableId.getTable());
                    if (tuple3 == null) break block2;
                    Option option = (Option)tuple3._1();
                    String dataset = (String)tuple3._2();
                    String table = (String)tuple3._3();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String project = (String)some.x();
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{project, dataset, table}));
                    break block3;
                }
                if (tuple3 == null) break block4;
                Option option = (Option)tuple3._1();
                String dataset = (String)tuple3._2();
                String table = (String)tuple3._3();
                if (!None$.MODULE$.equals(option)) break block4;
                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataset, table}));
            }
            return string;
        }
        throw new MatchError((Object)tuple3);
    }

    public TableId parseTableId(String rawTable, Option<String> dataset, Option<String> project) {
        String string = rawTable;
        Option option = this.QUALIFIED_TABLE_REGEX().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(5) == 0) {
            String p = (String)((LinearSeqOptimized)option.get()).apply(2);
            String d = (String)((LinearSeqOptimized)option.get()).apply(3);
            String t = (String)((LinearSeqOptimized)option.get()).apply(4);
            Tuple3 tuple3 = new Tuple3((Object)Option$.MODULE$.apply((Object)p), (Object)Option$.MODULE$.apply((Object)d), (Object)t);
            Tuple3 tuple32 = tuple3;
            if (tuple32 != null) {
                Tuple3 tuple33;
                Option parsedProject = (Option)tuple32._1();
                Option parsedDataset = (Option)tuple32._2();
                String table = (String)tuple32._3();
                Tuple3 tuple34 = tuple33 = new Tuple3((Object)parsedProject, (Object)parsedDataset, (Object)table);
                Option parsedProject2 = (Option)tuple34._1();
                Option parsedDataset2 = (Option)tuple34._2();
                String table2 = (String)tuple34._3();
                String actualDataset = (String)parsedDataset2.orElse((Function0)new Serializable(dataset){
                    public static final long serialVersionUID = 0L;
                    private final Option dataset$1;

                    public final Option<String> apply() {
                        return this.dataset$1;
                    }
                    {
                        this.dataset$1 = dataset$1;
                    }
                }).getOrElse((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Nothing$ apply() {
                        throw new IllegalArgumentException("'dataset' not parsed or provided.");
                    }
                });
                return (TableId)parsedProject2.orElse((Function0)new Serializable(project){
                    public static final long serialVersionUID = 0L;
                    private final Option project$1;

                    public final Option<String> apply() {
                        return this.project$1;
                    }
                    {
                        this.project$1 = project$1;
                    }
                }).map((Function1)new Serializable(table2, actualDataset){
                    public static final long serialVersionUID = 0L;
                    private final String table$1;
                    private final String actualDataset$1;

                    public final TableId apply(String p) {
                        return TableId.of((String)p, (String)this.actualDataset$1, (String)this.table$1);
                    }
                    {
                        this.table$1 = table$1;
                        this.actualDataset$1 = actualDataset$1;
                    }
                }).getOrElse((Function0)new Serializable(table2, actualDataset){
                    public static final long serialVersionUID = 0L;
                    private final String table$1;
                    private final String actualDataset$1;

                    public final TableId apply() {
                        return TableId.of((String)this.actualDataset$1, (String)this.table$1);
                    }
                    {
                        this.table$1 = table$1;
                        this.actualDataset$1 = actualDataset$1;
                    }
                });
            }
            throw new MatchError((Object)tuple32);
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid Table ID '", "'. Must match '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rawTable, this.QUALIFIED_TABLE_REGEX()})));
    }

    public Option<String> parseTableId$default$2() {
        return None$.MODULE$;
    }

    public Option<String> parseTableId$default$3() {
        return None$.MODULE$;
    }

    public Option<String> noneIfEmpty(String s) {
        return Option$.MODULE$.apply((Object)s).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return x$2.trim().isEmpty();
            }
        });
    }

    public void convertAndThrow(BigQueryError error) {
        throw new BigQueryException(0, error.getMessage(), error);
    }

    public boolean isRetryable(Throwable cause) {
        Throwable c = cause;
        while (c != null) {
            Throwable throwable;
            if (this.isRetryableInternalError(throwable)) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    public Seq<String> InternalErrorMessages() {
        return this.InternalErrorMessages;
    }

    public boolean isRetryableInternalError(Throwable cause) {
        boolean bl;
        Throwable throwable = cause;
        if (throwable instanceof StatusRuntimeException) {
            StatusRuntimeException statusRuntimeException = (StatusRuntimeException)throwable;
            Status.Code code = statusRuntimeException.getStatus().getCode();
            Status.Code code2 = Status.Code.INTERNAL;
            bl = !(code != null ? !code.equals(code2) : code2 != null) && this.InternalErrorMessages().exists((Function1)new Serializable(cause){
                public static final long serialVersionUID = 0L;
                private final Throwable cause$1;

                public final boolean apply(String errorMsg) {
                    return this.cause$1.getMessage().contains(errorMsg);
                }
                {
                    this.cause$1 = cause$1;
                }
            });
        } else {
            bl = false;
        }
        return bl;
    }

    private BigQueryUtil$() {
        MODULE$ = this;
        this.PROJECT_PATTERN = "\\S+";
        this.DATASET_PATTERN = "\\w+";
        this.TABLE_PATTERN = "[\\S&&[^.:]]+";
        this.QUALIFIED_TABLE_REGEX = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"^(((", ")[:.])?(", ")\\\\.)?(", ")$"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.PROJECT_PATTERN(), this.DATASET_PATTERN(), this.TABLE_PATTERN()})))).r();
        this.InternalErrorMessages = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HTTP/2 error code: INTERNAL_ERROR", "Connection closed with unknown cause", "Received unexpected EOS on DATA frame from server"}));
    }
}

