/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.RetryOption;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.LoadJobConfiguration;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.spark.bigquery.BigQueryUtil$;
import com.google.cloud.spark.bigquery.BigQueryWriteHelper$;
import com.google.cloud.spark.bigquery.IntermediateDataCleaner;
import com.google.cloud.spark.bigquery.SparkBigQueryOptions;
import com.google.cloud.spark.bigquery.ToIterator;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t-d\u0001B\u0001\u0003\u00016\u00111CQ5h#V,'/_,sSR,\u0007*\u001a7qKJT!a\u0001\u0003\u0002\u0011\tLw-];fefT!!\u0002\u0004\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dA\u0011!B2m_V$'BA\u0005\u000b\u0003\u00199wn\\4mK*\t1\"A\u0002d_6\u001c\u0001a\u0005\u0003\u0001\u001dQ9\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u0010+%\u0011a\u0003\u0005\u0002\b!J|G-^2u!\ty\u0001$\u0003\u0002\u001a!\ta1+\u001a:jC2L'0\u00192mK\"A1\u0004\u0001BK\u0002\u0013\u0005A$\u0001\u0005cS\u001e\fV/\u001a:z+\u0005i\u0002C\u0001\u0010!\u001b\u0005y\"BA\u0002\u0007\u0013\t\tsD\u0001\u0005CS\u001e\fV/\u001a:z\u0011!\u0019\u0003A!E!\u0002\u0013i\u0012!\u00032jOF+XM]=!\u0011!)\u0003A!f\u0001\n\u00031\u0013AC:rY\u000e{g\u000e^3yiV\tq\u0005\u0005\u0002)a5\t\u0011F\u0003\u0002+W\u0005\u00191/\u001d7\u000b\u0005\u0015a#BA\u0017/\u0003\u0019\t\u0007/Y2iK*\tq&A\u0002pe\u001eL!!M\u0015\u0003\u0015M\u000bFjQ8oi\u0016DH\u000f\u0003\u00054\u0001\tE\t\u0015!\u0003(\u0003-\u0019\u0018\u000f\\\"p]R,\u0007\u0010\u001e\u0011\t\u0011U\u0002!Q3A\u0005\u0002Y\n\u0001b]1wK6{G-Z\u000b\u0002oA\u0011\u0001\u0006O\u0005\u0003s%\u0012\u0001bU1wK6{G-\u001a\u0005\tw\u0001\u0011\t\u0012)A\u0005o\u0005I1/\u0019<f\u001b>$W\r\t\u0005\t{\u0001\u0011)\u001a!C\u0001}\u00059q\u000e\u001d;j_:\u001cX#A \u0011\u0005\u0001\u000bU\"\u0001\u0002\n\u0005\t\u0013!\u0001F*qCJ\\')[4Rk\u0016\u0014\u0018p\u00149uS>t7\u000f\u0003\u0005E\u0001\tE\t\u0015!\u0003@\u0003!y\u0007\u000f^5p]N\u0004\u0003\u0002\u0003$\u0001\u0005+\u0007I\u0011A$\u0002\t\u0011\fG/Y\u000b\u0002\u0011B\u0011\u0011j\u0016\b\u0003\u0015Vs!a\u0013+\u000f\u00051\u001bfBA'S\u001d\tq\u0015+D\u0001P\u0015\t\u0001F\"\u0001\u0004=e>|GOP\u0005\u0002_%\u0011QFL\u0005\u0003\u000b1J!AK\u0016\n\u0005YK\u0013a\u00029bG.\fw-Z\u0005\u00031f\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005YK\u0003\u0002C.\u0001\u0005#\u0005\u000b\u0011\u0002%\u0002\u000b\u0011\fG/\u0019\u0011\t\u000bu\u0003A\u0011\u00010\u0002\rqJg.\u001b;?)\u0019y\u0006-\u00192dIB\u0011\u0001\t\u0001\u0005\u00067q\u0003\r!\b\u0005\u0006Kq\u0003\ra\n\u0005\u0006kq\u0003\ra\u000e\u0005\u0006{q\u0003\ra\u0010\u0005\u0006\rr\u0003\r\u0001\u0013\u0005\bM\u0002\u0011\r\u0011\"\u0003h\u0003\u0019awnZ4feV\t\u0001\u000e\u0005\u0002j]6\t!N\u0003\u0002lY\u0006a1oY1mC2|wmZ5oO*\u0011QNC\u0001\tif\u0004Xm]1gK&\u0011qN\u001b\u0002\u0007\u0019><w-\u001a:\t\rE\u0004\u0001\u0015!\u0003i\u0003\u001dawnZ4fe\u0002Bqa\u001d\u0001C\u0002\u0013\u0005A/\u0001\u0003d_:4W#A;\u0011\u0005YTX\"A<\u000b\u0005MD(BA=-\u0003\u0019A\u0017\rZ8pa&\u00111p\u001e\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\ru\u0004\u0001\u0015!\u0003v\u0003\u0015\u0019wN\u001c4!\u0011!y\bA1A\u0005\u0002\u0005\u0005\u0011\u0001\u0005;f[B|'/\u0019:z\u000f\u000e\u001c\b+\u0019;i+\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tI\u0001_\u0001\u0003MNLA!!\u0004\u0002\b\t!\u0001+\u0019;i\u0011!\t\t\u0002\u0001Q\u0001\n\u0005\r\u0011!\u0005;f[B|'/\u0019:z\u000f\u000e\u001c\b+\u0019;iA!I\u0011Q\u0003\u0001C\u0002\u0013\u0005\u0011qC\u0001\u001bg\u00064X-T8eKR{wK]5uK\u0012K7\u000f]8tSRLwN\\\u000b\u0003\u00033\u0001r!a\u0007\u0002&]\nI#\u0004\u0002\u0002\u001e)!\u0011qDA\u0011\u0003%IW.\\;uC\ndWMC\u0002\u0002$A\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9#!\b\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002,\u0005ERBAA\u0017\u0015\r\tycH\u0001\b\u0015>\u0014\u0017J\u001c4p\u0013\u0011\t\u0019$!\f\u0003!]\u0013\u0018\u000e^3ESN\u0004xn]5uS>t\u0007\u0002CA\u001c\u0001\u0001\u0006I!!\u0007\u00027M\fg/Z'pI\u0016$vn\u0016:ji\u0016$\u0015n\u001d9pg&$\u0018n\u001c8!\u0011\u001d\tY\u0004\u0001C\u0001\u0003{\t\u0001d\u001e:ji\u0016$\u0015\r^1Ge\u0006lW\rV8CS\u001e\fV/\u001a:z+\t\ty\u0004E\u0002\u0010\u0003\u0003J1!a\u0011\u0011\u0005\u0011)f.\u001b;\t\u000f\u0005\u001d\u0003\u0001\"\u0001\u0002J\u0005\u0011Bn\\1e\t\u0006$\u0018\rV8CS\u001e\fV/\u001a:z)\t\ty\u0004C\u0004\u0002N\u0001!\t!a\u0014\u0002#\u0019\u0014\u0018.\u001a8eYf$\u0016M\u00197f\u001d\u0006lW-\u0006\u0002\u0002RA!\u00111KA-\u001d\ry\u0011QK\u0005\u0004\u0003/\u0002\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002\\\u0005u#AB*ue&twMC\u0002\u0002XAAq!!\u0019\u0001\t\u0003\ti$\u0001\u000bdY\u0016\fg\u000eV3naJ\f'/_$dgB\u000bG\u000f\u001b\u0005\b\u0003K\u0002A\u0011BA4\u0003i\u0019'/Z1uKR+W\u000e]8sCJL\b+\u0019;i\t\u0016dW\r^3s+\t\tI\u0007E\u0002A\u0003WJ1!!\u001c\u0003\u0005]Ie\u000e^3s[\u0016$\u0017.\u0019;f\t\u0006$\u0018m\u00117fC:,'\u000fC\u0004\u0002r\u0001!\t!!\u0010\u0002\u001dY,'/\u001b4z'\u00064X-T8eK\"I\u0011Q\u000f\u0001\u0002\u0002\u0013\u0005\u0011qO\u0001\u0005G>\u0004\u0018\u0010F\u0006`\u0003s\nY(! \u0002\u0000\u0005\u0005\u0005\u0002C\u000e\u0002tA\u0005\t\u0019A\u000f\t\u0011\u0015\n\u0019\b%AA\u0002\u001dB\u0001\"NA:!\u0003\u0005\ra\u000e\u0005\t{\u0005M\u0004\u0013!a\u0001\u007f!Aa)a\u001d\u0011\u0002\u0003\u0007\u0001\nC\u0005\u0002\u0006\u0002\t\n\u0011\"\u0001\u0002\b\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAEU\ri\u00121R\u0016\u0003\u0003\u001b\u0003B!a$\u0002\u001a6\u0011\u0011\u0011\u0013\u0006\u0005\u0003'\u000b)*A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u0013\t\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001c\u0006E%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011q\u0014\u0001\u0012\u0002\u0013\u0005\u0011\u0011U\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t\u0019KK\u0002(\u0003\u0017C\u0011\"a*\u0001#\u0003%\t!!+\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0016\u0016\u0004o\u0005-\u0005\"CAX\u0001E\u0005I\u0011AAY\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"!a-+\u0007}\nY\tC\u0005\u00028\u0002\t\n\u0011\"\u0001\u0002:\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012*TCAA^U\rA\u00151\u0012\u0005\n\u0003\u007f\u0003\u0011\u0011!C!\u0003\u0003\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAb!\u0011\t)-a4\u000e\u0005\u0005\u001d'\u0002BAe\u0003\u0017\fA\u0001\\1oO*\u0011\u0011QZ\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\\\u0005\u001d\u0007\"CAj\u0001\u0005\u0005I\u0011AAk\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t9\u000eE\u0002\u0010\u00033L1!a7\u0011\u0005\rIe\u000e\u001e\u0005\n\u0003?\u0004\u0011\u0011!C\u0001\u0003C\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002d\u0006%\bcA\b\u0002f&\u0019\u0011q\u001d\t\u0003\u0007\u0005s\u0017\u0010\u0003\u0006\u0002l\u0006u\u0017\u0011!a\u0001\u0003/\f1\u0001\u001f\u00132\u0011%\ty\u000fAA\u0001\n\u0003\n\t0A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\u0019\u0010\u0005\u0004\u0002v\u0006]\u00181]\u0007\u0003\u0003CIA!!?\u0002\"\tA\u0011\n^3sCR|'\u000fC\u0005\u0002~\u0002\t\t\u0011\"\u0001\u0002\u0000\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003\u0002\t\u001d\u0001cA\b\u0003\u0004%\u0019!Q\u0001\t\u0003\u000f\t{w\u000e\\3b]\"Q\u00111^A~\u0003\u0003\u0005\r!a9\t\u0013\t-\u0001!!A\u0005B\t5\u0011\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005]\u0007\"\u0003B\t\u0001\u0005\u0005I\u0011\tB\n\u0003!!xn\u0015;sS:<GCAAb\u0011%\u00119\u0002AA\u0001\n\u0003\u0012I\"\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005\u0003\u0011Y\u0002\u0003\u0006\u0002l\nU\u0011\u0011!a\u0001\u0003G<\u0011Ba\b\u0003\u0003\u0003E\tA!\t\u0002'\tKw-U;fef<&/\u001b;f\u0011\u0016d\u0007/\u001a:\u0011\u0007\u0001\u0013\u0019C\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012\u0001B\u0013'\u0015\u0011\u0019Ca\n\u0018!)\u0011ICa\f\u001eO]z\u0004jX\u0007\u0003\u0005WQ1A!\f\u0011\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\r\u0003,\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001b\t\u000fu\u0013\u0019\u0003\"\u0001\u00036Q\u0011!\u0011\u0005\u0005\u000b\u0005#\u0011\u0019#!A\u0005F\tM\u0001B\u0003B\u001e\u0005G\t\t\u0011\"!\u0003>\u0005)\u0011\r\u001d9msRYqLa\u0010\u0003B\t\r#Q\tB$\u0011\u0019Y\"\u0011\ba\u0001;!1QE!\u000fA\u0002\u001dBa!\u000eB\u001d\u0001\u00049\u0004BB\u001f\u0003:\u0001\u0007q\b\u0003\u0004G\u0005s\u0001\r\u0001\u0013\u0005\u000b\u0005\u0017\u0012\u0019#!A\u0005\u0002\n5\u0013aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u001f\u0012Y\u0006E\u0003\u0010\u0005#\u0012)&C\u0002\u0003TA\u0011aa\u00149uS>t\u0007\u0003C\b\u0003Xu9sg\u0010%\n\u0007\te\u0003C\u0001\u0004UkBdW-\u000e\u0005\n\u0005;\u0012I%!AA\u0002}\u000b1\u0001\u001f\u00131\u0011)\u0011\tGa\t\u0002\u0002\u0013%!1M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003fA!\u0011Q\u0019B4\u0013\u0011\u0011I'a2\u0003\r=\u0013'.Z2u\u0001")
public class BigQueryWriteHelper
implements Product,
Serializable {
    private final BigQuery bigQuery;
    private final SQLContext sqlContext;
    private final SaveMode saveMode;
    private final SparkBigQueryOptions options;
    private final Dataset<Row> data;
    private final Logger logger;
    private final Configuration conf;
    private final Path temporaryGcsPath;
    private final Map<SaveMode, JobInfo.WriteDisposition> saveModeToWriteDisposition;

    public static Option<Tuple5<BigQuery, SQLContext, SaveMode, SparkBigQueryOptions, Dataset<Row>>> unapply(BigQueryWriteHelper bigQueryWriteHelper) {
        return BigQueryWriteHelper$.MODULE$.unapply(bigQueryWriteHelper);
    }

    public static BigQueryWriteHelper apply(BigQuery bigQuery, SQLContext sQLContext, SaveMode saveMode, SparkBigQueryOptions sparkBigQueryOptions, Dataset<Row> dataset) {
        return BigQueryWriteHelper$.MODULE$.apply(bigQuery, sQLContext, saveMode, sparkBigQueryOptions, dataset);
    }

    public static Function1<Tuple5<BigQuery, SQLContext, SaveMode, SparkBigQueryOptions, Dataset<Row>>, BigQueryWriteHelper> tupled() {
        return BigQueryWriteHelper$.MODULE$.tupled();
    }

    public static Function1<BigQuery, Function1<SQLContext, Function1<SaveMode, Function1<SparkBigQueryOptions, Function1<Dataset<Row>, BigQueryWriteHelper>>>>> curried() {
        return BigQueryWriteHelper$.MODULE$.curried();
    }

    public BigQuery bigQuery() {
        return this.bigQuery;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public SaveMode saveMode() {
        return this.saveMode;
    }

    public SparkBigQueryOptions options() {
        return this.options;
    }

    public Dataset<Row> data() {
        return this.data;
    }

    private Logger logger() {
        return this.logger;
    }

    public Configuration conf() {
        return this.conf;
    }

    public Path temporaryGcsPath() {
        return this.temporaryGcsPath;
    }

    public Map<SaveMode, JobInfo.WriteDisposition> saveModeToWriteDisposition() {
        return this.saveModeToWriteDisposition;
    }

    public void writeDataFrameToBigQuery() {
        try {
            Runtime.getRuntime().addShutdownHook(this.createTemporaryPathDeleter());
            String format = this.options().intermediateFormat().getType().toLowerCase();
            this.data().write().format(format).save(this.temporaryGcsPath().toString());
            this.loadDataToBigQuery();
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to write to BigQuery", exception);
        }
        finally {
            this.cleanTempraryGcsPath();
        }
    }

    public void loadDataToBigQuery() {
        BoxedUnit boxedUnit;
        FileSystem fs = this.temporaryGcsPath().getFileSystem(this.conf());
        String formatSuffix = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.options().intermediateFormat().getType().toLowerCase()}));
        List sourceUris = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ToIterator(fs.listFiles(this.temporaryGcsPath(), false)).map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(LocatedFileStatus x$1) {
                return x$1.getPath().toString();
            }
        }).filter((Function1)new Serializable(this, formatSuffix){
            public static final long serialVersionUID = 0L;
            private final String formatSuffix$1;

            public final boolean apply(String x$2) {
                return x$2.toLowerCase().endsWith(this.formatSuffix$1);
            }
            {
                this.formatSuffix$1 = formatSuffix$1;
            }
        }).toList()).asJava();
        LoadJobConfiguration jobConfiguration = LoadJobConfiguration.newBuilder((TableId)this.options().tableId(), (List)sourceUris, (FormatOptions)this.options().intermediateFormat()).setCreateDisposition(JobInfo.CreateDisposition.CREATE_IF_NEEDED).setWriteDisposition((JobInfo.WriteDisposition)this.saveModeToWriteDisposition().apply((Object)this.saveMode())).build();
        JobInfo jobInfo = JobInfo.of((JobConfiguration)jobConfiguration);
        Job job = this.bigQuery().create(jobInfo, new BigQuery.JobOption[0]);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Submitted load to {}. jobId: {}", new Object[]{this.options().tableId(), job.getJobId()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Job finishedJob = job.waitFor(new RetryOption[0]);
        if (finishedJob.getStatus().getError() == null) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Done loading to {}. jobId: {}", new Object[]{this.friendlyTableName(), job.getJobId()});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            return;
        }
        throw new BigQueryException(0, new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to load to ", " in job ", ". BigQuery error was\n           |", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.friendlyTableName(), job.getJobId(), finishedJob.getStatus().getError().getMessage()})))).stripMargin().replace('\n', ' '), finishedJob.getStatus().getError());
    }

    public String friendlyTableName() {
        return BigQueryUtil$.MODULE$.friendlyTableName(this.options().tableId());
    }

    public void cleanTempraryGcsPath() {
        this.createTemporaryPathDeleter().deletePath();
    }

    private IntermediateDataCleaner createTemporaryPathDeleter() {
        return new IntermediateDataCleaner(this.temporaryGcsPath(), this.conf());
    }

    public void verifySaveMode() {
        block3: {
            block2: {
                SaveMode saveMode = this.saveMode();
                SaveMode saveMode2 = SaveMode.ErrorIfExists;
                if (!(saveMode == null ? saveMode2 != null : !saveMode.equals(saveMode2))) break block2;
                SaveMode saveMode3 = this.saveMode();
                SaveMode saveMode4 = SaveMode.Ignore;
                if (saveMode3 != null ? !saveMode3.equals(saveMode4) : saveMode4 != null) break block3;
            }
            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SaveMode ", " is not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.saveMode()})));
        }
    }

    public BigQueryWriteHelper copy(BigQuery bigQuery, SQLContext sqlContext, SaveMode saveMode, SparkBigQueryOptions options, Dataset<Row> data) {
        return new BigQueryWriteHelper(bigQuery, sqlContext, saveMode, options, data);
    }

    public BigQuery copy$default$1() {
        return this.bigQuery();
    }

    public SQLContext copy$default$2() {
        return this.sqlContext();
    }

    public SaveMode copy$default$3() {
        return this.saveMode();
    }

    public SparkBigQueryOptions copy$default$4() {
        return this.options();
    }

    public Dataset<Row> copy$default$5() {
        return this.data();
    }

    public String productPrefix() {
        return "BigQueryWriteHelper";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 4: {
                object = this.data();
                break;
            }
            case 3: {
                object = this.options();
                break;
            }
            case 2: {
                object = this.saveMode();
                break;
            }
            case 1: {
                object = this.sqlContext();
                break;
            }
            case 0: {
                object = this.bigQuery();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BigQueryWriteHelper;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BigQueryWriteHelper)) return false;
        boolean bl = true;
        if (!bl) return false;
        BigQueryWriteHelper bigQueryWriteHelper = (BigQueryWriteHelper)x$1;
        BigQuery bigQuery = this.bigQuery();
        BigQuery bigQuery2 = bigQueryWriteHelper.bigQuery();
        if (bigQuery == null) {
            if (bigQuery2 != null) {
                return false;
            }
        } else if (!bigQuery.equals(bigQuery2)) return false;
        SQLContext sQLContext = this.sqlContext();
        SQLContext sQLContext2 = bigQueryWriteHelper.sqlContext();
        if (sQLContext == null) {
            if (sQLContext2 != null) {
                return false;
            }
        } else if (!sQLContext.equals(sQLContext2)) return false;
        SaveMode saveMode = this.saveMode();
        SaveMode saveMode2 = bigQueryWriteHelper.saveMode();
        if (saveMode == null) {
            if (saveMode2 != null) {
                return false;
            }
        } else if (!saveMode.equals(saveMode2)) return false;
        SparkBigQueryOptions sparkBigQueryOptions = this.options();
        SparkBigQueryOptions sparkBigQueryOptions2 = bigQueryWriteHelper.options();
        if (sparkBigQueryOptions == null) {
            if (sparkBigQueryOptions2 != null) {
                return false;
            }
        } else if (!((Object)sparkBigQueryOptions).equals(sparkBigQueryOptions2)) return false;
        Dataset<Row> dataset = this.data();
        Dataset<Row> dataset2 = bigQueryWriteHelper.data();
        if (dataset == null) {
            if (dataset2 != null) {
                return false;
            }
        } else if (!dataset.equals(dataset2)) return false;
        if (!bigQueryWriteHelper.canEqual(this)) return false;
        return true;
    }

    public BigQueryWriteHelper(BigQuery bigQuery, SQLContext sqlContext, SaveMode saveMode, SparkBigQueryOptions options, Dataset<Row> data) {
        this.bigQuery = bigQuery;
        this.sqlContext = sqlContext;
        this.saveMode = saveMode;
        this.options = options;
        this.data = data;
        Product.class.$init$((Product)this);
        this.logger = Logger$.MODULE$.apply(this.getClass());
        this.conf = sqlContext.sparkContext().hadoopConfiguration();
        boolean needNewPath = true;
        Path gcsPath = null;
        String applicationId = sqlContext.sparkContext().applicationId();
        while (needNewPath) {
            Option gcsPathOption = options.temporaryGcsBucket().map((Function1)new Serializable(this, applicationId){
                public static final long serialVersionUID = 0L;
                private final String applicationId$1;

                public final String apply(String bucket) {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"gs://", "/.spark-bigquery-", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket, this.applicationId$1, UUID.randomUUID()}));
                }
                {
                    this.applicationId$1 = applicationId$1;
                }
            });
            Predef$.MODULE$.require(gcsPathOption.isDefined(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Temporary GCS path has not been set";
                }
            });
            gcsPath = new Path((String)gcsPathOption.get());
            FileSystem fs = gcsPath.getFileSystem(this.conf());
            needNewPath = fs.exists(gcsPath);
        }
        this.temporaryGcsPath = gcsPath;
        this.saveModeToWriteDisposition = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SaveMode.Append), (Object)JobInfo.WriteDisposition.WRITE_APPEND), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SaveMode.Overwrite), (Object)JobInfo.WriteDisposition.WRITE_TRUNCATE)}));
    }
}

