/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.spark.bigquery.BigQueryUtil$;
import com.google.cloud.spark.bigquery.SparkBigQueryOptions;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple15;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.package$;

public final class SparkBigQueryOptions$
implements Serializable {
    public static final SparkBigQueryOptions$ MODULE$;
    private final String IntermediateFormatOption;
    private final String ViewsEnabledOption;
    private final FormatOptions DefaultFormat;
    private final Set<FormatOptions> PermittedIntermediateFormats;

    static {
        new SparkBigQueryOptions$();
    }

    public String IntermediateFormatOption() {
        return this.IntermediateFormatOption;
    }

    public String ViewsEnabledOption() {
        return this.ViewsEnabledOption;
    }

    public FormatOptions DefaultFormat() {
        return this.DefaultFormat;
    }

    private Set<FormatOptions> PermittedIntermediateFormats() {
        return this.PermittedIntermediateFormats;
    }

    /*
     * WARNING - void declaration
     */
    public SparkBigQueryOptions apply(Map<String, String> parameters, Map<String, String> allConf, Configuration hadoopConf, Option<StructType> schema) {
        void var15_15;
        String tableParam = this.getRequiredOption(parameters, "table", this.getRequiredOption$default$3());
        Option<String> datasetParam = this.getOption(parameters, "dataset", this.getOption$default$3());
        Option<String> projectParam = this.getOption(parameters, "project", this.getOption$default$3());
        Option<String> credsParam = this.getAnyOption(allConf, parameters, "credentials");
        Option<String> credsFileParam = this.getAnyOption(allConf, parameters, "credentialsFile");
        TableId tableId = BigQueryUtil$.MODULE$.parseTableId(tableParam, datasetParam, projectParam);
        String parentProject = this.getRequiredOption(parameters, "parentProject", this.defaultBilledProject());
        Option<String> filter = this.getOption(parameters, "filter", this.getOption$default$3());
        Option parallelism = this.getOption(parameters, "parallelism", this.getOption$default$3()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
            }
        });
        Option<String> temporaryGcsBucket = this.getAnyOption(allConf, parameters, "temporaryGcsBucket");
        FormatOptions intermediateFormat = (FormatOptions)this.getAnyOption(allConf, parameters, this.IntermediateFormatOption()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final FormatOptions apply(String s) {
                return FormatOptions.of((String)s.toUpperCase());
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final FormatOptions apply() {
                return SparkBigQueryOptions$.MODULE$.DefaultFormat();
            }
        });
        if (this.PermittedIntermediateFormats().contains((Object)intermediateFormat)) {
            boolean combinePushedDownFilters = this.getAnyBooleanOption(allConf, parameters, "combinePushedDownFilters", true);
            boolean viewsEnabled = this.getAnyBooleanOption(allConf, parameters, this.ViewsEnabledOption(), false);
            Option<String> viewMaterializationProject = this.getAnyOption(allConf, parameters, "viewMaterializationProject");
            Option<String> viewMaterializationDataset = this.getAnyOption(allConf, parameters, "viewMaterializationDataset");
            return new SparkBigQueryOptions(tableId, parentProject, credsParam, credsFileParam, filter, schema, (Option<Object>)parallelism, temporaryGcsBucket, intermediateFormat, combinePushedDownFilters, viewsEnabled, viewMaterializationProject, viewMaterializationDataset, this.apply$default$14(), this.apply$default$15());
        }
        throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Intermediate format '", "' is not supported.\n           |Supported formats are ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var15_15.getType(), this.PermittedIntermediateFormats().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(FormatOptions x$2) {
                return x$2.getType();
            }
        }, Set$.MODULE$.canBuildFrom())})))).stripMargin().replace('\n', ' '));
    }

    public Option<String> apply$default$3() {
        return None$.MODULE$;
    }

    public Option<String> apply$default$4() {
        return None$.MODULE$;
    }

    public Option<String> apply$default$5() {
        return None$.MODULE$;
    }

    public Option<StructType> apply$default$6() {
        return None$.MODULE$;
    }

    public Option<Object> apply$default$7() {
        return None$.MODULE$;
    }

    public Option<String> apply$default$8() {
        return None$.MODULE$;
    }

    public FormatOptions apply$default$9() {
        return this.DefaultFormat();
    }

    public boolean apply$default$10() {
        return true;
    }

    public boolean apply$default$11() {
        return false;
    }

    public Option<String> apply$default$12() {
        return None$.MODULE$;
    }

    public Option<String> apply$default$13() {
        return None$.MODULE$;
    }

    public int apply$default$14() {
        return 24;
    }

    public int apply$default$15() {
        return 3;
    }

    private Function0<Some<String>> defaultBilledProject() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Some<String> apply() {
                return new Some((Object)BigQueryOptions.getDefaultInstance().getProjectId());
            }
        };
    }

    private String getRequiredOption(Map<String, String> options, String name, Function0<Option<String>> fallback) {
        return (String)this.getOption(options, name, fallback).getOrElse((Function0)new Serializable(name){
            public static final long serialVersionUID = 0L;
            private final String name$1;

            public final Nothing$ apply() {
                return package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Option ", " required."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1})));
            }
            {
                this.name$1 = name$1;
            }
        });
    }

    private Function0<Option<String>> getRequiredOption$default$3() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final None$ apply() {
                return None$.MODULE$;
            }
        };
    }

    private Option<String> getOption(Map<String, String> options, String name, Function0<Option<String>> fallback) {
        return options.get((Object)name).orElse(fallback);
    }

    private Function0<Option<String>> getOption$default$3() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final None$ apply() {
                return None$.MODULE$;
            }
        };
    }

    private Option<String> getAnyOption(Map<String, String> globalOptions, Map<String, String> options, String name) {
        return options.get((Object)name).orElse((Function0)new Serializable(globalOptions, name){
            public static final long serialVersionUID = 0L;
            private final Map globalOptions$1;
            private final String name$2;

            public final Option<String> apply() {
                return this.globalOptions$1.get((Object)this.name$2);
            }
            {
                this.globalOptions$1 = globalOptions$1;
                this.name$2 = name$2;
            }
        });
    }

    private boolean getAnyBooleanOption(Map<String, String> globalOptions, Map<String, String> options, String name, boolean defaultValue) {
        return BoxesRunTime.unboxToBoolean((Object)this.getAnyOption(globalOptions, options, this.ViewsEnabledOption()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$3) {
                return new StringOps(Predef$.MODULE$.augmentString(x$3)).toBoolean();
            }
        }).getOrElse((Function0)new Serializable(defaultValue){
            public static final long serialVersionUID = 0L;
            private final boolean defaultValue$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.defaultValue$1;
            }
            {
                this.defaultValue$1 = defaultValue$1;
            }
        }));
    }

    public SparkBigQueryOptions apply(TableId tableId, String parentProject, Option<String> credentials, Option<String> credentialsFile, Option<String> filter, Option<StructType> schema, Option<Object> parallelism, Option<String> temporaryGcsBucket, FormatOptions intermediateFormat, boolean combinePushedDownFilters, boolean viewsEnabled, Option<String> viewMaterializationProject, Option<String> viewMaterializationDataset, int viewExpirationTimeInHours, int maxReadRowsRetries) {
        return new SparkBigQueryOptions(tableId, parentProject, credentials, credentialsFile, filter, schema, parallelism, temporaryGcsBucket, intermediateFormat, combinePushedDownFilters, viewsEnabled, viewMaterializationProject, viewMaterializationDataset, viewExpirationTimeInHours, maxReadRowsRetries);
    }

    public Option<Tuple15<TableId, String, Option<String>, Option<String>, Option<String>, Option<StructType>, Option<Object>, Option<String>, FormatOptions, Object, Object, Option<String>, Option<String>, Object, Object>> unapply(SparkBigQueryOptions x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple15((Object)x$0.tableId(), (Object)x$0.parentProject(), x$0.credentials(), x$0.credentialsFile(), x$0.filter(), x$0.schema(), x$0.parallelism(), x$0.temporaryGcsBucket(), (Object)x$0.intermediateFormat(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.combinePushedDownFilters()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.viewsEnabled()), x$0.viewMaterializationProject(), x$0.viewMaterializationDataset(), (Object)BoxesRunTime.boxToInteger((int)x$0.viewExpirationTimeInHours()), (Object)BoxesRunTime.boxToInteger((int)x$0.maxReadRowsRetries())));
    }

    public Option<String> $lessinit$greater$default$3() {
        return None$.MODULE$;
    }

    public Option<String> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    public Option<String> $lessinit$greater$default$5() {
        return None$.MODULE$;
    }

    public Option<StructType> $lessinit$greater$default$6() {
        return None$.MODULE$;
    }

    public Option<Object> $lessinit$greater$default$7() {
        return None$.MODULE$;
    }

    public Option<String> $lessinit$greater$default$8() {
        return None$.MODULE$;
    }

    public FormatOptions $lessinit$greater$default$9() {
        return this.DefaultFormat();
    }

    public boolean $lessinit$greater$default$10() {
        return true;
    }

    public boolean $lessinit$greater$default$11() {
        return false;
    }

    public Option<String> $lessinit$greater$default$12() {
        return None$.MODULE$;
    }

    public Option<String> $lessinit$greater$default$13() {
        return None$.MODULE$;
    }

    public int $lessinit$greater$default$14() {
        return 24;
    }

    public int $lessinit$greater$default$15() {
        return 3;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SparkBigQueryOptions$() {
        MODULE$ = this;
        this.IntermediateFormatOption = "intermediateFormat";
        this.ViewsEnabledOption = "viewsEnabled";
        this.DefaultFormat = FormatOptions.parquet();
        this.PermittedIntermediateFormats = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FormatOptions[]{FormatOptions.orc(), FormatOptions.parquet()}));
    }
}

