/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.direct;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.storage.v1beta1.BigQueryStorageClient;
import com.google.cloud.bigquery.storage.v1beta1.BigQueryStorageSettings;
import com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto;
import com.google.cloud.spark.bigquery.BuildInfo$;
import com.google.cloud.spark.bigquery.SparkBigQueryOptions;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class DirectBigQueryRelation$
implements Serializable {
    public static final DirectBigQueryRelation$ MODULE$;

    static {
        new DirectBigQueryRelation$();
    }

    public BigQueryStorageClient createReadClient(SparkBigQueryOptions options) {
        Option<Credentials> option;
        block4: {
            BigQueryStorageSettings.Builder clientSettings;
            block3: {
                BoxedUnit boxedUnit;
                block2: {
                    clientSettings = (BigQueryStorageSettings.Builder)BigQueryStorageSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)BigQueryStorageSettings.defaultGrpcTransportProviderBuilder().setHeaderProvider((HeaderProvider)this.headerProvider()).build());
                    option = options.createCredentials();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Credentials creds = (Credentials)some.x();
                    boxedUnit = clientSettings.setCredentialsProvider(new CredentialsProvider(creds){
                        private final Credentials creds$1;

                        public Credentials getCredentials() {
                            return this.creds$1;
                        }
                        {
                            this.creds$1 = creds$1;
                        }
                    });
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                boxedUnit = BoxedUnit.UNIT;
            }
            return BigQueryStorageClient.create((BigQueryStorageSettings)clientSettings.build());
        }
        throw new MatchError(option);
    }

    public BigQuery createBigQueryClient(SparkBigQueryOptions options) {
        BigQueryOptions.Builder BigQueryOptionsBuilder = (BigQueryOptions.Builder)BigQueryOptions.newBuilder().setHeaderProvider((HeaderProvider)this.headerProvider());
        options.createCredentials().foreach((Function1)new Serializable(BigQueryOptionsBuilder){
            public static final long serialVersionUID = 0L;
            private final BigQueryOptions.Builder BigQueryOptionsBuilder$1;

            public final BigQueryOptions.Builder apply(Credentials x$1) {
                return (BigQueryOptions.Builder)this.BigQueryOptionsBuilder$1.setCredentials(x$1);
            }
            {
                this.BigQueryOptionsBuilder$1 = BigQueryOptionsBuilder$1;
            }
        });
        return (BigQuery)BigQueryOptionsBuilder.build().getService();
    }

    private FixedHeaderProvider headerProvider() {
        return FixedHeaderProvider.create((String[])new String[]{"user-agent", new StringBuilder().append((Object)BuildInfo$.MODULE$.name()).append((Object)"/").append((Object)BuildInfo$.MODULE$.version()).toString()});
    }

    public boolean isHandled(Filter filter) {
        boolean bl;
        block14: {
            Filter filter2;
            while (true) {
                Filter child;
                if ((filter2 = filter) instanceof EqualTo) {
                    bl = true;
                    break block14;
                }
                if (filter2 instanceof EqualNullSafe) {
                    bl = false;
                    break block14;
                }
                if (filter2 instanceof GreaterThan) {
                    bl = true;
                    break block14;
                }
                if (filter2 instanceof GreaterThanOrEqual) {
                    bl = true;
                    break block14;
                }
                if (filter2 instanceof LessThan) {
                    bl = true;
                    break block14;
                }
                if (filter2 instanceof LessThanOrEqual) {
                    bl = true;
                    break block14;
                }
                if (filter2 instanceof In) {
                    bl = true;
                    break block14;
                }
                if (filter2 instanceof IsNull) {
                    bl = true;
                    break block14;
                }
                if (filter2 instanceof IsNotNull) {
                    bl = true;
                    break block14;
                }
                if (filter2 instanceof And) {
                    And and = (And)filter2;
                    Filter lhs = and.left();
                    Filter rhs = and.right();
                    if (this.isHandled(lhs)) {
                        filter = rhs;
                        continue;
                    }
                    bl = false;
                    break block14;
                }
                if (filter2 instanceof Or) {
                    Or or = (Or)filter2;
                    Filter lhs = or.left();
                    Filter rhs = or.right();
                    if (this.isHandled(lhs)) {
                        filter = rhs;
                        continue;
                    }
                    bl = false;
                    break block14;
                }
                if (!(filter2 instanceof Not)) break;
                Not not = (Not)filter2;
                filter = child = not.child();
            }
            bl = filter2 instanceof StringStartsWith ? true : (filter2 instanceof StringEndsWith ? true : filter2 instanceof StringContains);
        }
        return bl;
    }

    public String compileFilter(Filter filter) {
        block16: {
            String string;
            block3: {
                Filter filter2;
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        block9: {
                                            block8: {
                                                block7: {
                                                    block6: {
                                                        block5: {
                                                            block4: {
                                                                block2: {
                                                                    filter2 = filter;
                                                                    if (!(filter2 instanceof EqualTo)) break block2;
                                                                    EqualTo equalTo = (EqualTo)filter2;
                                                                    String attr = equalTo.attribute();
                                                                    Object value = equalTo.value();
                                                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.quote(attr), this.com$google$cloud$spark$bigquery$direct$DirectBigQueryRelation$$compileValue(value)}));
                                                                    break block3;
                                                                }
                                                                if (!(filter2 instanceof GreaterThan)) break block4;
                                                                GreaterThan greaterThan = (GreaterThan)filter2;
                                                                String attr = greaterThan.attribute();
                                                                Object value = greaterThan.value();
                                                                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " > ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attr, this.com$google$cloud$spark$bigquery$direct$DirectBigQueryRelation$$compileValue(value)}));
                                                                break block3;
                                                            }
                                                            if (!(filter2 instanceof GreaterThanOrEqual)) break block5;
                                                            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter2;
                                                            String attr = greaterThanOrEqual.attribute();
                                                            Object value = greaterThanOrEqual.value();
                                                            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " >= ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.quote(attr), this.com$google$cloud$spark$bigquery$direct$DirectBigQueryRelation$$compileValue(value)}));
                                                            break block3;
                                                        }
                                                        if (!(filter2 instanceof LessThan)) break block6;
                                                        LessThan lessThan = (LessThan)filter2;
                                                        String attr = lessThan.attribute();
                                                        Object value = lessThan.value();
                                                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " < ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.quote(attr), this.com$google$cloud$spark$bigquery$direct$DirectBigQueryRelation$$compileValue(value)}));
                                                        break block3;
                                                    }
                                                    if (!(filter2 instanceof LessThanOrEqual)) break block7;
                                                    LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter2;
                                                    String attr = lessThanOrEqual.attribute();
                                                    Object value = lessThanOrEqual.value();
                                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " <= ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.quote(attr), this.com$google$cloud$spark$bigquery$direct$DirectBigQueryRelation$$compileValue(value)}));
                                                    break block3;
                                                }
                                                if (!(filter2 instanceof In)) break block8;
                                                In in = (In)filter2;
                                                String attr = in.attribute();
                                                Object[] values = in.values();
                                                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " IN UNNEST(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.quote(attr), this.com$google$cloud$spark$bigquery$direct$DirectBigQueryRelation$$compileValue(values)}));
                                                break block3;
                                            }
                                            if (!(filter2 instanceof IsNull)) break block9;
                                            IsNull isNull = (IsNull)filter2;
                                            String attr = isNull.attribute();
                                            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " IS NULL"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.quote(attr)}));
                                            break block3;
                                        }
                                        if (!(filter2 instanceof IsNotNull)) break block10;
                                        IsNotNull isNotNull = (IsNotNull)filter2;
                                        String attr = isNotNull.attribute();
                                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " IS NOT NULL"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.quote(attr)}));
                                        break block3;
                                    }
                                    if (!(filter2 instanceof And)) break block11;
                                    And and = (And)filter2;
                                    Filter lhs = and.left();
                                    Filter rhs = and.right();
                                    string = ((TraversableOnce)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Filter[]{lhs, rhs}))).map((Function1)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(Filter filter) {
                                            return DirectBigQueryRelation$.MODULE$.compileFilter(filter);
                                        }
                                    }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(String p) {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p}));
                                        }
                                    }, Seq$.MODULE$.canBuildFrom())).mkString(" AND ");
                                    break block3;
                                }
                                if (!(filter2 instanceof Or)) break block12;
                                Or or = (Or)filter2;
                                Filter lhs = or.left();
                                Filter rhs = or.right();
                                string = ((TraversableOnce)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Filter[]{lhs, rhs}))).map((Function1)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(Filter filter) {
                                        return DirectBigQueryRelation$.MODULE$.compileFilter(filter);
                                    }
                                }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(String p) {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p}));
                                    }
                                }, Seq$.MODULE$.canBuildFrom())).mkString(" OR ");
                                break block3;
                            }
                            if (!(filter2 instanceof Not)) break block13;
                            Not not = (Not)filter2;
                            Filter child = not.child();
                            string = ((TraversableOnce)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Filter[]{child}))).map((Function1)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final String apply(Filter filter) {
                                    return DirectBigQueryRelation$.MODULE$.compileFilter(filter);
                                }
                            }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final String apply(String p) {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(NOT (", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p}));
                                }
                            }, Seq$.MODULE$.canBuildFrom())).mkString();
                            break block3;
                        }
                        if (!(filter2 instanceof StringStartsWith)) break block14;
                        StringStartsWith stringStartsWith = (StringStartsWith)filter2;
                        String attr = stringStartsWith.attribute();
                        String value = stringStartsWith.value();
                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " LIKE '''", "%'''"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.quote(attr), value.replace("'", "\\'")}));
                        break block3;
                    }
                    if (!(filter2 instanceof StringEndsWith)) break block15;
                    StringEndsWith stringEndsWith = (StringEndsWith)filter2;
                    String attr = stringEndsWith.attribute();
                    String value = stringEndsWith.value();
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " LIKE '''%", "'''"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.quote(attr), value.replace("'", "\\'")}));
                    break block3;
                }
                if (!(filter2 instanceof StringContains)) break block16;
                StringContains stringContains = (StringContains)filter2;
                String attr = stringContains.attribute();
                String value = stringContains.value();
                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " LIKE '''%", "%'''"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.quote(attr), value.replace("'", "\\'")}));
            }
            return string;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid filter: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filter})));
    }

    public String compileFilters(Iterable<Filter> filters) {
        return ((TraversableOnce)((TraversableOnce)filters.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Filter filter) {
                return DirectBigQueryRelation$.MODULE$.compileFilter(filter);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString(" AND ");
    }

    public Object com$google$cloud$spark$bigquery$direct$DirectBigQueryRelation$$compileValue(Object value) {
        Object object;
        Object object2 = value;
        if (object2 == null) {
            object = "null";
        } else if (object2 instanceof String) {
            String string = (String)object2;
            object = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string.replace("'", "\\'")}));
        } else if (object2 instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object2;
            object = new StringBuilder().append((Object)"'").append((Object)timestamp).append((Object)"'").toString();
        } else if (object2 instanceof Date) {
            Date date = (Date)object2;
            object = new StringBuilder().append((Object)"'").append((Object)date).append((Object)"'").toString();
        } else if (object2 instanceof Object[]) {
            Object[] objectArray = (Object[])object2;
            object = Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps((Object)objectArray).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Object apply(Object value) {
                    return DirectBigQueryRelation$.MODULE$.com$google$cloud$spark$bigquery$direct$DirectBigQueryRelation$$compileValue(value);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).mkString("[", ", ", "]");
        } else {
            object = value;
        }
        return object;
    }

    private String quote(String attr) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attr}));
    }

    public TableReferenceProto.TableReference toTableReference(TableId tableId) {
        return TableReferenceProto.TableReference.newBuilder().setProjectId(tableId.getProject()).setDatasetId(tableId.getDataset()).setTableId(tableId.getTable()).build();
    }

    public Function1<SparkBigQueryOptions, BigQueryStorageClient> $lessinit$greater$default$3() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BigQueryStorageClient apply(SparkBigQueryOptions options) {
                return DirectBigQueryRelation$.MODULE$.createReadClient(options);
            }
        };
    }

    public Function1<SparkBigQueryOptions, BigQuery> $lessinit$greater$default$4() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BigQuery apply(SparkBigQueryOptions options) {
                return DirectBigQueryRelation$.MODULE$.createBigQueryClient(options);
            }
        };
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DirectBigQueryRelation$() {
        MODULE$ = this;
    }
}

