/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.direct;

import com.google.cloud.RetryOption;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.storage.v1beta1.BigQueryStorageClient;
import com.google.cloud.bigquery.storage.v1beta1.ReadOptions;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto;
import com.google.cloud.spark.bigquery.BigQueryRelation;
import com.google.cloud.spark.bigquery.BigQueryUtil$;
import com.google.cloud.spark.bigquery.SchemaConverters$;
import com.google.cloud.spark.bigquery.SparkBigQueryOptions;
import com.google.cloud.spark.bigquery.direct.BigQueryPartition;
import com.google.cloud.spark.bigquery.direct.BigQueryRDD;
import com.google.cloud.spark.bigquery.direct.BigQueryRDD$;
import com.google.cloud.spark.bigquery.direct.DirectBigQueryRelation$;
import com.google.cloud.spark.bigquery.direct.DirectBigQueryRelation$DestinationTableBuilder$;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.PrunedFilteredScan;
import org.apache.spark.sql.sources.PrunedScan;
import org.apache.spark.sql.sources.TableScan;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\r5f!B\u0001\u0003\u0001\u0011q!A\u0006#je\u0016\u001cGOQ5h#V,'/\u001f*fY\u0006$\u0018n\u001c8\u000b\u0005\r!\u0011A\u00023je\u0016\u001cGO\u0003\u0002\u0006\r\u0005A!-[4rk\u0016\u0014\u0018P\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0006G2|W\u000f\u001a\u0006\u0003\u00171\taaZ8pO2,'\"A\u0007\u0002\u0007\r|WnE\u0003\u0001\u001fM\u00013\u0005\u0005\u0002\u0011#5\tA!\u0003\u0002\u0013\t\t\u0001\")[4Rk\u0016\u0014\u0018PU3mCRLwN\u001c\t\u0003)yi\u0011!\u0006\u0006\u0003-]\tqa]8ve\u000e,7O\u0003\u0002\u00193\u0005\u00191/\u001d7\u000b\u0005\u001dQ\"BA\u000e\u001d\u0003\u0019\t\u0007/Y2iK*\tQ$A\u0002pe\u001eL!aH\u000b\u0003\u0013Q\u000b'\r\\3TG\u0006t\u0007C\u0001\u000b\"\u0013\t\u0011SC\u0001\u0006QeVtW\rZ*dC:\u0004\"\u0001\u0006\u0013\n\u0005\u0015*\"A\u0005)sk:,GMR5mi\u0016\u0014X\rZ*dC:D\u0011b\n\u0001\u0003\u0002\u0003\u0006I!\u000b\u0017\u0002\u000f=\u0004H/[8og\u000e\u0001\u0001C\u0001\t+\u0013\tYCA\u0001\u000bTa\u0006\u00148NQ5h#V,'/_(qi&|gn]\u0005\u0003OEA\u0011B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u001b\u0002\u000bQ\f'\r\\3\u0011\u0005A\u0012T\"A\u0019\u000b\u0005\u0015A\u0011BA\u001a2\u0005%!\u0016M\u00197f\u0013:4w.\u0003\u0002/#!Aa\u0007\u0001B\u0001B\u0003%q'A\u0005hKR\u001cE.[3oiB!\u0001hO\u0015>\u001b\u0005I$\"\u0001\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qJ$!\u0003$v]\u000e$\u0018n\u001c82!\tq4)D\u0001@\u0015\t\u0001\u0015)A\u0004wc\t,G/Y\u0019\u000b\u0005\t\u000b\u0014aB:u_J\fw-Z\u0005\u0003\t~\u0012QCQ5h#V,'/_*u_J\fw-Z\"mS\u0016tG\u000f\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003H\u00039\u0011\u0017nZ)vKJL8\t\\5f]R\u0004B\u0001O\u001e*\u0011B\u0011\u0001'S\u0005\u0003\u0015F\u0012\u0001BQ5h#V,'/\u001f\u0005\t\u0019\u0002\u0011)\u0019!C!\u001b\u0006Q1/\u001d7D_:$X\r\u001f;\u0016\u00039\u0003\"a\u0014)\u000e\u0003]I!!U\f\u0003\u0015M\u000bFjQ8oi\u0016DH\u000fC\u0005T\u0001\t\u0005\t\u0015!\u0003O)\u0006Y1/\u001d7D_:$X\r\u001f;!\u0013\ta\u0015\u0003\u000b\u0002S-B\u0011\u0001hV\u0005\u00031f\u0012\u0011\u0002\u001e:b]NLWM\u001c;\t\u000bi\u0003A\u0011A.\u0002\rqJg.\u001b;?)\u0015a\u0006-\u00192d)\tiv\f\u0005\u0002_\u00015\t!\u0001C\u0003M3\u0002\u0007a\nC\u0003(3\u0002\u0007\u0011\u0006C\u0003/3\u0002\u0007q\u0006C\u000473B\u0005\t\u0019A\u001c\t\u000f\u0019K\u0006\u0013!a\u0001\u000f\"9Q\r\u0001b\u0001\n\u00031\u0017A\u0004;bE2,'+\u001a4fe\u0016t7-Z\u000b\u0002OB\u0011\u0001N\u001f\b\u0003Sbt!A[<\u000f\u0005-4hB\u00017v\u001d\tiGO\u0004\u0002og:\u0011qN]\u0007\u0002a*\u0011\u0011\u000fK\u0001\u0007yI|w\u000e\u001e \n\u00035I!a\u0003\u0007\n\u0005%Q\u0011BA\u0003\t\u0013\t\u0011\u0015'\u0003\u0002A\u0003&\u0011\u0011pP\u0001\u0014)\u0006\u0014G.\u001a*fM\u0016\u0014XM\\2f!J|Go\\\u0005\u0003wr\u0014a\u0002V1cY\u0016\u0014VMZ3sK:\u001cWM\u0003\u0002z\u007f!1a\u0010\u0001Q\u0001\n\u001d\fq\u0002^1cY\u0016\u0014VMZ3sK:\u001cW\r\t\u0005\u000b\u0003\u0003\u0001\u0001R1A\u0005\u0002\u0005\r\u0011\u0001\u00032jOF+XM]=\u0016\u0003!C\u0011\"a\u0002\u0001\u0011\u0003\u0005\u000b\u0015\u0002%\u0002\u0013\tLw-U;fef\u0004cABA\u0006\u0001\u0001\u000biAA\fEKN$\u0018N\\1uS>tG+\u00192mK\n+\u0018\u000e\u001c3feNQ\u0011\u0011BA\b\u0003?\ty#!\u000e\u0011\t\u0005E\u00111D\u0007\u0003\u0003'QA!!\u0006\u0002\u0018\u0005!A.\u00198h\u0015\t\tI\"\u0001\u0003kCZ\f\u0017\u0002BA\u000f\u0003'\u0011aa\u00142kK\u000e$\b#BA\u0011\u0003WySBAA\u0012\u0015\u0011\t)#a\n\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002*\u0005]\u0011\u0001B;uS2LA!!\f\u0002$\tA1)\u00197mC\ndW\rE\u00029\u0003cI1!a\r:\u0005\u001d\u0001&o\u001c3vGR\u00042\u0001OA\u001c\u0013\r\tI$\u000f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\f\u0003{\tIA!f\u0001\n\u0003\ty$\u0001\u0005rk\u0016\u0014\u0018pU9m+\t\t\t\u0005\u0005\u0003\u0002D\u0005%cb\u0001\u001d\u0002F%\u0019\u0011qI\u001d\u0002\rA\u0013X\rZ3g\u0013\u0011\tY%!\u0014\u0003\rM#(/\u001b8h\u0015\r\t9%\u000f\u0005\f\u0003#\nIA!E!\u0002\u0013\t\t%A\u0005rk\u0016\u0014\u0018pU9mA!9!,!\u0003\u0005\u0002\u0005UC\u0003BA,\u00037\u0002B!!\u0017\u0002\n5\t\u0001\u0001\u0003\u0005\u0002>\u0005M\u0003\u0019AA!\u0011!\ty&!\u0003\u0005B\u0005\u0005\u0014\u0001B2bY2$\u0012a\f\u0005\u000b\u0003K\nI!!A\u0005\u0002\u0005\u001d\u0014\u0001B2paf$B!a\u0016\u0002j!Q\u0011QHA2!\u0003\u0005\r!!\u0011\t\u0015\u00055\u0014\u0011BI\u0001\n\u0003\ty'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005E$\u0006BA!\u0003gZ#!!\u001e\u0011\t\u0005]\u0014\u0011Q\u0007\u0003\u0003sRA!a\u001f\u0002~\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u007fJ\u0014AC1o]>$\u0018\r^5p]&!\u00111QA=\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0003\u000f\u000bI!!A\u0005B\u0005%\u0015!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\fB!\u0011\u0011CAG\u0013\u0011\tY%a\u0005\t\u0015\u0005E\u0015\u0011BA\u0001\n\u0003\t\u0019*\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\u0016B\u0019\u0001(a&\n\u0007\u0005e\u0015HA\u0002J]RD!\"!(\u0002\n\u0005\u0005I\u0011AAP\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!)\u0002(B\u0019\u0001(a)\n\u0007\u0005\u0015\u0016HA\u0002B]fD!\"!+\u0002\u001c\u0006\u0005\t\u0019AAK\u0003\rAH%\r\u0005\u000b\u0003[\u000bI!!A\u0005B\u0005=\u0016a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005E\u0006CBAZ\u0003s\u000b\t+\u0004\u0002\u00026*\u0019\u0011qW\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002<\u0006U&\u0001C%uKJ\fGo\u001c:\t\u0015\u0005}\u0016\u0011BA\u0001\n\u0003\t\t-\u0001\u0005dC:,\u0015/^1m)\u0011\t\u0019-!3\u0011\u0007a\n)-C\u0002\u0002Hf\u0012qAQ8pY\u0016\fg\u000e\u0003\u0006\u0002*\u0006u\u0016\u0011!a\u0001\u0003CC!\"!4\u0002\n\u0005\u0005I\u0011IAh\u0003!A\u0017m\u001d5D_\u0012,GCAAK\u0011)\t\u0019.!\u0003\u0002\u0002\u0013\u0005\u0013Q[\u0001\ti>\u001cFO]5oOR\u0011\u00111\u0012\u0005\u000b\u00033\fI!!A\u0005B\u0005m\u0017AB3rk\u0006d7\u000f\u0006\u0003\u0002D\u0006u\u0007BCAU\u0003/\f\t\u00111\u0001\u0002\"\u001eI\u0011\u0011\u001d\u0001\u0002\u0002#\u0005\u00111]\u0001\u0018\t\u0016\u001cH/\u001b8bi&|g\u000eV1cY\u0016\u0014U/\u001b7eKJ\u0004B!!\u0017\u0002f\u001aI\u00111\u0002\u0001\u0002\u0002#\u0005\u0011q]\n\u0007\u0003K\fI/!\u000e\u0011\u0011\u0005-\u0018\u0011_A!\u0003/j!!!<\u000b\u0007\u0005=\u0018(A\u0004sk:$\u0018.\\3\n\t\u0005M\u0018Q\u001e\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\f\u0004b\u0002.\u0002f\u0012\u0005\u0011q\u001f\u000b\u0003\u0003GD!\"a5\u0002f\u0006\u0005IQIAk\u0011)\ti0!:\u0002\u0002\u0013\u0005\u0015q`\u0001\u0006CB\u0004H.\u001f\u000b\u0005\u0003/\u0012\t\u0001\u0003\u0005\u0002>\u0005m\b\u0019AA!\u0011)\u0011)!!:\u0002\u0002\u0013\u0005%qA\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011IAa\u0004\u0011\u000ba\u0012Y!!\u0011\n\u0007\t5\u0011H\u0001\u0004PaRLwN\u001c\u0005\u000b\u0005#\u0011\u0019!!AA\u0002\u0005]\u0013a\u0001=%a!I!Q\u0003\u0001C\u0002\u0013\u0005!qC\u0001\u0016I\u0016\u001cH/\u001b8bi&|g\u000eV1cY\u0016\u001c\u0015m\u00195f+\t\u0011I\u0002E\u0004\u0003\u001c\t\u0015\u0012\u0011I\u0018\u000e\u0005\tu!\u0002\u0002B\u0010\u0005C\tQaY1dQ\u0016T1Aa\t\u000b\u0003\u0019\u0019w.\\7p]&!!q\u0005B\u000f\u0005\u0015\u0019\u0015m\u00195f\u0011!\u0011Y\u0003\u0001Q\u0001\n\te\u0011A\u00063fgRLg.\u0019;j_:$\u0016M\u00197f\u0007\u0006\u001c\u0007.\u001a\u0011\t\u0013\t=\u0002A1A\u0005\n\tE\u0012a\u00017pOV\u0011!1\u0007\t\u0005\u0005k\u0011y$\u0004\u0002\u00038)!!\u0011\bB\u001e\u00031\u00198-\u00197bY><w-\u001b8h\u0015\r\u0011i\u0004D\u0001\tif\u0004Xm]1gK&!!\u0011\tB\u001c\u0005\u0019aunZ4fe\"A!Q\t\u0001!\u0002\u0013\u0011\u0019$\u0001\u0003m_\u001e\u0004\u0003\"\u0003B%\u0001\t\u0007I\u0011\u0001B&\u0003m!UIR!V\u0019R{&)\u0017+F'~\u0003VIU0Q\u0003J#\u0016\nV%P\u001dV\u0011!Q\n\t\u0004q\t=\u0013b\u0001B)s\t!Aj\u001c8h\u0011!\u0011)\u0006\u0001Q\u0001\n\t5\u0013\u0001\b#F\r\u0006+F\nV0C3R+5k\u0018)F%~\u0003\u0016I\u0015+J)&{e\n\t\u0005\n\u00053\u0002!\u0019!C!\u00057\naB\\3fI\u000e{gN^3sg&|g.\u0006\u0002\u0002D\"A!q\f\u0001!\u0002\u0013\t\u0019-A\boK\u0016$7i\u001c8wKJ\u001c\u0018n\u001c8!\u0011%\u0011\u0019\u0007\u0001b\u0001\n\u0003\u0012Y%A\u0006tSj,\u0017J\u001c\"zi\u0016\u001c\b\u0002\u0003B4\u0001\u0001\u0006IA!\u0014\u0002\u0019ML'0Z%o\u0005f$Xm\u001d\u0011\t\u0015\t-\u0004\u0001#b\u0001\n\u0003\u0011i'\u0001\feK\u001a\fW\u000f\u001c;UC\ndW\rR3gS:LG/[8o+\t\u0011y\u0007E\u00021\u0005cJ1Aa\u001d2\u0005]\u0019F/\u00198eCJ$G+\u00192mK\u0012+g-\u001b8ji&|g\u000e\u0003\u0006\u0003x\u0001A\t\u0011)Q\u0005\u0005_\nq\u0003Z3gCVdG\u000fV1cY\u0016$UMZ5oSRLwN\u001c\u0011\t\u000f\tm\u0004\u0001\"\u0011\u0003~\u0005I!-^5mIN\u001b\u0017M\u001c\u000b\u0003\u0005\u007f\u0002bA!!\u0003\b\n-UB\u0001BB\u0015\r\u0011))G\u0001\u0004e\u0012$\u0017\u0002\u0002BE\u0005\u0007\u00131A\u0015#E!\ry%QR\u0005\u0004\u0005\u001f;\"a\u0001*po\"9!1\u0010\u0001\u0005B\tME\u0003\u0002B@\u0005+C\u0001Ba&\u0003\u0012\u0002\u0007!\u0011T\u0001\u0010e\u0016\fX/\u001b:fI\u000e{G.^7ogB)\u0001Ha'\u0002B%\u0019!QT\u001d\u0003\u000b\u0005\u0013(/Y=\t\u000f\tm\u0004\u0001\"\u0011\u0003\"R1!q\u0010BR\u0005KC\u0001Ba&\u0003 \u0002\u0007!\u0011\u0014\u0005\t\u0005O\u0013y\n1\u0001\u0003*\u00069a-\u001b7uKJ\u001c\b#\u0002\u001d\u0003\u001c\n-\u0006c\u0001\u000b\u0003.&\u0019!qV\u000b\u0003\r\u0019KG\u000e^3s\u0011\u001d\u0011\u0019\f\u0001C\u0001\u0005k\u000babZ3u\u0003\u000e$X/\u00197UC\ndW\rF\u00030\u0005o\u0013I\f\u0003\u0005\u0003\u0018\nE\u0006\u0019\u0001BM\u0011!\u00119K!-A\u0002\t%\u0006b\u0002B_\u0001\u0011\u0005!qX\u0001\u0015GJ,\u0017\r^3UC\ndWM\u0012:p[F+XM]=\u0015\u0007=\u0012\t\r\u0003\u0005\u0002>\tm\u0006\u0019AA!\u0011\u001d\u0011)\r\u0001C\u0001\u0005\u000f\f\u0011b\u0019:fCR,7+\u001d7\u0015\u0011\u0005\u0005#\u0011\u001aBj\u0005+D\u0001Ba3\u0003D\u0002\u0007!QZ\u0001\u0007g\u000eDW-\\1\u0011\u0007A\u0012y-C\u0002\u0003RF\u0012aaU2iK6\f\u0007\u0002\u0003BL\u0005\u0007\u0004\rA!'\t\u0011\t\u001d&1\u0019a\u0001\u0005SCqA!7\u0001\t\u0003\u0011Y.A\tde\u0016\fG/Z,iKJ,7\t\\1vg\u0016$BA!\u0003\u0003^\"A!q\u0015Bl\u0001\u0004\u0011I\u000bC\u0004\u0003b\u0002!\tAa9\u0002-\r\u0014X-\u0019;f\t\u0016\u001cH/\u001b8bi&|g\u000eV1cY\u0016,\"A!:\u0011\u0007A\u00129/C\u0002\u0003jF\u0012q\u0001V1cY\u0016LE\rC\u0004\u0003n\u0002!\t!a%\u00023\u001d,GOT;n!\u0006\u0014H/\u001b;j_:\u001c(+Z9vKN$X\r\u001a\u0005\b\u0005[\u0004A\u0011\u0001By)\u0011\t)Ja=\t\u0011\tU(q\u001ea\u0001\u0005_\nq\u0002^1cY\u0016$UMZ5oSRLwN\u001c\u0005\t\u0005s\u0004A\u0011\u0001\u0003\u0003|\u0006\tr-\u001a;D_6\u0004\u0018\u000e\\3e\r&dG/\u001a:\u0015\t\u0005\u0005#Q \u0005\t\u0005O\u00139\u00101\u0001\u0003*\"91\u0011\u0001\u0001\u0005\n\r\r\u0011A\u00045b]\u0012dW\r\u001a$jYR,'o\u001d\u000b\u0005\u0005S\u001b)\u0001\u0003\u0005\u0003(\n}\b\u0019\u0001BU\u0011\u001d\u0019I\u0001\u0001C!\u0007\u0017\t\u0001#\u001e8iC:$G.\u001a3GS2$XM]:\u0015\t\t%6Q\u0002\u0005\t\u0005O\u001b9\u00011\u0001\u0003*\u001eA1\u0011\u0003\u0002\t\u0002\u0011\u0019\u0019\"\u0001\fESJ,7\r\u001e\"jOF+XM]=SK2\fG/[8o!\rq6Q\u0003\u0004\b\u0003\tA\t\u0001BB\f'\u0019\u0019)b!\u0007\u00026A\u0019\u0001ha\u0007\n\u0007\ru\u0011H\u0001\u0004B]f\u0014VM\u001a\u0005\b5\u000eUA\u0011AB\u0011)\t\u0019\u0019\u0002\u0003\u0005\u0004&\rUA\u0011AB\u0014\u0003A\u0019'/Z1uKJ+\u0017\rZ\"mS\u0016tG\u000fF\u0002>\u0007SAaaJB\u0012\u0001\u0004I\u0003\u0002CB\u0017\u0007+!\taa\f\u0002)\r\u0014X-\u0019;f\u0005&<\u0017+^3ss\u000ec\u0017.\u001a8u)\rA5\u0011\u0007\u0005\u0007O\r-\u0002\u0019A\u0015\t\u0011\rU2Q\u0003C\u0005\u0007o\ta\u0002[3bI\u0016\u0014\bK]8wS\u0012,'/\u0006\u0002\u0004:A!11HB%\u001b\t\u0019iD\u0003\u0003\u0004@\r\u0005\u0013a\u0001:qG*!11IB#\u0003\r9\u0017\r\u001f\u0006\u0004\u0007\u000fR\u0011aA1qS&!11JB\u001f\u0005M1\u0015\u000e_3e\u0011\u0016\fG-\u001a:Qe>4\u0018\u000eZ3s\u0011!\u0019ye!\u0006\u0005\u0002\rE\u0013!C5t\u0011\u0006tG\r\\3e)\u0011\t\u0019ma\u0015\t\u0011\rU3Q\na\u0001\u0005W\u000baAZ5mi\u0016\u0014\b\u0002CB-\u0007+!\taa\u0017\u0002\u001b\r|W\u000e]5mK\u001aKG\u000e^3s)\u0011\t\te!\u0018\t\u0011\rU3q\u000ba\u0001\u0005WC\u0001b!\u0019\u0004\u0016\u0011\u000511M\u0001\u000fG>l\u0007/\u001b7f\r&dG/\u001a:t)\u0011\t\te!\u001a\t\u0011\t\u001d6q\fa\u0001\u0007O\u0002ba!\u001b\u0004t\t-f\u0002BB6\u0007_r1a\\B7\u0013\u0005Q\u0014bAB9s\u00059\u0001/Y2lC\u001e,\u0017\u0002BB;\u0007o\u0012\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0007cJ\u0004\u0002CB>\u0007+!Ia! \u0002\u0019\r|W\u000e]5mKZ\u000bG.^3\u0015\t\u0005\u00056q\u0010\u0005\t\u0007\u0003\u001bI\b1\u0001\u0002\"\u0006)a/\u00197vK\"A1QQB\u000b\t\u0013\u00199)A\u0003rk>$X\r\u0006\u0003\u0002B\r%\u0005\u0002CBF\u0007\u0007\u0003\r!!\u0011\u0002\t\u0005$HO\u001d\u0005\t\u0007\u001f\u001b)\u0002\"\u0001\u0004\u0012\u0006\u0001Bo\u001c+bE2,'+\u001a4fe\u0016t7-\u001a\u000b\u0004O\u000eM\u0005\u0002CBK\u0007\u001b\u0003\rA!:\u0002\u000fQ\f'\r\\3JI\"Q1\u0011TB\u000b#\u0003%\taa'\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019iJK\u00028\u0003gB!b!)\u0004\u0016E\u0005I\u0011ABR\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u00111Q\u0015\u0016\u0004\u000f\u0006M\u0004BCBU\u0007+\t\t\u0011\"\u0003\u0004,\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ty\u0001")
public class DirectBigQueryRelation
extends BigQueryRelation
implements TableScan,
PrunedScan,
PrunedFilteredScan {
    private final Function1<SparkBigQueryOptions, BigQueryStorageClient> getClient;
    private final Function1<SparkBigQueryOptions, BigQuery> bigQueryClient;
    private final TableReferenceProto.TableReference tableReference;
    private BigQuery bigQuery;
    private final Cache<String, TableInfo> destinationTableCache;
    private final Logger log;
    private final long DEFAULT_BYTES_PER_PARTITION;
    private final boolean needConversion;
    private final long sizeInBytes;
    private StandardTableDefinition defaultTableDefinition;
    private volatile DirectBigQueryRelation$DestinationTableBuilder$ DestinationTableBuilder$module;
    private volatile byte bitmap$0;

    public static Function1<SparkBigQueryOptions, BigQuery> $lessinit$greater$default$4() {
        return DirectBigQueryRelation$.MODULE$.$lessinit$greater$default$4();
    }

    public static Function1<SparkBigQueryOptions, BigQueryStorageClient> $lessinit$greater$default$3() {
        return DirectBigQueryRelation$.MODULE$.$lessinit$greater$default$3();
    }

    public static TableReferenceProto.TableReference toTableReference(TableId tableId) {
        return DirectBigQueryRelation$.MODULE$.toTableReference(tableId);
    }

    public static String compileFilters(Iterable<Filter> iterable) {
        return DirectBigQueryRelation$.MODULE$.compileFilters(iterable);
    }

    public static String compileFilter(Filter filter) {
        return DirectBigQueryRelation$.MODULE$.compileFilter(filter);
    }

    public static boolean isHandled(Filter filter) {
        return DirectBigQueryRelation$.MODULE$.isHandled(filter);
    }

    public static BigQuery createBigQueryClient(SparkBigQueryOptions sparkBigQueryOptions) {
        return DirectBigQueryRelation$.MODULE$.createBigQueryClient(sparkBigQueryOptions);
    }

    public static BigQueryStorageClient createReadClient(SparkBigQueryOptions sparkBigQueryOptions) {
        return DirectBigQueryRelation$.MODULE$.createReadClient(sparkBigQueryOptions);
    }

    private BigQuery bigQuery$lzycompute() {
        DirectBigQueryRelation directBigQueryRelation = this;
        synchronized (directBigQueryRelation) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.bigQuery = (BigQuery)this.bigQueryClient.apply((Object)super.options());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.bigQuery;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DirectBigQueryRelation$DestinationTableBuilder$ DestinationTableBuilder$lzycompute() {
        DirectBigQueryRelation directBigQueryRelation = this;
        synchronized (directBigQueryRelation) {
            if (this.DestinationTableBuilder$module != null) return this.DestinationTableBuilder$module;
            this.DestinationTableBuilder$module = new DirectBigQueryRelation$DestinationTableBuilder$(this);
            return this.DestinationTableBuilder$module;
        }
    }

    private StandardTableDefinition defaultTableDefinition$lzycompute() {
        DirectBigQueryRelation directBigQueryRelation = this;
        synchronized (directBigQueryRelation) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.defaultTableDefinition = (StandardTableDefinition)this.getActualTable((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), (Filter[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Filter.class))).getDefinition();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.defaultTableDefinition;
        }
    }

    @Override
    public SQLContext sqlContext() {
        return super.sqlContext();
    }

    public TableReferenceProto.TableReference tableReference() {
        return this.tableReference;
    }

    public BigQuery bigQuery() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.bigQuery$lzycompute() : this.bigQuery;
    }

    public DirectBigQueryRelation$DestinationTableBuilder$ DestinationTableBuilder() {
        return this.DestinationTableBuilder$module == null ? this.DestinationTableBuilder$lzycompute() : this.DestinationTableBuilder$module;
    }

    public Cache<String, TableInfo> destinationTableCache() {
        return this.destinationTableCache;
    }

    private Logger log() {
        return this.log;
    }

    public long DEFAULT_BYTES_PER_PARTITION() {
        return this.DEFAULT_BYTES_PER_PARTITION;
    }

    public boolean needConversion() {
        return this.needConversion;
    }

    public long sizeInBytes() {
        return this.sizeInBytes;
    }

    public StandardTableDefinition defaultTableDefinition() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.defaultTableDefinition$lzycompute() : this.defaultTableDefinition;
    }

    public RDD<Row> buildScan() {
        return this.buildScan(this.schema().fieldNames());
    }

    public RDD<Row> buildScan(String[] requiredColumns) {
        return this.buildScan(requiredColumns, (Filter[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Filter.class)));
    }

    /*
     * WARNING - void declaration
     */
    public RDD<Row> buildScan(String[] requiredColumns, Filter[] filters) {
        BigQueryRDD bigQueryRDD;
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        TableInfo actualTable = this.getActualTable(requiredColumns, filters);
        StandardTableDefinition actualTableDefinition = (StandardTableDefinition)actualTable.getDefinition();
        TableReferenceProto.TableReference actualTableReference = DirectBigQueryRelation$.MODULE$.toTableReference(actualTable.getTableId());
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug("filters pushed: {}", new Object[]{Predef$.MODULE$.refArrayOps((Object[])filters).mkString(", ")});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        String filter = this.getCompiledFilter(filters);
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug("buildScan: cols: [{}], filter: '{}'", (Object[])new String[]{Predef$.MODULE$.refArrayOps((Object[])requiredColumns).mkString(", "), filter});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ReadOptions.TableReadOptions readOptions = ReadOptions.TableReadOptions.newBuilder().addAllSelectedFields((java.lang.Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.refArrayOps((Object[])requiredColumns).toList()).asJava()).setRowRestriction(filter).build();
        Set requiredColumnSet = Predef$.MODULE$.refArrayOps((Object[])requiredColumns).toSet();
        Schema prunedSchema = Schema.of((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)actualTableDefinition.getSchema().getFields()).asScala()).filter((Function1)new Serializable(this, requiredColumnSet){
            public static final long serialVersionUID = 0L;
            private final Set requiredColumnSet$1;

            public final boolean apply(Field f) {
                return this.requiredColumnSet$1.contains((Object)f.getName());
            }
            {
                this.requiredColumnSet$1 = requiredColumnSet$1;
            }
        })).asJava()));
        BigQueryStorageClient client = (BigQueryStorageClient)this.getClient.apply((Object)super.options());
        int numPartitionsRequested = this.getNumPartitionsRequested(actualTableDefinition);
        try {
            BoxedUnit boxedUnit3;
            BoxedUnit boxedUnit4;
            Storage.ReadSession session = client.createReadSession(Storage.CreateReadSessionRequest.newBuilder().setParent(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"projects/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{super.options().parentProject()}))).setFormat(Storage.DataFormat.AVRO).setRequestedStreams(numPartitionsRequested).setReadOptions(readOptions).setTableReference(actualTableReference).setShardingStrategy(Storage.ShardingStrategy.BALANCED).build());
            BigQueryPartition[] partitions = (BigQueryPartition[])((TraversableOnce)((TraversableLike)((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(session.getStreamsList()).asScala()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Storage.Stream x$1) {
                    return x$1.getName();
                }
            }, Buffer$.MODULE$.canBuildFrom())).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final BigQueryPartition apply(Tuple2<String, Object> x0$1) {
                    Tuple2<String, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        int i = tuple2._2$mcI$sp();
                        BigQueryPartition bigQueryPartition = new BigQueryPartition(name, i);
                        return bigQueryPartition;
                    }
                    throw new MatchError(tuple2);
                }
            }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(BigQueryPartition.class));
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info("Created read session for table '{}': {}", (Object[])new String[]{this.tableName(), session.getName()});
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            if (((Object)BoxesRunTime.boxToInteger((int)numPartitionsRequested)).equals(BoxesRunTime.boxToInteger((int)partitions.length))) {
                boxedUnit3 = BoxedUnit.UNIT;
            } else if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requested ", " partitions, but only\n             |received ", " from the BigQuery Storage API for\n             |session ", ". Notice that the number of streams in\n             |actual may be lower than the requested number, depending on the\n             |amount parallelism that is reasonable for the table and the\n             |maximum amount of parallelism allowed by the system."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numPartitionsRequested), BoxesRunTime.boxToInteger((int)partitions.length), session.getName()})))).stripMargin().replace('\n', ' '));
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            bigQueryRDD = BigQueryRDD$.MODULE$.scanTable(this.sqlContext(), partitions, session.getName(), session.getAvroSchema().getSchema(), prunedSchema, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])requiredColumns), super.options(), this.getClient, this.bigQueryClient);
        }
        catch (Throwable throwable) {
            void var10_10;
            var10_10.close();
            throw throwable;
        }
        client.close();
        return bigQueryRDD;
    }

    /*
     * Enabled aggressive block sorting
     */
    public TableInfo getActualTable(String[] requiredColumns, Filter[] filters) {
        TableInfo tableInfo;
        TableDefinition tableDefinition = super.table().getDefinition();
        TableDefinition.Type tableType = tableDefinition.getType();
        if (super.options().viewsEnabled()) {
            TableDefinition.Type type = TableDefinition.Type.VIEW;
            TableDefinition.Type type2 = tableType;
            if (!(type != null ? !type.equals(type2) : type2 != null)) {
                BoxedUnit boxedUnit;
                String querySql = this.createSql(tableDefinition.getSchema(), requiredColumns, filters);
                if (this.log().underlying().isDebugEnabled()) {
                    this.log().underlying().debug("querySql is {}", new Object[]{querySql});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                tableInfo = (TableInfo)this.destinationTableCache().get((Object)querySql, (Callable)new DestinationTableBuilder(this, querySql));
                return tableInfo;
            }
        }
        tableInfo = super.table();
        return tableInfo;
    }

    public TableInfo createTableFromQuery(String querySql) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        TableId destinationTable = this.createDestinationTable();
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug("destinationTable is {}", new Object[]{destinationTable});
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        JobInfo jobInfo = JobInfo.of((JobConfiguration)QueryJobConfiguration.newBuilder((String)querySql).setDestinationTable(destinationTable).build());
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug("running query {}", new Object[]{jobInfo});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Job job = this.bigQuery().create(jobInfo, new BigQuery.JobOption[0]).waitFor(new RetryOption[0]);
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug("job has finished. {}", new Object[]{job});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (job.getStatus().getError() != null) {
            BigQueryUtil$.MODULE$.convertAndThrow(job.getStatus().getError());
        }
        Table createdTable = this.bigQuery().getTable(destinationTable, new BigQuery.TableOption[0]);
        long expirationTime = Predef$.MODULE$.Long2long(createdTable.getCreationTime()) + TimeUnit.HOURS.toMillis(super.options().viewExpirationTimeInHours());
        Table updatedTable = this.bigQuery().update((TableInfo)createdTable.toBuilder().setExpirationTime(Predef$.MODULE$.long2Long(expirationTime)).build(), new BigQuery.TableOption[0]);
        return updatedTable;
    }

    public String createSql(Schema schema, String[] requiredColumns, Filter[] filters) {
        String string;
        if (Predef$.MODULE$.refArrayOps((Object[])requiredColumns).isEmpty()) {
            StructType sparkSchema = SchemaConverters$.MODULE$.toSpark(schema);
            string = ((TraversableOnce)sparkSchema.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(StructField f) {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f.name()}));
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(",");
        } else {
            string = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])requiredColumns).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(String c) {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c}));
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(",");
        }
        String columns = string;
        String whereClause = (String)this.createWhereClause(filters).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String f) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WHERE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f}));
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT ", " FROM `", "` ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columns, this.tableName(), whereClause}));
    }

    public Option<String> createWhereClause(Filter[] filters) {
        String filtersString = DirectBigQueryRelation$.MODULE$.compileFilters((Iterable<Filter>)Predef$.MODULE$.wrapRefArray((Object[])filters));
        return BigQueryUtil$.MODULE$.noneIfEmpty(filtersString);
    }

    public TableId createDestinationTable() {
        String project = (String)super.options().viewMaterializationProject().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DirectBigQueryRelation $outer;

            public final String apply() {
                return this.$outer.tableId().getProject();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String dataset = (String)super.options().viewMaterializationDataset().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DirectBigQueryRelation $outer;

            public final String apply() {
                return this.$outer.tableId().getDataset();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        UUID uuid = UUID.randomUUID();
        String name = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_sbc_", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(uuid.getMostSignificantBits())), RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(uuid.getLeastSignificantBits()))}));
        return TableId.of((String)project, (String)dataset, (String)name);
    }

    public int getNumPartitionsRequested() {
        return this.getNumPartitionsRequested(this.defaultTableDefinition());
    }

    public int getNumPartitionsRequested(StandardTableDefinition tableDefinition) {
        return BoxesRunTime.unboxToInt((Object)super.options().parallelism().getOrElse((Function0)new Serializable(this, tableDefinition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DirectBigQueryRelation $outer;
            private final StandardTableDefinition tableDefinition$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return Math.max((int)(Predef$.MODULE$.Long2long(this.tableDefinition$1.getNumBytes()) / this.$outer.DEFAULT_BYTES_PER_PARTITION()), 1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tableDefinition$1 = tableDefinition$1;
            }
        }));
    }

    public String getCompiledFilter(Filter[] filters) {
        return super.options().combinePushedDownFilters() ? ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{super.options().filter(), BigQueryUtil$.MODULE$.noneIfEmpty(DirectBigQueryRelation$.MODULE$.compileFilters((Iterable<Filter>)Predef$.MODULE$.wrapRefArray((Object[])this.com$google$cloud$spark$bigquery$direct$DirectBigQueryRelation$$handledFilters(filters))))})).flatten((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<String> apply(Option<String> xo) {
                return Option$.MODULE$.option2Iterable(xo);
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String f) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f}));
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(" AND ") : (String)super.options().filter().getOrElse((Function0)new Serializable(this, filters){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DirectBigQueryRelation $outer;
            private final Filter[] filters$1;

            public final String apply() {
                return DirectBigQueryRelation$.MODULE$.compileFilters((Iterable<Filter>)Predef$.MODULE$.wrapRefArray((Object[])this.$outer.com$google$cloud$spark$bigquery$direct$DirectBigQueryRelation$$handledFilters(this.filters$1)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.filters$1 = filters$1;
            }
        });
    }

    public Filter[] com$google$cloud$spark$bigquery$direct$DirectBigQueryRelation$$handledFilters(Filter[] filters) {
        return (Filter[])Predef$.MODULE$.refArrayOps((Object[])filters).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Filter filter) {
                return DirectBigQueryRelation$.MODULE$.isHandled(filter);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public Filter[] unhandledFilters(Filter[] filters) {
        void var2_3;
        BoxedUnit boxedUnit;
        if (super.options().filter().isDefined()) {
            return filters;
        }
        ArrayOps arrayOps = Predef$.MODULE$.refArrayOps((Object[])this.com$google$cloud$spark$bigquery$direct$DirectBigQueryRelation$$handledFilters(filters));
        Filter[] unhandled = (Filter[])Predef$.MODULE$.refArrayOps((Object[])filters).filterNot((Function1)new Serializable(this, arrayOps){
            public static final long serialVersionUID = 0L;
            private final ArrayOps eta$0$1$1;

            public final boolean apply(Object elem) {
                return this.eta$0$1$1.contains(elem);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        });
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug("unhandledFilters: {}", new Object[]{Predef$.MODULE$.refArrayOps((Object[])unhandled).mkString(" ")});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var2_3;
    }

    public DirectBigQueryRelation(SparkBigQueryOptions options, TableInfo table, Function1<SparkBigQueryOptions, BigQueryStorageClient> getClient, Function1<SparkBigQueryOptions, BigQuery> bigQueryClient, SQLContext sqlContext) {
        this.getClient = getClient;
        this.bigQueryClient = bigQueryClient;
        super(options, table, sqlContext);
        this.tableReference = DirectBigQueryRelation$.MODULE$.toTableReference(this.tableId());
        this.destinationTableCache = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).maximumSize(1000L).build();
        this.log = Logger$.MODULE$.apply(((Object)((Object)this)).getClass());
        this.DEFAULT_BYTES_PER_PARTITION = 400000000L;
        this.needConversion = false;
        this.sizeInBytes = Predef$.MODULE$.Long2long(this.defaultTableDefinition().getNumBytes());
    }

    public class DestinationTableBuilder
    implements Callable<TableInfo>,
    Product,
    Serializable {
        private final String querySql;
        public final /* synthetic */ DirectBigQueryRelation $outer;

        public String querySql() {
            return this.querySql;
        }

        @Override
        public TableInfo call() {
            return this.com$google$cloud$spark$bigquery$direct$DirectBigQueryRelation$DestinationTableBuilder$$$outer().createTableFromQuery(this.querySql());
        }

        public DestinationTableBuilder copy(String querySql) {
            return new DestinationTableBuilder(this.com$google$cloud$spark$bigquery$direct$DirectBigQueryRelation$DestinationTableBuilder$$$outer(), querySql);
        }

        public String copy$default$1() {
            return this.querySql();
        }

        public String productPrefix() {
            return "DestinationTableBuilder";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 0: 
            }
            return this.querySql();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DestinationTableBuilder;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof DestinationTableBuilder)) return false;
            if (((DestinationTableBuilder)object).com$google$cloud$spark$bigquery$direct$DirectBigQueryRelation$DestinationTableBuilder$$$outer() != this.com$google$cloud$spark$bigquery$direct$DirectBigQueryRelation$DestinationTableBuilder$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            DestinationTableBuilder destinationTableBuilder = (DestinationTableBuilder)x$1;
            String string = this.querySql();
            String string2 = destinationTableBuilder.querySql();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!destinationTableBuilder.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ DirectBigQueryRelation com$google$cloud$spark$bigquery$direct$DirectBigQueryRelation$DestinationTableBuilder$$$outer() {
            return this.$outer;
        }

        public DestinationTableBuilder(DirectBigQueryRelation $outer, String querySql) {
            this.querySql = querySql;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }
}

