/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.auth.Credentials;
import com.google.cloud.TransportOptions;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.connector.common.BigQueryProxyConfig;
import com.google.cloud.bigquery.connector.common.BigQueryProxyTransporterBuilder;
import com.google.cloud.http.HttpTransportOptions;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.util.Properties$;

public final class BigQueryUtilScala$
implements Logging {
    public static final BigQueryUtilScala$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new BigQueryUtilScala$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public Option<String> noneIfEmpty(String s) {
        return Option$.MODULE$.apply((Object)s).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return x$1.trim().isEmpty();
            }
        });
    }

    public void validateScalaVersionCompatibility() {
        String runtimeScalaVersion = this.trimVersion(Properties$.MODULE$.versionNumberString());
        Properties buildProperties = new Properties();
        buildProperties.load(this.getClass().getResourceAsStream("/spark-bigquery-connector.properties"));
        String connectorScalaVersion = buildProperties.getProperty("scala.binary.version");
        if (runtimeScalaVersion.equals(connectorScalaVersion)) {
            return;
        }
        throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |This connector was made for Scala ", ",\n           |it was not meant to run on Scala ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{connectorScalaVersion, runtimeScalaVersion})))).stripMargin().replace('\n', ' '));
    }

    private String trimVersion(String version) {
        return version.substring(0, version.lastIndexOf(46));
    }

    public <T> Seq<T> toSeq(List<T> list) {
        return ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).toSeq();
    }

    public <T> java.util.Iterator<T> toJavaIterator(Iterator<T> it) {
        return (java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(it).asJava();
    }

    public BigQuery createBigQuery(SparkBigQueryConfig options) {
        Credentials credentials = options.createCredentials();
        String parentProjectId = options.getParentProjectId();
        this.logInfo((Function0<String>)new Serializable(parentProjectId){
            public static final long serialVersionUID = 0L;
            private final String parentProjectId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"BigQuery client project id is [", "], derived from the parentProject option"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.parentProjectId$1}));
            }
            {
                this.parentProjectId$1 = parentProjectId$1;
            }
        });
        BigQueryOptions.Builder bqOptions = (BigQueryOptions.Builder)BigQueryOptions.newBuilder().setProjectId(parentProjectId).setCredentials(credentials).setRetrySettings(options.getBigQueryClientRetrySettings());
        HttpTransportOptions.Builder httpTransportOptionsBuilder = HttpTransportOptions.newBuilder().setConnectTimeout(options.getBigQueryClientConnectTimeout()).setReadTimeout(options.getBigQueryClientReadTimeout());
        BigQueryProxyConfig proxyHttpConfig = options.getBigQueryProxyConfig();
        Object object = proxyHttpConfig.getProxyUri().isPresent() ? httpTransportOptionsBuilder.setHttpTransportFactory(BigQueryProxyTransporterBuilder.createHttpTransportFactory((Optional)proxyHttpConfig.getProxyUri(), (Optional)proxyHttpConfig.getProxyUsername(), (Optional)proxyHttpConfig.getProxyPassword())) : BoxedUnit.UNIT;
        bqOptions.setTransportOptions((TransportOptions)httpTransportOptionsBuilder.build());
        return (BigQuery)bqOptions.build().getService();
    }

    public <T> Option<T> toOption(Optional<T> javaOptional) {
        return javaOptional.isPresent() ? new Some(javaOptional.get()) : None$.MODULE$;
    }

    private BigQueryUtilScala$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

