/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.Clustering;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.LoadJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.cloud.bigquery.connector.common.BigQueryClient;
import com.google.cloud.bigquery.connector.common.BigQueryUtil;
import com.google.cloud.spark.bigquery.BigQueryUtilScala$;
import com.google.cloud.spark.bigquery.BigQueryWriteHelper$;
import com.google.cloud.spark.bigquery.IntermediateDataCleaner;
import com.google.cloud.spark.bigquery.SchemaConverters;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.SparkBigQueryUtil;
import com.google.cloud.spark.bigquery.SupportedCustomDataType;
import com.google.cloud.spark.bigquery.ToIterator;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.VolatileByteRef;

@ScalaSignature(bytes="\u0006\u0001\tee\u0001B\u0001\u0003\u00016\u00111CQ5h#V,'/_,sSR,\u0007*\u001a7qKJT!a\u0001\u0003\u0002\u0011\tLw-];fefT!!\u0002\u0004\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dA\u0011!B2m_V$'BA\u0005\u000b\u0003\u00199wn\\4mK*\t1\"A\u0002d_6\u001c\u0001aE\u0003\u0001\u001dQy\"\u0005\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+ui\u0011A\u0006\u0006\u0003/a\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u000beQ!AG\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0012aA8sO&\u0011aD\u0006\u0002\b\u0019><w-\u001b8h!\ty\u0001%\u0003\u0002\"!\t9\u0001K]8ek\u000e$\bCA\b$\u0013\t!\u0003C\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005'\u0001\tU\r\u0011\"\u0001(\u00039\u0011\u0017nZ)vKJL8\t\\5f]R,\u0012\u0001\u000b\t\u0003S=j\u0011A\u000b\u0006\u0003W1\naaY8n[>t'BA\u0017/\u0003%\u0019wN\u001c8fGR|'O\u0003\u0002\u0004\r%\u0011\u0001G\u000b\u0002\u000f\u0005&<\u0017+^3ss\u000ec\u0017.\u001a8u\u0011!\u0011\u0004A!E!\u0002\u0013A\u0013a\u00042jOF+XM]=DY&,g\u000e\u001e\u0011\t\u0011Q\u0002!Q3A\u0005\u0002U\n!b]9m\u0007>tG/\u001a=u+\u00051\u0004CA\u001c;\u001b\u0005A$BA\u001d\u0019\u0003\r\u0019\u0018\u000f\\\u0005\u0003wa\u0012!bU)M\u0007>tG/\u001a=u\u0011!i\u0004A!E!\u0002\u00131\u0014aC:rY\u000e{g\u000e^3yi\u0002B\u0001b\u0010\u0001\u0003\u0016\u0004%\t\u0001Q\u0001\tg\u00064X-T8eKV\t\u0011\t\u0005\u00028\u0005&\u00111\t\u000f\u0002\t'\u00064X-T8eK\"AQ\t\u0001B\tB\u0003%\u0011)A\u0005tCZ,Wj\u001c3fA!Aq\t\u0001BK\u0002\u0013\u0005\u0001*A\u0004paRLwN\\:\u0016\u0003%\u0003\"AS&\u000e\u0003\tI!\u0001\u0014\u0002\u0003'M\u0003\u0018M]6CS\u001e\fV/\u001a:z\u0007>tg-[4\t\u00119\u0003!\u0011#Q\u0001\n%\u000b\u0001b\u001c9uS>t7\u000f\t\u0005\t!\u0002\u0011)\u001a!C\u0001#\u0006!A-\u0019;b+\u0005\u0011\u0006CA*b\u001d\t!vL\u0004\u0002V=:\u0011a+\u0018\b\u0003/rs!\u0001W.\u000e\u0003eS!A\u0017\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0012B\u0001\u000e\u001c\u0013\t)\u0011$\u0003\u0002:1%\u0011\u0001\rO\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00117MA\u0005ECR\fgI]1nK*\u0011\u0001\r\u000f\u0005\tK\u0002\u0011\t\u0012)A\u0005%\u0006)A-\u0019;bA!Aq\r\u0001BK\u0002\u0013\u0005\u0001.A\u0006uC\ndW-\u0012=jgR\u001cX#A5\u0011\u0005=Q\u0017BA6\u0011\u0005\u001d\u0011un\u001c7fC:D\u0001\"\u001c\u0001\u0003\u0012\u0003\u0006I![\u0001\ri\u0006\u0014G.Z#ySN$8\u000f\t\u0005\u0006_\u0002!\t\u0001]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000fE\u00148\u000f^;woB\u0011!\n\u0001\u0005\u0006M9\u0004\r\u0001\u000b\u0005\u0006i9\u0004\rA\u000e\u0005\u0006\u007f9\u0004\r!\u0011\u0005\u0006\u000f:\u0004\r!\u0013\u0005\u0006!:\u0004\rA\u0015\u0005\u0006O:\u0004\r!\u001b\u0005\bs\u0002\u0011\r\u0011\"\u0001{\u0003\u0011\u0019wN\u001c4\u0016\u0003m\u00042\u0001`A\u0001\u001b\u0005i(BA=\u007f\u0015\ty\u0018$\u0001\u0004iC\u0012|w\u000e]\u0005\u0004\u0003\u0007i(!D\"p]\u001aLw-\u001e:bi&|g\u000eC\u0004\u0002\b\u0001\u0001\u000b\u0011B>\u0002\u000b\r|gN\u001a\u0011\t\u0013\u0005-\u0001A1A\u0005\u0002\u00055\u0011aB4dgB\u000bG\u000f[\u000b\u0003\u0003\u001f\u0001B!!\u0005\u0002\u00185\u0011\u00111\u0003\u0006\u0004\u0003+q\u0018A\u00014t\u0013\u0011\tI\"a\u0005\u0003\tA\u000bG\u000f\u001b\u0005\t\u0003;\u0001\u0001\u0015!\u0003\u0002\u0010\u0005AqmY:QCRD\u0007\u0005C\u0004\u0002\"\u0001!\t!a\t\u00021]\u0014\u0018\u000e^3ECR\fgI]1nKR{')[4Rk\u0016\u0014\u00180\u0006\u0002\u0002&A\u0019q\"a\n\n\u0007\u0005%\u0002C\u0001\u0003V]&$\bbBA\u0017\u0001\u0011\u0005\u0011qF\u0001\u0013Y>\fG\rR1uCR{')[4Rk\u0016\u0014\u0018\u0010\u0006\u0002\u0002&!9\u00111\u0007\u0001\u0005\u0002\u0005U\u0012AG:bm\u0016lu\u000eZ3U_^\u0013\u0018\u000e^3ESN\u0004xn]5uS>tG\u0003BA\u001c\u0003\u000f\u0002B!!\u000f\u0002B9!\u00111HA\u001f\u001b\u0005q\u0013bAA ]\u00059!j\u001c2J]\u001a|\u0017\u0002BA\"\u0003\u000b\u0012\u0001c\u0016:ji\u0016$\u0015n\u001d9pg&$\u0018n\u001c8\u000b\u0007\u0005}b\u0006\u0003\u0004@\u0003c\u0001\r!\u0011\u0005\b\u0003\u0017\u0002A\u0011AA'\u0003E1'/[3oI2LH+\u00192mK:\u000bW.Z\u000b\u0003\u0003\u001f\u0002B!!\u0015\u0002X9\u0019q\"a\u0015\n\u0007\u0005U\u0003#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00033\nYF\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003+\u0002\u0002bBA0\u0001\u0011\u0005\u00111E\u0001\u0017kB$\u0017\r^3NKR\fG-\u0019;b\u0013\u001atU-\u001a3fI\"9\u00111\r\u0001\u0005\u0002\u0005\u0015\u0014\u0001D;qI\u0006$X\r\u001a$jK2$GCBA4\u0003[\n\t\b\u0005\u0003\u0002<\u0005%\u0014bAA6]\t)a)[3mI\"A\u0011qNA1\u0001\u0004\t9'A\u0003gS\u0016dG\r\u0003\u0005\u0002t\u0005\u0005\u0004\u0019AA;\u0003%!\u0017\r^1GS\u0016dG\r\u0005\u0003\u0002x\u0005uTBAA=\u0015\r\tY\bO\u0001\u0006if\u0004Xm]\u0005\u0005\u0003\u007f\nIHA\u0006TiJ,8\r\u001e$jK2$\u0007bBAB\u0001\u0011\u0005\u00111E\u0001\u001eG2,\u0017M\u001c+f[B|'/\u0019:z\u000f\u000e\u001c\b+\u0019;i\u0013\u001atU-\u001a3fI\"9\u0011q\u0011\u0001\u0005\n\u0005%\u0015AG2sK\u0006$X\rV3na>\u0014\u0018M]=QCRDG)\u001a7fi\u0016\u0014XCAAF!\u0015y\u0011QRAI\u0013\r\ty\t\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007)\u000b\u0019*C\u0002\u0002\u0016\n\u0011q#\u00138uKJlW\rZ5bi\u0016$\u0015\r^1DY\u0016\fg.\u001a:\t\u000f\u0005e\u0005\u0001\"\u0001\u0002$\u0005qa/\u001a:jMf\u001c\u0016M^3N_\u0012,\u0007\"CAO\u0001\u0005\u0005I\u0011AAP\u0003\u0011\u0019w\u000e]=\u0015\u001bE\f\t+a)\u0002&\u0006\u001d\u0016\u0011VAV\u0011!1\u00131\u0014I\u0001\u0002\u0004A\u0003\u0002\u0003\u001b\u0002\u001cB\u0005\t\u0019\u0001\u001c\t\u0011}\nY\n%AA\u0002\u0005C\u0001bRAN!\u0003\u0005\r!\u0013\u0005\t!\u0006m\u0005\u0013!a\u0001%\"Aq-a'\u0011\u0002\u0003\u0007\u0011\u000eC\u0005\u00020\u0002\t\n\u0011\"\u0001\u00022\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAZU\rA\u0013QW\u0016\u0003\u0003o\u0003B!!/\u0002D6\u0011\u00111\u0018\u0006\u0005\u0003{\u000by,A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0019\t\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002F\u0006m&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011\u0011\u001a\u0001\u0012\u0002\u0013\u0005\u00111Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tiMK\u00027\u0003kC\u0011\"!5\u0001#\u0003%\t!a5\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\u001b\u0016\u0004\u0003\u0006U\u0006\"CAm\u0001E\u0005I\u0011AAn\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"!!8+\u0007%\u000b)\fC\u0005\u0002b\u0002\t\n\u0011\"\u0001\u0002d\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012*TCAAsU\r\u0011\u0016Q\u0017\u0005\n\u0003S\u0004\u0011\u0013!C\u0001\u0003W\fabY8qs\u0012\"WMZ1vYR$c'\u0006\u0002\u0002n*\u001a\u0011.!.\t\u0013\u0005E\b!!A\u0005B\u0005M\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002vB!\u0011q\u001fB\u0001\u001b\t\tIP\u0003\u0003\u0002|\u0006u\u0018\u0001\u00027b]\u001eT!!a@\u0002\t)\fg/Y\u0005\u0005\u00033\nI\u0010C\u0005\u0003\u0006\u0001\t\t\u0011\"\u0001\u0003\b\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011!\u0011\u0002\t\u0004\u001f\t-\u0011b\u0001B\u0007!\t\u0019\u0011J\u001c;\t\u0013\tE\u0001!!A\u0005\u0002\tM\u0011A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005+\u0011Y\u0002E\u0002\u0010\u0005/I1A!\u0007\u0011\u0005\r\te.\u001f\u0005\u000b\u0005;\u0011y!!AA\u0002\t%\u0011a\u0001=%c!I!\u0011\u0005\u0001\u0002\u0002\u0013\u0005#1E\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!Q\u0005\t\u0007\u0005O\u0011iC!\u0006\u000e\u0005\t%\"b\u0001B\u0016!\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t=\"\u0011\u0006\u0002\t\u0013R,'/\u0019;pe\"I!1\u0007\u0001\u0002\u0002\u0013\u0005!QG\u0001\tG\u0006tW)];bYR\u0019\u0011Na\u000e\t\u0015\tu!\u0011GA\u0001\u0002\u0004\u0011)\u0002C\u0005\u0003<\u0001\t\t\u0011\"\u0011\u0003>\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0003\n!I!\u0011\t\u0001\u0002\u0002\u0013\u0005#1I\u0001\ti>\u001cFO]5oOR\u0011\u0011Q\u001f\u0005\n\u0005\u000f\u0002\u0011\u0011!C!\u0005\u0013\na!Z9vC2\u001cHcA5\u0003L!Q!Q\u0004B#\u0003\u0003\u0005\rA!\u0006\b\u0013\t=#!!A\t\u0002\tE\u0013a\u0005\"jOF+XM]=Xe&$X\rS3ma\u0016\u0014\bc\u0001&\u0003T\u0019A\u0011AAA\u0001\u0012\u0003\u0011)fE\u0003\u0003T\t]#\u0005E\u0006\u0003Z\t}\u0003FN!J%&\fXB\u0001B.\u0015\r\u0011i\u0006E\u0001\beVtG/[7f\u0013\u0011\u0011\tGa\u0017\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tg\u0007C\u0004p\u0005'\"\tA!\u001a\u0015\u0005\tE\u0003B\u0003B!\u0005'\n\t\u0011\"\u0012\u0003D!Q!1\u000eB*\u0003\u0003%\tI!\u001c\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u001bE\u0014yG!\u001d\u0003t\tU$q\u000fB=\u0011\u00191#\u0011\u000ea\u0001Q!1AG!\u001bA\u0002YBaa\u0010B5\u0001\u0004\t\u0005BB$\u0003j\u0001\u0007\u0011\n\u0003\u0004Q\u0005S\u0002\rA\u0015\u0005\u0007O\n%\u0004\u0019A5\t\u0015\tu$1KA\u0001\n\u0003\u0013y(A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t\u0005%\u0011\u0012\t\u0006\u001f\u00055%1\u0011\t\n\u001f\t\u0015\u0005FN!J%&L1Aa\"\u0011\u0005\u0019!V\u000f\u001d7fm!I!1\u0012B>\u0003\u0003\u0005\r!]\u0001\u0004q\u0012\u0002\u0004B\u0003BH\u0005'\n\t\u0011\"\u0003\u0003\u0012\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011\u0019\n\u0005\u0003\u0002x\nU\u0015\u0002\u0002BL\u0003s\u0014aa\u00142kK\u000e$\b")
public class BigQueryWriteHelper
implements Logging,
Product,
Serializable {
    private final BigQueryClient bigQueryClient;
    private final SQLContext sqlContext;
    private final SaveMode saveMode;
    private final SparkBigQueryConfig options;
    private final Dataset<Row> data;
    private final boolean tableExists;
    private final Configuration conf;
    private final Path gcsPath;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Option<Tuple6<BigQueryClient, SQLContext, SaveMode, SparkBigQueryConfig, Dataset<Row>, Object>> unapply(BigQueryWriteHelper bigQueryWriteHelper) {
        return BigQueryWriteHelper$.MODULE$.unapply(bigQueryWriteHelper);
    }

    public static BigQueryWriteHelper apply(BigQueryClient bigQueryClient, SQLContext sQLContext, SaveMode saveMode, SparkBigQueryConfig sparkBigQueryConfig, Dataset<Row> dataset, boolean bl) {
        return BigQueryWriteHelper$.MODULE$.apply(bigQueryClient, sQLContext, saveMode, sparkBigQueryConfig, dataset, bl);
    }

    public static Function1<Tuple6<BigQueryClient, SQLContext, SaveMode, SparkBigQueryConfig, Dataset<Row>, Object>, BigQueryWriteHelper> tupled() {
        return BigQueryWriteHelper$.MODULE$.tupled();
    }

    public static Function1<BigQueryClient, Function1<SQLContext, Function1<SaveMode, Function1<SparkBigQueryConfig, Function1<Dataset<Row>, Function1<Object, BigQueryWriteHelper>>>>>> curried() {
        return BigQueryWriteHelper$.MODULE$.curried();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public BigQueryClient bigQueryClient() {
        return this.bigQueryClient;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public SaveMode saveMode() {
        return this.saveMode;
    }

    public SparkBigQueryConfig options() {
        return this.options;
    }

    public Dataset<Row> data() {
        return this.data;
    }

    public boolean tableExists() {
        return this.tableExists;
    }

    public Configuration conf() {
        return this.conf;
    }

    public Path gcsPath() {
        return this.gcsPath;
    }

    public void writeDataFrameToBigQuery() {
        if (BoxesRunTime.unboxToBoolean((Object)BigQueryUtilScala$.MODULE$.toOption(this.options().getCreateDisposition()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BigQueryWriteHelper $outer;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(JobInfo.CreateDisposition cd) {
                if (this.$outer.tableExists()) return false;
                JobInfo.CreateDisposition createDisposition = cd;
                JobInfo.CreateDisposition createDisposition2 = JobInfo.CreateDisposition.CREATE_NEVER;
                if (createDisposition != null) {
                    if (!createDisposition.equals(createDisposition2)) return false;
                    return true;
                }
                if (createDisposition2 == null) return true;
                return false;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }))) {
            throw new IOException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |For table ", " Create Disposition is CREATE_NEVER and the table does\n           |not exists. Aborting the insert"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.friendlyTableName()})))).stripMargin().replace('\n', ' '));
        }
        try {
            this.createTemporaryPathDeleter().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(IntermediateDataCleaner x$1) {
                    Runtime.getRuntime().addShutdownHook(x$1);
                }
            });
            String format = this.options().getIntermediateFormat().getDataSource();
            this.data().write().format(format).save(this.gcsPath().toString());
            this.loadDataToBigQuery();
            this.updateMetadataIfNeeded();
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to write to BigQuery", exception);
        }
        finally {
            this.cleanTemporaryGcsPathIfNeeded();
        }
    }

    public void loadDataToBigQuery() {
        BoxedUnit boxedUnit;
        ObjectRef finishedJob$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        FileSystem fs = this.gcsPath().getFileSystem(this.conf());
        List sourceUris = SparkBigQueryUtil.optimizeLoadUriListForSpark((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ToIterator(fs.listFiles(this.gcsPath(), false)).map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(LocatedFileStatus x$2) {
                return x$2.getPath().toString();
            }
        }).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BigQueryWriteHelper $outer;

            public final boolean apply(String x$3) {
                return x$3.toLowerCase().endsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.options().getIntermediateFormat().getFormatOptions().getType().toLowerCase()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).toList()).asJava()));
        LoadJobConfiguration.Builder jobConfigurationBuilder = LoadJobConfiguration.newBuilder((TableId)this.options().getTableId(), (List)sourceUris, (FormatOptions)this.options().getIntermediateFormat().getFormatOptions()).setCreateDisposition(JobInfo.CreateDisposition.CREATE_IF_NEEDED).setWriteDisposition(this.saveModeToWriteDisposition(this.saveMode())).setAutodetect(Predef$.MODULE$.boolean2Boolean(true));
        Object object = this.options().getCreateDisposition().isPresent() ? jobConfigurationBuilder.setCreateDisposition((JobInfo.CreateDisposition)this.options().getCreateDisposition().get()) : BoxedUnit.UNIT;
        if (this.options().getPartitionField().isPresent() || this.options().getPartitionType().isPresent()) {
            TimePartitioning.Builder timePartitionBuilder = TimePartitioning.newBuilder((TimePartitioning.Type)this.options().getPartitionTypeOrDefault());
            Object object2 = this.options().getPartitionExpirationMs().isPresent() ? timePartitionBuilder.setExpirationMs(Predef$.MODULE$.long2Long(this.options().getPartitionExpirationMs().getAsLong())) : BoxedUnit.UNIT;
            Object object3 = this.options().getPartitionRequireFilter().isPresent() ? timePartitionBuilder.setRequirePartitionFilter((Boolean)this.options().getPartitionRequireFilter().get()) : BoxedUnit.UNIT;
            Object object4 = this.options().getPartitionField().isPresent() ? timePartitionBuilder.setField((String)this.options().getPartitionField().get()) : BoxedUnit.UNIT;
            jobConfigurationBuilder.setTimePartitioning(timePartitionBuilder.build());
            if (this.options().getClusteredFields().isPresent()) {
                Clustering clustering = Clustering.newBuilder().setFields((List)this.options().getClusteredFields().get()).build();
                boxedUnit = jobConfigurationBuilder.setClustering(clustering);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Object object5 = this.options().isUseAvroLogicalTypes() ? jobConfigurationBuilder.setUseAvroLogicalTypes(Predef$.MODULE$.boolean2Boolean(true)) : BoxedUnit.UNIT;
        Object object6 = this.options().getLoadSchemaUpdateOptions().isEmpty() ? BoxedUnit.UNIT : jobConfigurationBuilder.setSchemaUpdateOptions((List)this.options().getLoadSchemaUpdateOptions());
        LoadJobConfiguration jobConfiguration = jobConfigurationBuilder.build();
        this.logInfo((Function0<String>)new Serializable(this, jobConfiguration, finishedJob$lzy, bitmap$0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BigQueryWriteHelper $outer;
            private final LoadJobConfiguration jobConfiguration$1;
            private final ObjectRef finishedJob$lzy$1;
            private final VolatileByteRef bitmap$0$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Submitted load to ", ". jobId: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.options().getTableId(), this.$outer.com$google$cloud$spark$bigquery$BigQueryWriteHelper$$finishedJob$1(this.jobConfiguration$1, this.finishedJob$lzy$1, this.bitmap$0$1).getJobId()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.jobConfiguration$1 = jobConfiguration$1;
                this.finishedJob$lzy$1 = finishedJob$lzy$1;
                this.bitmap$0$1 = bitmap$0$1;
            }
        });
        try {
            if (this.com$google$cloud$spark$bigquery$BigQueryWriteHelper$$finishedJob$1(jobConfiguration, finishedJob$lzy, bitmap$0).getStatus().getError() == null) {
                this.logInfo((Function0<String>)new Serializable(this, jobConfiguration, finishedJob$lzy, bitmap$0){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BigQueryWriteHelper $outer;
                    private final LoadJobConfiguration jobConfiguration$1;
                    private final ObjectRef finishedJob$lzy$1;
                    private final VolatileByteRef bitmap$0$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Done loading to ", ". jobId: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.friendlyTableName(), this.$outer.com$google$cloud$spark$bigquery$BigQueryWriteHelper$$finishedJob$1(this.jobConfiguration$1, this.finishedJob$lzy$1, this.bitmap$0$1).getJobId()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.jobConfiguration$1 = jobConfiguration$1;
                        this.finishedJob$lzy$1 = finishedJob$lzy$1;
                        this.bitmap$0$1 = bitmap$0$1;
                    }
                });
                return;
            }
            throw new BigQueryException(0, new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to load to ", " in job ", ". BigQuery error\n             |was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.friendlyTableName(), this.com$google$cloud$spark$bigquery$BigQueryWriteHelper$$finishedJob$1(jobConfiguration, finishedJob$lzy, bitmap$0).getJobId(), this.com$google$cloud$spark$bigquery$BigQueryWriteHelper$$finishedJob$1(jobConfiguration, finishedJob$lzy, bitmap$0).getStatus().getError().getMessage()})))).stripMargin().replace('\n', ' '), this.com$google$cloud$spark$bigquery$BigQueryWriteHelper$$finishedJob$1(jobConfiguration, finishedJob$lzy, bitmap$0).getStatus().getError());
        }
        catch (Exception exception) {
            TimePartitioning.Type partitionType = this.options().getPartitionTypeOrDefault();
            if (exception.getMessage().equals(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot output ", " partitioned data in LegacySQL"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionType})))) {
                SparkBigQueryConfig.IntermediateFormat intermediateFormat = this.options().getIntermediateFormat();
                SparkBigQueryConfig.IntermediateFormat intermediateFormat2 = SparkBigQueryConfig.IntermediateFormat.PARQUET;
                if (!(intermediateFormat != null ? !intermediateFormat.equals(intermediateFormat2) : intermediateFormat2 != null)) {
                    throw new BigQueryException(0, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " time partitioning is not available "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionType}))).append((Object)"for load jobs from PARQUET in this project yet. Please replace the intermediate ").append((Object)"format to AVRO or contact your account manager to enable this.").toString(), (Throwable)exception);
                }
            }
            JobId jobId = this.com$google$cloud$spark$bigquery$BigQueryWriteHelper$$finishedJob$1(jobConfiguration, finishedJob$lzy, bitmap$0).getJobId();
            this.logWarning((Function0<String>)new Serializable(this, jobId){
                public static final long serialVersionUID = 0L;
                private final JobId jobId$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Failed to load the data into BigQuery, JobId for debug purposes is ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", ":", ".", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.jobId$1.getProject(), this.jobId$1.getLocation(), this.jobId$1.getJob()}))).toString();
                }
                {
                    this.jobId$1 = jobId$1;
                }
            });
            throw exception;
        }
    }

    public JobInfo.WriteDisposition saveModeToWriteDisposition(SaveMode saveMode) {
        SaveMode saveMode2;
        block4: {
            JobInfo.WriteDisposition writeDisposition;
            block3: {
                block2: {
                    saveMode2 = saveMode;
                    if (!SaveMode.Append.equals(saveMode2)) break block2;
                    writeDisposition = JobInfo.WriteDisposition.WRITE_APPEND;
                    break block3;
                }
                if (!SaveMode.Overwrite.equals(saveMode2)) break block4;
                writeDisposition = JobInfo.WriteDisposition.WRITE_TRUNCATE;
            }
            return writeDisposition;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SaveMode ", " is currently not supported."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{saveMode2})));
    }

    public String friendlyTableName() {
        return BigQueryUtil.friendlyTableName((TableId)this.options().getTableId());
    }

    public void updateMetadataIfNeeded() {
        Map fieldsToUpdate = ((TraversableOnce)((TraversableLike)this.data().schema().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField field) {
                return SupportedCustomDataType.of((DataType)field.dataType()).isPresent() || SchemaConverters.getDescriptionOrCommentOfField((StructField)field).isPresent();
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, StructField> apply(StructField field) {
                return new Tuple2((Object)field.name(), (Object)field);
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        if (!fieldsToUpdate.isEmpty()) {
            this.logDebug((Function0<String>)new Serializable(this, fieldsToUpdate){
                public static final long serialVersionUID = 0L;
                private final Map fieldsToUpdate$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"updating schema, found fields to update: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fieldsToUpdate$1.keySet()}));
                }
                {
                    this.fieldsToUpdate$1 = fieldsToUpdate$1;
                }
            });
            TableInfo originalTableInfo = this.bigQueryClient().getTable(this.options().getTableIdWithoutThePartition());
            TableDefinition originalTableDefinition = originalTableInfo.getDefinition();
            Schema originalSchema = originalTableDefinition.getSchema();
            Schema updatedSchema = Schema.of((Iterable)((Iterable)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)originalSchema.getFields()).asScala()).map((Function1)new Serializable(this, fieldsToUpdate){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BigQueryWriteHelper $outer;
                private final Map fieldsToUpdate$1;

                public final Field apply(Field field) {
                    return (Field)this.fieldsToUpdate$1.get((Object)field.getName()).map((Function1)new Serializable(this, field){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$5 $outer;
                        private final Field field$1;

                        public final Field apply(StructField dataField) {
                            return this.$outer.com$google$cloud$spark$bigquery$BigQueryWriteHelper$$anonfun$$$outer().updatedField(this.field$1, dataField);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.field$1 = field$1;
                        }
                    }).getOrElse((Function0)new Serializable(this, field){
                        public static final long serialVersionUID = 0L;
                        private final Field field$1;

                        public final Field apply() {
                            return this.field$1;
                        }
                        {
                            this.field$1 = field$1;
                        }
                    });
                }

                public /* synthetic */ BigQueryWriteHelper com$google$cloud$spark$bigquery$BigQueryWriteHelper$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.fieldsToUpdate$1 = fieldsToUpdate$1;
                }
            }, Buffer$.MODULE$.canBuildFrom())).asJava()));
            TableInfo.Builder updatedTableInfo = originalTableInfo.toBuilder().setDefinition(originalTableDefinition.toBuilder().setSchema(updatedSchema).build());
            this.bigQueryClient().update(updatedTableInfo.build());
        }
    }

    public Field updatedField(Field field, StructField dataField) {
        Object object;
        Field.Builder newField = field.toBuilder();
        Optional bqDescription = SchemaConverters.getDescriptionOrCommentOfField((StructField)dataField);
        if (bqDescription.isPresent()) {
            object = newField.setDescription((String)bqDescription.get());
        } else {
            String marker = ((SupportedCustomDataType)SupportedCustomDataType.of((DataType)dataField.dataType()).get()).getTypeMarker();
            String description = field.getDescription();
            object = description == null ? newField.setDescription(marker) : (description.endsWith(marker) ? BoxedUnit.UNIT : newField.setDescription(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{description, marker}))));
        }
        return newField.build();
    }

    public void cleanTemporaryGcsPathIfNeeded() {
        this.createTemporaryPathDeleter().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(IntermediateDataCleaner x$4) {
                x$4.deletePath();
            }
        });
    }

    private Option<IntermediateDataCleaner> createTemporaryPathDeleter() {
        return BigQueryUtilScala$.MODULE$.toOption(this.options().getTemporaryGcsBucket()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BigQueryWriteHelper $outer;

            public final IntermediateDataCleaner apply(String x$5) {
                return new IntermediateDataCleaner(this.$outer.gcsPath(), this.$outer.conf());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void verifySaveMode() {
        block3: {
            block2: {
                SaveMode saveMode = this.saveMode();
                SaveMode saveMode2 = SaveMode.ErrorIfExists;
                if (!(saveMode == null ? saveMode2 != null : !saveMode.equals(saveMode2))) break block2;
                SaveMode saveMode3 = this.saveMode();
                SaveMode saveMode4 = SaveMode.Ignore;
                if (saveMode3 != null ? !saveMode3.equals(saveMode4) : saveMode4 != null) break block3;
            }
            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SaveMode ", " is not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.saveMode()})));
        }
    }

    public BigQueryWriteHelper copy(BigQueryClient bigQueryClient, SQLContext sqlContext, SaveMode saveMode, SparkBigQueryConfig options, Dataset<Row> data, boolean tableExists) {
        return new BigQueryWriteHelper(bigQueryClient, sqlContext, saveMode, options, data, tableExists);
    }

    public BigQueryClient copy$default$1() {
        return this.bigQueryClient();
    }

    public SQLContext copy$default$2() {
        return this.sqlContext();
    }

    public SaveMode copy$default$3() {
        return this.saveMode();
    }

    public SparkBigQueryConfig copy$default$4() {
        return this.options();
    }

    public Dataset<Row> copy$default$5() {
        return this.data();
    }

    public boolean copy$default$6() {
        return this.tableExists();
    }

    public String productPrefix() {
        return "BigQueryWriteHelper";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 5: {
                object = BoxesRunTime.boxToBoolean((boolean)this.tableExists());
                break;
            }
            case 4: {
                object = this.data();
                break;
            }
            case 3: {
                object = this.options();
                break;
            }
            case 2: {
                object = this.saveMode();
                break;
            }
            case 1: {
                object = this.sqlContext();
                break;
            }
            case 0: {
                object = this.bigQueryClient();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BigQueryWriteHelper;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.bigQueryClient()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.sqlContext()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.saveMode()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.options()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.data()));
        n = Statics.mix((int)n, (int)(this.tableExists() ? 1231 : 1237));
        return Statics.finalizeHash((int)n, (int)6);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BigQueryWriteHelper)) return false;
        boolean bl = true;
        if (!bl) return false;
        BigQueryWriteHelper bigQueryWriteHelper = (BigQueryWriteHelper)x$1;
        BigQueryClient bigQueryClient = this.bigQueryClient();
        BigQueryClient bigQueryClient2 = bigQueryWriteHelper.bigQueryClient();
        if (bigQueryClient == null) {
            if (bigQueryClient2 != null) {
                return false;
            }
        } else if (!bigQueryClient.equals(bigQueryClient2)) return false;
        SQLContext sQLContext = this.sqlContext();
        SQLContext sQLContext2 = bigQueryWriteHelper.sqlContext();
        if (sQLContext == null) {
            if (sQLContext2 != null) {
                return false;
            }
        } else if (!sQLContext.equals(sQLContext2)) return false;
        SaveMode saveMode = this.saveMode();
        SaveMode saveMode2 = bigQueryWriteHelper.saveMode();
        if (saveMode == null) {
            if (saveMode2 != null) {
                return false;
            }
        } else if (!saveMode.equals(saveMode2)) return false;
        SparkBigQueryConfig sparkBigQueryConfig = this.options();
        SparkBigQueryConfig sparkBigQueryConfig2 = bigQueryWriteHelper.options();
        if (sparkBigQueryConfig == null) {
            if (sparkBigQueryConfig2 != null) {
                return false;
            }
        } else if (!sparkBigQueryConfig.equals(sparkBigQueryConfig2)) return false;
        Dataset<Row> dataset = this.data();
        Dataset<Row> dataset2 = bigQueryWriteHelper.data();
        if (dataset == null) {
            if (dataset2 != null) {
                return false;
            }
        } else if (!dataset.equals(dataset2)) return false;
        if (this.tableExists() != bigQueryWriteHelper.tableExists()) return false;
        if (!bigQueryWriteHelper.canEqual(this)) return false;
        return true;
    }

    private final Job finishedJob$lzycompute$1(LoadJobConfiguration jobConfiguration$1, ObjectRef finishedJob$lzy$1, VolatileByteRef bitmap$0$1) {
        BigQueryWriteHelper bigQueryWriteHelper = this;
        synchronized (bigQueryWriteHelper) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                finishedJob$lzy$1.elem = this.bigQueryClient().createAndWaitFor((JobConfiguration)jobConfiguration$1);
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (Job)finishedJob$lzy$1.elem;
        }
    }

    public final Job com$google$cloud$spark$bigquery$BigQueryWriteHelper$$finishedJob$1(LoadJobConfiguration jobConfiguration$1, ObjectRef finishedJob$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.finishedJob$lzycompute$1(jobConfiguration$1, finishedJob$lzy$1, bitmap$0$1) : (Job)finishedJob$lzy$1.elem;
    }

    public BigQueryWriteHelper(BigQueryClient bigQueryClient, SQLContext sqlContext, SaveMode saveMode, SparkBigQueryConfig options, Dataset<Row> data, boolean tableExists) {
        this.bigQueryClient = bigQueryClient;
        this.sqlContext = sqlContext;
        this.saveMode = saveMode;
        this.options = options;
        this.data = data;
        this.tableExists = tableExists;
        Logging.class.$init$((Logging)this);
        Product.class.$init$((Product)this);
        this.conf = sqlContext.sparkContext().hadoopConfiguration();
        boolean needNewPath = true;
        Path gcsPath = null;
        String applicationId = sqlContext.sparkContext().applicationId();
        UUID uuid = UUID.randomUUID();
        while (needNewPath) {
            block6: {
                String string;
                block4: {
                    boolean bl;
                    block5: {
                        Option option;
                        Option option2;
                        block3: {
                            Option temporaryGcsBucketOption = BigQueryUtilScala$.MODULE$.toOption(options.getTemporaryGcsBucket());
                            bl = false;
                            option2 = null;
                            option = temporaryGcsBucketOption;
                            if (!(option instanceof Some)) break block3;
                            Some some = (Some)option;
                            String bucket = (String)some.x();
                            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"gs://", "/.spark-bigquery-", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket, applicationId, uuid}));
                            break block4;
                        }
                        if (!None$.MODULE$.equals(option)) break block5;
                        bl = true;
                        option2 = option;
                        if (!options.getPersistentGcsBucket().isPresent() || !options.getPersistentGcsPath().isPresent()) break block5;
                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"gs://", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{options.getPersistentGcsBucket().get(), options.getPersistentGcsPath().get()}));
                        break block4;
                    }
                    if (!bl || !options.getPersistentGcsBucket().isPresent()) break block6;
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"gs://", "/.spark-bigquery-", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{options.getPersistentGcsBucket().get(), applicationId, uuid}));
                }
                String gcsPathOption = string;
                gcsPath = new Path(gcsPathOption);
                FileSystem fs = gcsPath.getFileSystem(this.conf());
                needNewPath = fs.exists(gcsPath);
                continue;
            }
            throw new IllegalArgumentException("Temporary or persistent GCS bucket must be informed.");
        }
        this.gcsPath = gcsPath;
    }
}

