/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.direct;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.storage.v1.BigQueryReadClient;
import com.google.cloud.bigquery.storage.v1.DataFormat;
import com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.direct.ArrowConverter;
import com.google.cloud.spark.bigquery.direct.AvroConverter;
import com.google.cloud.spark.bigquery.direct.BigQueryPartition;
import com.google.cloud.spark.bigquery.direct.BigQueryRDD$;
import com.google.cloud.spark.bigquery.direct.ReadRowsClientWrapper;
import com.google.cloud.spark.bigquery.direct.ReadRowsHelper;
import org.apache.spark.InterruptibleIterator;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import scala.Function1;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\u0001\u0003\u0001=\u00111BQ5h#V,'/\u001f*E\t*\u00111\u0001B\u0001\u0007I&\u0014Xm\u0019;\u000b\u0005\u00151\u0011\u0001\u00032jOF,XM]=\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0015\u0019Gn\\;e\u0015\tYA\"\u0001\u0004h_><G.\u001a\u0006\u0002\u001b\u0005\u00191m\\7\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0004#eYR\"\u0001\n\u000b\u0005M!\u0012a\u0001:eI*\u0011q!\u0006\u0006\u0003-]\ta!\u00199bG\",'\"\u0001\r\u0002\u0007=\u0014x-\u0003\u0002\u001b%\t\u0019!\u000b\u0012#\u0011\u0005q\tS\"A\u000f\u000b\u0005yy\u0012\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0001\"\u0012aA:rY&\u0011!%\b\u0002\f\u0013:$XM\u001d8bYJ{w\u000f\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003&\u0003\t\u00198\r\u0005\u0002'O5\tA#\u0003\u0002))\ta1\u000b]1sW\u000e{g\u000e^3yi\"A!\u0006\u0001B\u0001B\u0003%1&A\u0003qCJ$8\u000fE\u0002-_Ej\u0011!\f\u0006\u0002]\u0005)1oY1mC&\u0011\u0001'\f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003MIJ!a\r\u000b\u0003\u0013A\u000b'\u000f^5uS>t\u0007\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001c\u0002\u000fM,7o]5p]B\u0011q'P\u0007\u0002q)\u0011\u0011HO\u0001\u0003mFR!a\u000f\u001f\u0002\u000fM$xN]1hK*\u0011Q\u0001C\u0005\u0003}a\u00121BU3bIN+7o]5p]\"A\u0001\t\u0001B\u0001B\u0003%\u0011)\u0001\bd_2,XN\\:J]>\u0013H-\u001a:\u0011\u0007\tSUJ\u0004\u0002D\u0011:\u0011AiR\u0007\u0002\u000b*\u0011aID\u0001\u0007yI|w\u000e\u001e \n\u00039J!!S\u0017\u0002\u000fA\f7m[1hK&\u00111\n\u0014\u0002\u0004'\u0016\f(BA%.!\tq\u0015K\u0004\u0002-\u001f&\u0011\u0001+L\u0001\u0007!J,G-\u001a4\n\u0005I\u001b&AB*ue&twM\u0003\u0002Q[!AQ\u000b\u0001B\u0001B\u0003%a+\u0001\u0005ccN\u001b\u0007.Z7b!\t9\u0006,D\u0001=\u0013\tIFH\u0001\u0004TG\",W.\u0019\u0005\t7\u0002\u0011\t\u0011)A\u00059\u00069q\u000e\u001d;j_:\u001c\bCA/_\u001b\u0005!\u0011BA0\u0005\u0005M\u0019\u0006/\u0019:l\u0005&<\u0017+^3ss\u000e{gNZ5h\u0011!\t\u0007A!A!\u0002\u0013\u0011\u0017!C4fi\u000ec\u0017.\u001a8u!\u0011a3\rX3\n\u0005\u0011l#!\u0003$v]\u000e$\u0018n\u001c82!\t9d-\u0003\u0002hq\t\u0011\")[4Rk\u0016\u0014\u0018PU3bI\u000ec\u0017.\u001a8u\u0011!I\u0007A!A!\u0002\u0013Q\u0017A\u00042jOF+XM]=DY&,g\u000e\u001e\t\u0005Y\rd6\u000e\u0005\u0002XY&\u0011Q\u000e\u0010\u0002\t\u0005&<\u0017+^3ss\")q\u000e\u0001C\u0001a\u00061A(\u001b8jiz\"\u0012\"]:ukZ<\b0\u001f>\u0011\u0005I\u0004Q\"\u0001\u0002\t\u000b\u0011r\u0007\u0019A\u0013\t\u000b)r\u0007\u0019A\u0016\t\u000bUr\u0007\u0019\u0001\u001c\t\u000b\u0001s\u0007\u0019A!\t\u000bUs\u0007\u0019\u0001,\t\u000bms\u0007\u0019\u0001/\t\u000b\u0005t\u0007\u0019\u00012\t\u000b%t\u0007\u0019\u00016\t\u000bq\u0004A\u0011I?\u0002\u000f\r|W\u000e];uKR)a0a\u0001\u0002\bA\u0019!i`\u000e\n\u0007\u0005\u0005AJ\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011\u0019\t)a\u001fa\u0001c\u0005)1\u000f\u001d7ji\"9\u0011\u0011B>A\u0002\u0005-\u0011aB2p]R,\u0007\u0010\u001e\t\u0004M\u00055\u0011bAA\b)\tYA+Y:l\u0007>tG/\u001a=u\u0011\u001d\t\u0019\u0002\u0001C)\u0003+\tQbZ3u!\u0006\u0014H/\u001b;j_:\u001cX#A\u0016\b\u000f\u0005e!\u0001#\u0001\u0002\u001c\u0005Y!)[4Rk\u0016\u0014\u0018P\u0015#E!\r\u0011\u0018Q\u0004\u0004\u0007\u0003\tA\t!a\b\u0014\r\u0005u\u0011\u0011EA\u0014!\ra\u00131E\u0005\u0004\u0003Ki#AB!osJ+g\rE\u0002-\u0003SI1!a\u000b.\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u001dy\u0017Q\u0004C\u0001\u0003_!\"!a\u0007\t\u0011\u0005M\u0012Q\u0004C\u0001\u0003k\t\u0011b]2b]R\u000b'\r\\3\u0015#E\f9$a\u0011\u0002F\u0005\u001d\u0013\u0011JA&\u0003\u001b\ny\u0005\u0003\u0005\u0002:\u0005E\u0002\u0019AA\u001e\u0003)\u0019\u0018\u000f\\\"p]R,\u0007\u0010\u001e\t\u0005\u0003{\ty$D\u0001 \u0013\r\t\te\b\u0002\u000b'Fc5i\u001c8uKb$\bB\u0002\u0016\u00022\u0001\u00071\u0006\u0003\u00046\u0003c\u0001\rA\u000e\u0005\u0007+\u0006E\u0002\u0019\u0001,\t\r\u0001\u000b\t\u00041\u0001B\u0011\u0019Y\u0016\u0011\u0007a\u00019\"1\u0011-!\rA\u0002\tDa![A\u0019\u0001\u0004Q\u0007BCA*\u0003;\t\t\u0011\"\u0003\u0002V\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t9\u0006\u0005\u0003\u0002Z\u0005\rTBAA.\u0015\u0011\ti&a\u0018\u0002\t1\fgn\u001a\u0006\u0003\u0003C\nAA[1wC&!\u0011QMA.\u0005\u0019y%M[3di\u0002")
public class BigQueryRDD
extends RDD<InternalRow> {
    private final Partition[] parts;
    private final ReadSession session;
    private final Seq<String> columnsInOrder;
    private final Schema bqSchema;
    private final SparkBigQueryConfig options;
    private final Function1<SparkBigQueryConfig, BigQueryReadClient> getClient;

    public static BigQueryRDD scanTable(SQLContext sQLContext, Partition[] partitionArray, ReadSession readSession, Schema schema, Seq<String> seq, SparkBigQueryConfig sparkBigQueryConfig, Function1<SparkBigQueryConfig, BigQueryReadClient> function1, Function1<SparkBigQueryConfig, BigQuery> function12) {
        return BigQueryRDD$.MODULE$.scanTable(sQLContext, partitionArray, readSession, schema, seq, sparkBigQueryConfig, function1, function12);
    }

    public Iterator<InternalRow> compute(Partition split, TaskContext context) {
        BigQueryPartition bqPartition = (BigQueryPartition)split;
        ReadRowsRequest.Builder request = ReadRowsRequest.newBuilder().setReadStream(bqPartition.stream());
        BigQueryReadClient client = (BigQueryReadClient)this.getClient.apply((Object)this.options);
        context.addTaskCompletionListener((Function1)new Serializable(this, client){
            public static final long serialVersionUID = 0L;
            private final BigQueryReadClient client$1;

            public final TaskContext apply(TaskContext ctx) {
                this.client$1.close();
                return ctx;
            }
            {
                this.client$1 = client$1;
            }
        });
        Iterator<ReadRowsResponse> readRowResponses = new ReadRowsHelper(new ReadRowsClientWrapper(client), request, this.options.getMaxReadRowsRetries()).readRows();
        Iterator<InternalRow> it = this.options.getReadDataFormat().equals((Object)DataFormat.AVRO) ? new AvroConverter(this.bqSchema, this.columnsInOrder, this.session.getAvroSchema().getSchema(), readRowResponses, this.options.getSchema()).getIterator() : new ArrowConverter(this.columnsInOrder, this.session.getArrowSchema().getSerializedSchema(), readRowResponses, this.options.getSchema()).getIterator();
        return new InterruptibleIterator(context, it);
    }

    public Partition[] getPartitions() {
        return this.parts;
    }

    public BigQueryRDD(SparkContext sc, Partition[] parts, ReadSession session, Seq<String> columnsInOrder, Schema bqSchema, SparkBigQueryConfig options, Function1<SparkBigQueryConfig, BigQueryReadClient> getClient, Function1<SparkBigQueryConfig, BigQuery> bigQueryClient) {
        this.parts = parts;
        this.session = session;
        this.columnsInOrder = columnsInOrder;
        this.bqSchema = bqSchema;
        this.options = options;
        this.getClient = getClient;
        super(sc, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(InternalRow.class));
    }
}

