/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.direct;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.connector.common.BigQueryProxyConfig;
import com.google.cloud.bigquery.connector.common.BigQueryProxyTransporterBuilder;
import com.google.cloud.bigquery.connector.common.ReadSessionCreatorConfig;
import com.google.cloud.bigquery.storage.v1.BigQueryReadClient;
import com.google.cloud.bigquery.storage.v1.BigQueryReadSettings;
import com.google.cloud.bigquery.storage.v1.DataFormat;
import com.google.cloud.spark.bigquery.BigQueryUtilScala$;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.SparkBigQueryConnectorUserAgentProvider;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Optional;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DirectBigQueryRelation$
implements Serializable {
    public static final DirectBigQueryRelation$ MODULE$;
    private int emptyRowRDDsCreated;

    static {
        new DirectBigQueryRelation$();
    }

    public int emptyRowRDDsCreated() {
        return this.emptyRowRDDsCreated;
    }

    public void emptyRowRDDsCreated_$eq(int x$1) {
        this.emptyRowRDDsCreated = x$1;
    }

    public BigQueryReadClient createReadClient(SparkBigQueryConfig options) {
        BigQueryProxyConfig proxyHttpConfig = options.getBigQueryProxyConfig();
        InstantiatingGrpcChannelProvider.Builder settingsBuilder = BigQueryReadSettings.defaultGrpcTransportProviderBuilder();
        Object object = proxyHttpConfig.getProxyUri().isPresent() ? settingsBuilder.setChannelConfigurator(BigQueryProxyTransporterBuilder.createGrpcChannelConfigurator((Optional)proxyHttpConfig.getProxyUri(), (Optional)proxyHttpConfig.getProxyUsername(), (Optional)proxyHttpConfig.getProxyPassword())) : BoxedUnit.UNIT;
        settingsBuilder.setHeaderProvider((HeaderProvider)this.headerProvider());
        ReadSessionCreatorConfig readSessionConfig = options.toReadSessionCreatorConfig();
        Object object2 = readSessionConfig.endpoint().isPresent() ? settingsBuilder.setEndpoint((String)readSessionConfig.endpoint().get()) : BoxedUnit.UNIT;
        BigQueryReadSettings.Builder clientSettings = (BigQueryReadSettings.Builder)BigQueryReadSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)settingsBuilder.build());
        clientSettings.setCredentialsProvider(new CredentialsProvider(options){
            private final SparkBigQueryConfig options$1;

            public Credentials getCredentials() {
                return this.options$1.createCredentials();
            }
            {
                this.options$1 = options$1;
            }
        });
        return BigQueryReadClient.create((BigQueryReadSettings)clientSettings.build());
    }

    private FixedHeaderProvider headerProvider() {
        return FixedHeaderProvider.create((String[])new String[]{"user-agent", new SparkBigQueryConnectorUserAgentProvider("v1").getUserAgent()});
    }

    public boolean isTopLevelFieldFilterHandled(boolean pushAllFilters, Filter filter, DataFormat readDataFormat, Map<String, StructField> fields) {
        boolean bl;
        block20: {
            Filter filter2;
            while (true) {
                Filter child;
                if (pushAllFilters) {
                    return true;
                }
                filter2 = filter;
                if (filter2 instanceof EqualTo) {
                    EqualTo equalTo = (EqualTo)filter2;
                    String attr = equalTo.attribute();
                    bl = this.isFilterWithNamedFieldHandled(filter, readDataFormat, fields, attr);
                    break block20;
                }
                if (filter2 instanceof GreaterThan) {
                    GreaterThan greaterThan = (GreaterThan)filter2;
                    String attr = greaterThan.attribute();
                    bl = this.isFilterWithNamedFieldHandled(filter, readDataFormat, fields, attr);
                    break block20;
                }
                if (filter2 instanceof GreaterThanOrEqual) {
                    GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter2;
                    String attr = greaterThanOrEqual.attribute();
                    bl = this.isFilterWithNamedFieldHandled(filter, readDataFormat, fields, attr);
                    break block20;
                }
                if (filter2 instanceof LessThan) {
                    LessThan lessThan = (LessThan)filter2;
                    String attr = lessThan.attribute();
                    bl = this.isFilterWithNamedFieldHandled(filter, readDataFormat, fields, attr);
                    break block20;
                }
                if (filter2 instanceof LessThanOrEqual) {
                    LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter2;
                    String attr = lessThanOrEqual.attribute();
                    bl = this.isFilterWithNamedFieldHandled(filter, readDataFormat, fields, attr);
                    break block20;
                }
                if (filter2 instanceof In) {
                    In in = (In)filter2;
                    String attr = in.attribute();
                    bl = this.isFilterWithNamedFieldHandled(filter, readDataFormat, fields, attr);
                    break block20;
                }
                if (filter2 instanceof IsNull) {
                    IsNull isNull = (IsNull)filter2;
                    String attr = isNull.attribute();
                    bl = this.isFilterWithNamedFieldHandled(filter, readDataFormat, fields, attr);
                    break block20;
                }
                if (filter2 instanceof IsNotNull) {
                    IsNotNull isNotNull = (IsNotNull)filter2;
                    String attr = isNotNull.attribute();
                    bl = this.isFilterWithNamedFieldHandled(filter, readDataFormat, fields, attr);
                    break block20;
                }
                if (filter2 instanceof And) {
                    And and = (And)filter2;
                    Filter lhs = and.left();
                    Filter rhs = and.right();
                    if (this.isTopLevelFieldFilterHandled(pushAllFilters, lhs, readDataFormat, fields)) {
                        filter = rhs;
                        continue;
                    }
                    bl = false;
                    break block20;
                }
                if (filter2 instanceof Or) {
                    Or or = (Or)filter2;
                    Filter lhs = or.left();
                    Filter rhs = or.right();
                    DataFormat dataFormat = readDataFormat;
                    DataFormat dataFormat2 = DataFormat.AVRO;
                    if (!(dataFormat != null ? !dataFormat.equals(dataFormat2) : dataFormat2 != null) && this.isTopLevelFieldFilterHandled(pushAllFilters, lhs, readDataFormat, fields)) {
                        filter = rhs;
                        continue;
                    }
                    bl = false;
                    break block20;
                }
                if (!(filter2 instanceof Not)) break;
                Not not = (Not)filter2;
                filter = child = not.child();
            }
            if (filter2 instanceof StringStartsWith) {
                StringStartsWith stringStartsWith = (StringStartsWith)filter2;
                String attr = stringStartsWith.attribute();
                bl = this.isFilterWithNamedFieldHandled(filter, readDataFormat, fields, attr);
            } else if (filter2 instanceof StringEndsWith) {
                StringEndsWith stringEndsWith = (StringEndsWith)filter2;
                String attr = stringEndsWith.attribute();
                bl = this.isFilterWithNamedFieldHandled(filter, readDataFormat, fields, attr);
            } else if (filter2 instanceof StringContains) {
                StringContains stringContains = (StringContains)filter2;
                String attr = stringContains.attribute();
                bl = this.isFilterWithNamedFieldHandled(filter, readDataFormat, fields, attr);
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public boolean isFilterWithNamedFieldHandled(Filter filter, DataFormat readDataFormat, Map<String, StructField> fields, String fieldName) {
        return BoxesRunTime.unboxToBoolean((Object)fields.get((Object)fieldName).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField f) {
                return f.dataType() instanceof StructType || f.dataType() instanceof ArrayType;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField x$4) {
                return false;
            }
        }).getOrElse((Function0)new Serializable(filter, readDataFormat){
            public static final long serialVersionUID = 0L;
            private final Filter filter$2;
            private final DataFormat readDataFormat$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return DirectBigQueryRelation$.MODULE$.isHandled(this.filter$2, this.readDataFormat$1);
            }
            {
                this.filter$2 = filter$2;
                this.readDataFormat$1 = readDataFormat$1;
            }
        }));
    }

    public boolean isHandled(Filter filter, DataFormat readDataFormat) {
        boolean bl;
        block14: {
            Filter filter2;
            while (true) {
                Filter child;
                if ((filter2 = filter) instanceof EqualTo) {
                    bl = true;
                    break block14;
                }
                if (filter2 instanceof EqualNullSafe) {
                    bl = false;
                    break block14;
                }
                if (filter2 instanceof GreaterThan) {
                    bl = true;
                    break block14;
                }
                if (filter2 instanceof GreaterThanOrEqual) {
                    bl = true;
                    break block14;
                }
                if (filter2 instanceof LessThan) {
                    bl = true;
                    break block14;
                }
                if (filter2 instanceof LessThanOrEqual) {
                    bl = true;
                    break block14;
                }
                if (filter2 instanceof In) {
                    bl = true;
                    break block14;
                }
                if (filter2 instanceof IsNull) {
                    bl = true;
                    break block14;
                }
                if (filter2 instanceof IsNotNull) {
                    bl = true;
                    break block14;
                }
                if (filter2 instanceof And) {
                    And and = (And)filter2;
                    Filter lhs = and.left();
                    Filter rhs = and.right();
                    if (this.isHandled(lhs, readDataFormat)) {
                        filter = rhs;
                        continue;
                    }
                    bl = false;
                    break block14;
                }
                if (filter2 instanceof Or) {
                    Or or = (Or)filter2;
                    Filter lhs = or.left();
                    Filter rhs = or.right();
                    DataFormat dataFormat = readDataFormat;
                    DataFormat dataFormat2 = DataFormat.AVRO;
                    if (!(dataFormat != null ? !dataFormat.equals(dataFormat2) : dataFormat2 != null) && this.isHandled(lhs, readDataFormat)) {
                        filter = rhs;
                        continue;
                    }
                    bl = false;
                    break block14;
                }
                if (!(filter2 instanceof Not)) break;
                Not not = (Not)filter2;
                filter = child = not.child();
            }
            bl = filter2 instanceof StringStartsWith ? true : (filter2 instanceof StringEndsWith ? true : filter2 instanceof StringContains);
        }
        return bl;
    }

    public String compileFilter(Filter filter) {
        block16: {
            String string;
            block3: {
                Filter filter2;
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        block9: {
                                            block8: {
                                                block7: {
                                                    block6: {
                                                        block5: {
                                                            block4: {
                                                                block2: {
                                                                    filter2 = filter;
                                                                    if (!(filter2 instanceof EqualTo)) break block2;
                                                                    EqualTo equalTo = (EqualTo)filter2;
                                                                    String attr = equalTo.attribute();
                                                                    Object value = equalTo.value();
                                                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.quote(attr), this.com$google$cloud$spark$bigquery$direct$DirectBigQueryRelation$$compileValue(value)}));
                                                                    break block3;
                                                                }
                                                                if (!(filter2 instanceof GreaterThan)) break block4;
                                                                GreaterThan greaterThan = (GreaterThan)filter2;
                                                                String attr = greaterThan.attribute();
                                                                Object value = greaterThan.value();
                                                                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " > ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attr, this.com$google$cloud$spark$bigquery$direct$DirectBigQueryRelation$$compileValue(value)}));
                                                                break block3;
                                                            }
                                                            if (!(filter2 instanceof GreaterThanOrEqual)) break block5;
                                                            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter2;
                                                            String attr = greaterThanOrEqual.attribute();
                                                            Object value = greaterThanOrEqual.value();
                                                            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " >= ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.quote(attr), this.com$google$cloud$spark$bigquery$direct$DirectBigQueryRelation$$compileValue(value)}));
                                                            break block3;
                                                        }
                                                        if (!(filter2 instanceof LessThan)) break block6;
                                                        LessThan lessThan = (LessThan)filter2;
                                                        String attr = lessThan.attribute();
                                                        Object value = lessThan.value();
                                                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " < ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.quote(attr), this.com$google$cloud$spark$bigquery$direct$DirectBigQueryRelation$$compileValue(value)}));
                                                        break block3;
                                                    }
                                                    if (!(filter2 instanceof LessThanOrEqual)) break block7;
                                                    LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter2;
                                                    String attr = lessThanOrEqual.attribute();
                                                    Object value = lessThanOrEqual.value();
                                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " <= ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.quote(attr), this.com$google$cloud$spark$bigquery$direct$DirectBigQueryRelation$$compileValue(value)}));
                                                    break block3;
                                                }
                                                if (!(filter2 instanceof In)) break block8;
                                                In in = (In)filter2;
                                                String attr = in.attribute();
                                                Object[] values = in.values();
                                                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " IN UNNEST(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.quote(attr), this.com$google$cloud$spark$bigquery$direct$DirectBigQueryRelation$$compileValue(values)}));
                                                break block3;
                                            }
                                            if (!(filter2 instanceof IsNull)) break block9;
                                            IsNull isNull = (IsNull)filter2;
                                            String attr = isNull.attribute();
                                            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " IS NULL"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.quote(attr)}));
                                            break block3;
                                        }
                                        if (!(filter2 instanceof IsNotNull)) break block10;
                                        IsNotNull isNotNull = (IsNotNull)filter2;
                                        String attr = isNotNull.attribute();
                                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " IS NOT NULL"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.quote(attr)}));
                                        break block3;
                                    }
                                    if (!(filter2 instanceof And)) break block11;
                                    And and = (And)filter2;
                                    Filter lhs = and.left();
                                    Filter rhs = and.right();
                                    string = ((TraversableOnce)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Filter[]{lhs, rhs}))).map((Function1)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(Filter filter) {
                                            return DirectBigQueryRelation$.MODULE$.compileFilter(filter);
                                        }
                                    }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(String p) {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p}));
                                        }
                                    }, Seq$.MODULE$.canBuildFrom())).mkString("(", " AND ", ")");
                                    break block3;
                                }
                                if (!(filter2 instanceof Or)) break block12;
                                Or or = (Or)filter2;
                                Filter lhs = or.left();
                                Filter rhs = or.right();
                                string = ((TraversableOnce)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Filter[]{lhs, rhs}))).map((Function1)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(Filter filter) {
                                        return DirectBigQueryRelation$.MODULE$.compileFilter(filter);
                                    }
                                }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(String p) {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p}));
                                    }
                                }, Seq$.MODULE$.canBuildFrom())).mkString("(", " OR ", ")");
                                break block3;
                            }
                            if (!(filter2 instanceof Not)) break block13;
                            Not not = (Not)filter2;
                            Filter child = not.child();
                            string = ((TraversableOnce)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Filter[]{child}))).map((Function1)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final String apply(Filter filter) {
                                    return DirectBigQueryRelation$.MODULE$.compileFilter(filter);
                                }
                            }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final String apply(String p) {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(NOT (", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p}));
                                }
                            }, Seq$.MODULE$.canBuildFrom())).mkString();
                            break block3;
                        }
                        if (!(filter2 instanceof StringStartsWith)) break block14;
                        StringStartsWith stringStartsWith = (StringStartsWith)filter2;
                        String attr = stringStartsWith.attribute();
                        String value = stringStartsWith.value();
                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " LIKE '''", "%'''"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.quote(attr), value.replace("'", "\\'")}));
                        break block3;
                    }
                    if (!(filter2 instanceof StringEndsWith)) break block15;
                    StringEndsWith stringEndsWith = (StringEndsWith)filter2;
                    String attr = stringEndsWith.attribute();
                    String value = stringEndsWith.value();
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " LIKE '''%", "'''"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.quote(attr), value.replace("'", "\\'")}));
                    break block3;
                }
                if (!(filter2 instanceof StringContains)) break block16;
                StringContains stringContains = (StringContains)filter2;
                String attr = stringContains.attribute();
                String value = stringContains.value();
                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " LIKE '''%", "%'''"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.quote(attr), value.replace("'", "\\'")}));
            }
            return string;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid filter: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filter})));
    }

    public String compileFilters(Iterable<Filter> filters) {
        return ((TraversableOnce)((TraversableOnce)filters.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Filter filter) {
                return DirectBigQueryRelation$.MODULE$.compileFilter(filter);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString(" AND ");
    }

    public Object com$google$cloud$spark$bigquery$direct$DirectBigQueryRelation$$compileValue(Object value) {
        Object object;
        Object object2 = value;
        if (object2 == null) {
            object = "null";
        } else if (object2 instanceof String) {
            String string = (String)object2;
            object = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string.replace("'", "\\'")}));
        } else if (object2 instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object2;
            object = new StringBuilder().append((Object)"TIMESTAMP '").append((Object)timestamp).append((Object)"'").toString();
        } else if (object2 instanceof Date) {
            Date date = (Date)object2;
            object = new StringBuilder().append((Object)"DATE '").append((Object)date).append((Object)"'").toString();
        } else if (object2 instanceof Object[]) {
            Object[] objectArray = (Object[])object2;
            object = Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps((Object)objectArray).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Object apply(Object value) {
                    return DirectBigQueryRelation$.MODULE$.com$google$cloud$spark$bigquery$direct$DirectBigQueryRelation$$compileValue(value);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).mkString("[", ", ", "]");
        } else {
            object = value;
        }
        return object;
    }

    private String quote(String attr) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attr}));
    }

    public String toTablePath(TableId tableId) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"projects/", "/datasets/", "/tables/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableId.getProject(), tableId.getDataset(), tableId.getTable()}));
    }

    public String toSqlTableReference(TableId tableId) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableId.getProject(), tableId.getDataset(), tableId.getTable()}));
    }

    public Function1<SparkBigQueryConfig, BigQueryReadClient> $lessinit$greater$default$3() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BigQueryReadClient apply(SparkBigQueryConfig options) {
                return DirectBigQueryRelation$.MODULE$.createReadClient(options);
            }
        };
    }

    public Function1<SparkBigQueryConfig, BigQuery> $lessinit$greater$default$4() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BigQuery apply(SparkBigQueryConfig options) {
                return BigQueryUtilScala$.MODULE$.createBigQuery(options);
            }
        };
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DirectBigQueryRelation$() {
        MODULE$ = this;
        this.emptyRowRDDsCreated = 0;
    }
}

