/*
 * Copyright 2018 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.connector.common.VersionProvider;
import org.apache.spark.SparkContext;
import scala.util.Properties;

import static java.lang.String.format;

public class SparkBigQueryConnectorVersionProvider implements VersionProvider {

  private SparkContext sparkContext;

  public SparkBigQueryConnectorVersionProvider(SparkContext sparkContext) {
    this.sparkContext = sparkContext;
  }

  @Override
  public String getVersion() {
    return format(
        "spark-bigquery-connector/%s spark/%s java/%s scala/%s",
        SparkBigQueryUtil.CONNECTOR_VERSION,
        sparkContext.version(),
        System.getProperty("java.runtime.version"),
        Properties.versionNumberString());
  }
}
