/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.cloud.RetryOption;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TableResult;
import com.google.cloud.bigquery.connector.common.BigQueryConnectorException;
import com.google.cloud.bigquery.connector.common.BigQueryErrorCode;
import com.google.cloud.bigquery.connector.common.BigQueryUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryClient {
    private static final Logger log = LoggerFactory.getLogger(BigQueryClient.class);
    private static Cache<String, TableInfo> destinationTableCache = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).maximumSize(1000L).build();
    private final BigQuery bigQuery;
    private final Optional<String> materializationProject;
    private final Optional<String> materializationDataset;

    BigQueryClient(BigQuery bigQuery, Optional<String> optional, Optional<String> optional2) {
        this.bigQuery = bigQuery;
        this.materializationProject = optional;
        this.materializationDataset = optional2;
    }

    private static Optional<String> createWhereClause(String[] stringArray) {
        if (stringArray.length == 0) {
            return Optional.empty();
        }
        return Optional.of(Stream.of(stringArray).collect(Collectors.joining(") AND (", "(", ")")));
    }

    public TableInfo getTable(TableId tableId) {
        return this.bigQuery.getTable(tableId, new BigQuery.TableOption[0]);
    }

    public TableInfo getReadTable(ReadTableOptions readTableOptions) {
        Optional<String> optional = readTableOptions.query();
        if (optional.isPresent()) {
            this.validateViewsEnabled(readTableOptions);
            String string = optional.get();
            return this.materializeQueryToTable(string, readTableOptions.expirationTimeInMinutes());
        }
        TableInfo tableInfo = this.getTable(readTableOptions.tableId());
        if (tableInfo == null) {
            return null;
        }
        TableDefinition tableDefinition = tableInfo.getDefinition();
        TableDefinition.Type type = tableDefinition.getType();
        if (TableDefinition.Type.TABLE == type) {
            return tableInfo;
        }
        if (TableDefinition.Type.VIEW == type || TableDefinition.Type.MATERIALIZED_VIEW == type) {
            this.validateViewsEnabled(readTableOptions);
            return tableInfo;
        }
        throw new BigQueryConnectorException(BigQueryErrorCode.UNSUPPORTED, String.format("Table type '%s' of table '%s.%s' is not supported", type, tableInfo.getTableId().getDataset(), tableInfo.getTableId().getTable()));
    }

    private void validateViewsEnabled(ReadTableOptions readTableOptions) {
        if (!readTableOptions.viewsEnabled()) {
            throw new BigQueryConnectorException(BigQueryErrorCode.UNSUPPORTED, String.format("Views are not enabled. You can enable views by setting '%s' to true. Notice additional cost may occur.", readTableOptions.viewEnabledParamName()));
        }
    }

    DatasetId toDatasetId(TableId tableId) {
        return DatasetId.of((String)tableId.getProject(), (String)tableId.getDataset());
    }

    public String getProjectId() {
        return ((BigQueryOptions)this.bigQuery.getOptions()).getProjectId();
    }

    Iterable<Dataset> listDatasets(String string) {
        return this.bigQuery.listDatasets(string, new BigQuery.DatasetListOption[0]).iterateAll();
    }

    Iterable<Table> listTables(DatasetId datasetId, TableDefinition.Type ... typeArray) {
        ImmutableSet immutableSet = ImmutableSet.copyOf((Object[])typeArray);
        Iterable iterable = this.bigQuery.listTables(datasetId, new BigQuery.TableListOption[0]).iterateAll();
        return (Iterable)StreamSupport.stream(iterable.spliterator(), false).filter(arg_0 -> BigQueryClient.lambda$listTables$0((Set)immutableSet, arg_0)).collect(ImmutableList.toImmutableList());
    }

    TableId createDestinationTable(Optional<String> optional, Optional<String> optional2) {
        String string = this.materializationProject.orElse(optional.orElse(null));
        String string2 = this.materializationDataset.orElse(optional2.orElse(null));
        String string3 = String.format("_bqc_%s", UUID.randomUUID().toString().toLowerCase(Locale.ENGLISH).replace("-", ""));
        return string == null ? TableId.of((String)string2, (String)string3) : TableId.of((String)string, (String)string2, (String)string3);
    }

    public Table update(TableInfo tableInfo) {
        return this.bigQuery.update(tableInfo, new BigQuery.TableOption[0]);
    }

    public Job createAndWaitFor(JobConfiguration.Builder builder) {
        return this.createAndWaitFor(builder.build());
    }

    public Job createAndWaitFor(JobConfiguration jobConfiguration) {
        JobInfo jobInfo = JobInfo.of((JobConfiguration)jobConfiguration);
        Job job = this.bigQuery.create(jobInfo, new BigQuery.JobOption[0]);
        log.info("Submitted job {}. jobId: {}", (Object)jobConfiguration, (Object)job.getJobId());
        try {
            return job.waitFor(new RetryOption[0]);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new BigQueryException(0, String.format("Failed to run the job [%s]", job), (Throwable)interruptedException);
        }
    }

    Job create(JobInfo jobInfo) {
        return this.bigQuery.create(jobInfo, new BigQuery.JobOption[0]);
    }

    TableResult query(String string) {
        try {
            return this.bigQuery.query(QueryJobConfiguration.of((String)string), new BigQuery.JobOption[0]);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new BigQueryException(0, String.format("Failed to run the query [%s]", string), (Throwable)interruptedException);
        }
    }

    String createSql(TableId tableId, ImmutableList<String> immutableList, String[] stringArray) {
        String string2 = immutableList.isEmpty() ? "*" : immutableList.stream().map(string -> String.format("`%s`", string)).collect(Collectors.joining(","));
        return this.createSql(tableId, string2, stringArray);
    }

    String createSql(TableId tableId, String string2, String[] stringArray) {
        String string3 = this.fullTableName(tableId);
        String string4 = BigQueryClient.createWhereClause(stringArray).map(string -> "WHERE " + string).orElse("");
        return String.format("SELECT %s FROM `%s` %s", string2, string3, string4);
    }

    String fullTableName(TableId tableId) {
        return String.format("%s.%s.%s", tableId.getProject(), tableId.getDataset(), tableId.getTable());
    }

    public long calculateTableSize(TableId tableId, Optional<String> optional) {
        return this.calculateTableSize(this.getTable(tableId), optional);
    }

    public long calculateTableSize(TableInfo tableInfo, Optional<String> optional) {
        try {
            TableDefinition.Type type = tableInfo.getDefinition().getType();
            if (type == TableDefinition.Type.TABLE && !optional.isPresent()) {
                return tableInfo.getNumRows().longValue();
            }
            if (type == TableDefinition.Type.VIEW || type == TableDefinition.Type.MATERIALIZED_VIEW || type == TableDefinition.Type.TABLE && optional.isPresent()) {
                String string = this.fullTableName(tableInfo.getTableId());
                String string2 = String.format("SELECT COUNT(*) from `%s` WHERE %s", string, optional.get());
                TableResult tableResult = this.bigQuery.query(QueryJobConfiguration.of((String)string2), new BigQuery.JobOption[0]);
                return ((FieldValueList)tableResult.iterateAll().iterator().next()).get(0).getLongValue();
            }
            throw new IllegalArgumentException(String.format("Unsupported table type %s for table %s", type, this.fullTableName(tableInfo.getTableId())));
        }
        catch (InterruptedException interruptedException) {
            throw new BigQueryConnectorException("Querying table size was interrupted on the client side", interruptedException);
        }
    }

    public TableInfo materializeQueryToTable(String string, int n) {
        TableId tableId = this.createDestinationTable(Optional.empty(), Optional.empty());
        return this.materializeTable(string, tableId, n);
    }

    public TableInfo materializeViewToTable(String string, TableId tableId, int n) {
        TableId tableId2 = this.createDestinationTable(Optional.ofNullable(tableId.getProject()), Optional.ofNullable(tableId.getDataset()));
        return this.materializeTable(string, tableId2, n);
    }

    private TableInfo materializeTable(String string, TableId tableId, int n) {
        try {
            return (TableInfo)destinationTableCache.get((Object)string, (Callable)new DestinationTableBuilder(this, string, tableId, n));
        }
        catch (Exception exception) {
            throw new BigQueryConnectorException(BigQueryErrorCode.BIGQUERY_VIEW_DESTINATION_TABLE_CREATION_FAILED, String.format("Error creating destination table using the following query: [%s]", string), exception);
        }
    }

    @VisibleForTesting
    public static void clearDestinationTableCache() {
        destinationTableCache.cleanUp();
    }

    private static /* synthetic */ boolean lambda$listTables$0(Set set, Table table) {
        return set.contains(table.getDefinition().getType());
    }

    static class DestinationTableBuilder
    implements Callable<TableInfo> {
        final BigQueryClient bigQueryClient;
        final String querySql;
        final TableId destinationTable;
        final int expirationTimeInMinutes;

        DestinationTableBuilder(BigQueryClient bigQueryClient, String string, TableId tableId, int n) {
            this.bigQueryClient = bigQueryClient;
            this.querySql = string;
            this.destinationTable = tableId;
            this.expirationTimeInMinutes = n;
        }

        @Override
        public TableInfo call() {
            return this.createTableFromQuery();
        }

        TableInfo createTableFromQuery() {
            log.debug("destinationTable is %s", (Object)this.destinationTable);
            JobInfo jobInfo = JobInfo.of((JobConfiguration)QueryJobConfiguration.newBuilder((String)this.querySql).setDestinationTable(this.destinationTable).build());
            log.debug("running query %s", (Object)jobInfo);
            Job job = this.waitForJob(this.bigQueryClient.create(jobInfo));
            log.debug("job has finished. %s", (Object)job);
            if (job.getStatus().getError() != null) {
                throw BigQueryUtil.convertToBigQueryException(job.getStatus().getError());
            }
            TableInfo tableInfo = this.bigQueryClient.getTable(this.destinationTable);
            long l = tableInfo.getCreationTime() + TimeUnit.MINUTES.toMillis(this.expirationTimeInMinutes);
            Table table = this.bigQueryClient.update(tableInfo.toBuilder().setExpirationTime(Long.valueOf(l)).build());
            return table;
        }

        Job waitForJob(Job job) {
            try {
                return job.waitFor(new RetryOption[0]);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new BigQueryException(0, String.format("Job %s has been interrupted", job.getJobId()), (Throwable)interruptedException);
            }
        }
    }

    public static interface ReadTableOptions {
        public TableId tableId();

        public Optional<String> query();

        public boolean viewsEnabled();

        public String viewEnabledParamName();

        public int expirationTimeInMinutes();
    }
}

