/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.api.gax.rpc.HeaderProvider;
import com.google.cloud.TransportOptions;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.connector.common.BigQueryClient;
import com.google.cloud.bigquery.connector.common.BigQueryConfig;
import com.google.cloud.bigquery.connector.common.BigQueryCredentialsSupplier;
import com.google.cloud.bigquery.connector.common.BigQueryProxyConfig;
import com.google.cloud.bigquery.connector.common.BigQueryProxyTransporterBuilder;
import com.google.cloud.bigquery.connector.common.BigQueryReadClientFactory;
import com.google.cloud.bigquery.connector.common.BigQueryTracerFactory;
import com.google.cloud.bigquery.connector.common.LoggingBigQueryTracerFactory;
import com.google.cloud.bigquery.connector.common.UserAgentHeaderProvider;
import com.google.cloud.bigquery.connector.common.UserAgentProvider;
import com.google.cloud.http.HttpTransportOptions;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;

public class BigQueryClientModule
implements Module {
    @Provides
    @Singleton
    public static UserAgentHeaderProvider createUserAgentHeaderProvider(UserAgentProvider userAgentProvider) {
        return new UserAgentHeaderProvider(userAgentProvider.getUserAgent());
    }

    public void configure(Binder binder) {
        binder.bind(BigQueryReadClientFactory.class).in(Scopes.SINGLETON);
        binder.bind(BigQueryTracerFactory.class).toInstance((Object)new LoggingBigQueryTracerFactory(14));
    }

    @Provides
    @Singleton
    public BigQueryCredentialsSupplier provideBigQueryCredentialsSupplier(BigQueryConfig bigQueryConfig) {
        BigQueryProxyConfig bigQueryProxyConfig = bigQueryConfig.getBigQueryProxyConfig();
        return new BigQueryCredentialsSupplier(bigQueryConfig.getAccessToken(), bigQueryConfig.getCredentialsKey(), bigQueryConfig.getCredentialsFile(), bigQueryProxyConfig.getProxyUri(), bigQueryProxyConfig.getProxyUsername(), bigQueryProxyConfig.getProxyPassword());
    }

    @Provides
    @Singleton
    public BigQueryClient provideBigQueryClient(BigQueryConfig bigQueryConfig, UserAgentHeaderProvider userAgentHeaderProvider, BigQueryCredentialsSupplier bigQueryCredentialsSupplier) {
        BigQueryOptions.Builder builder = (BigQueryOptions.Builder)((BigQueryOptions.Builder)((BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setHeaderProvider((HeaderProvider)userAgentHeaderProvider)).setProjectId(bigQueryConfig.getParentProjectId())).setCredentials(bigQueryCredentialsSupplier.getCredentials())).setRetrySettings(bigQueryConfig.getBigQueryClientRetrySettings());
        HttpTransportOptions.Builder builder2 = HttpTransportOptions.newBuilder().setConnectTimeout(bigQueryConfig.getBigQueryClientConnectTimeout()).setReadTimeout(bigQueryConfig.getBigQueryClientReadTimeout());
        BigQueryProxyConfig bigQueryProxyConfig = bigQueryConfig.getBigQueryProxyConfig();
        if (bigQueryProxyConfig.getProxyUri().isPresent()) {
            builder2.setHttpTransportFactory(BigQueryProxyTransporterBuilder.createHttpTransportFactory(bigQueryProxyConfig.getProxyUri(), bigQueryProxyConfig.getProxyUsername(), bigQueryProxyConfig.getProxyPassword()));
        }
        builder.setTransportOptions((TransportOptions)builder2.build());
        return new BigQueryClient((BigQuery)builder.build().getService(), bigQueryConfig.getMaterializationProject(), bigQueryConfig.getMaterializationDataset());
    }
}

