/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.api.client.util.Base64;
import com.google.auth.Credentials;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.bigquery.connector.common.BigQueryProxyTransporterBuilder;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Optional;

public class BigQueryCredentialsSupplier {
    private final Credentials credentials;

    public BigQueryCredentialsSupplier(Optional<String> optional, Optional<String> optional2, Optional<String> optional3, Optional<URI> optional4, Optional<String> optional5, Optional<String> optional6) {
        this.credentials = optional.isPresent() ? BigQueryCredentialsSupplier.createCredentialsFromAccessToken(optional.get()) : (optional2.isPresent() ? BigQueryCredentialsSupplier.createCredentialsFromKey(optional2.get(), optional4, optional5, optional6) : (optional3.isPresent() ? BigQueryCredentialsSupplier.createCredentialsFromFile(optional3.get(), optional4, optional5, optional6) : BigQueryCredentialsSupplier.createDefaultCredentials()));
    }

    private static Credentials createCredentialsFromAccessToken(String string) {
        return GoogleCredentials.create((AccessToken)new AccessToken(string, null));
    }

    private static Credentials createCredentialsFromKey(String string, Optional<URI> optional, Optional<String> optional2, Optional<String> optional3) {
        try {
            if (optional.isPresent()) {
                HttpTransportFactory httpTransportFactory = BigQueryProxyTransporterBuilder.createHttpTransportFactory(optional, optional2, optional3);
                return GoogleCredentials.fromStream((InputStream)new ByteArrayInputStream(Base64.decodeBase64((String)string)), (HttpTransportFactory)httpTransportFactory);
            }
            return GoogleCredentials.fromStream((InputStream)new ByteArrayInputStream(Base64.decodeBase64((String)string)));
        }
        catch (IOException iOException) {
            throw new UncheckedIOException("Failed to create Credentials from key", iOException);
        }
    }

    private static Credentials createCredentialsFromFile(String string, Optional<URI> optional, Optional<String> optional2, Optional<String> optional3) {
        try {
            if (optional.isPresent()) {
                HttpTransportFactory httpTransportFactory = BigQueryProxyTransporterBuilder.createHttpTransportFactory(optional, optional2, optional3);
                return GoogleCredentials.fromStream((InputStream)new FileInputStream(string), (HttpTransportFactory)httpTransportFactory);
            }
            return GoogleCredentials.fromStream((InputStream)new FileInputStream(string));
        }
        catch (IOException iOException) {
            throw new UncheckedIOException("Failed to create Credentials from file", iOException);
        }
    }

    public static Credentials createDefaultCredentials() {
        try {
            return GoogleCredentials.getApplicationDefault();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException("Failed to create default Credentials", iOException);
        }
    }

    public Credentials getCredentials() {
        return this.credentials;
    }
}

