/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.v2.ApacheHttpTransport;
import com.google.api.core.ApiFunction;
import com.google.auth.http.HttpTransportFactory;
import io.grpc.HttpConnectProxiedSocketAddress;
import io.grpc.ManagedChannelBuilder;
import io.grpc.ProxiedSocketAddress;
import io.grpc.ProxyDetector;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Optional;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;

public class BigQueryProxyTransporterBuilder {
    public static ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> createGrpcChannelConfigurator(Optional<URI> optional, final Optional<String> optional2, final Optional<String> optional3) {
        if (!optional.isPresent()) {
            return null;
        }
        BigQueryProxyTransporterBuilder.checkProxyParamsValidity(optional2, optional3);
        URI uRI = optional.get();
        String string = uRI.getHost();
        int n = uRI.getPort();
        final InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
        return new ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder>(){

            public ManagedChannelBuilder apply(ManagedChannelBuilder managedChannelBuilder) {
                return managedChannelBuilder.proxyDetector(new ProxyDetector(){

                    public ProxiedSocketAddress proxyFor(SocketAddress socketAddress) {
                        HttpConnectProxiedSocketAddress.Builder builder = HttpConnectProxiedSocketAddress.newBuilder().setTargetAddress((InetSocketAddress)socketAddress).setProxyAddress((SocketAddress)inetSocketAddress);
                        if (optional2.isPresent() && optional3.isPresent()) {
                            builder.setUsername((String)optional2.get());
                            builder.setPassword((String)optional3.get());
                        }
                        return builder.build();
                    }
                });
            }
        };
    }

    public static HttpTransportFactory createHttpTransportFactory(Optional<URI> optional, Optional<String> optional2, Optional<String> optional3) {
        if (!optional.isPresent()) {
            return null;
        }
        BigQueryProxyTransporterBuilder.checkProxyParamsValidity(optional2, optional3);
        URI uRI = optional.get();
        String string = uRI.getHost();
        int n = uRI.getPort();
        HttpHost httpHost = new HttpHost(string, n);
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setProxy(httpHost);
        if (optional2.isPresent() && optional3.isPresent()) {
            UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(optional2.get(), optional3.get());
            BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
            basicCredentialsProvider.setCredentials(new AuthScope(uRI.getHost(), uRI.getPort()), (Credentials)usernamePasswordCredentials);
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
        }
        return new BigQueryHttpTransportFactory(httpClientBuilder);
    }

    public static void checkProxyParamsValidity(Optional<String> optional, Optional<String> optional2) throws IllegalArgumentException {
        if (optional.isPresent() != optional2.isPresent()) {
            throw new IllegalArgumentException("Both proxyUsername and proxyPassword should be defined or not defined together");
        }
    }

    public static class BigQueryHttpTransportFactory
    implements HttpTransportFactory {
        private HttpClientBuilder httpClientBuilder;

        public BigQueryHttpTransportFactory() {
        }

        public BigQueryHttpTransportFactory(HttpClientBuilder httpClientBuilder) {
            this.httpClientBuilder = httpClientBuilder;
        }

        public HttpTransport create() {
            return new ApacheHttpTransport((HttpClient)this.httpClientBuilder.build());
        }
    }
}

