/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.bigquery.connector.common.BigQueryConfig;
import com.google.cloud.bigquery.connector.common.BigQueryCredentialsSupplier;
import com.google.cloud.bigquery.connector.common.BigQueryProxyConfig;
import com.google.cloud.bigquery.connector.common.BigQueryProxyTransporterBuilder;
import com.google.cloud.bigquery.connector.common.UserAgentHeaderProvider;
import com.google.cloud.bigquery.storage.v1.BigQueryReadClient;
import com.google.cloud.bigquery.storage.v1.BigQueryReadSettings;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Optional;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryReadClientFactory
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(BigQueryReadClientFactory.class);
    private final Credentials credentials;
    private final UserAgentHeaderProvider userAgentHeaderProvider;
    private final BigQueryConfig bqConfig;

    @Inject
    public BigQueryReadClientFactory(BigQueryCredentialsSupplier bigQueryCredentialsSupplier, UserAgentHeaderProvider userAgentHeaderProvider, BigQueryConfig bigQueryConfig) {
        this.credentials = bigQueryCredentialsSupplier.getCredentials();
        this.userAgentHeaderProvider = userAgentHeaderProvider;
        this.bqConfig = bigQueryConfig;
    }

    public BigQueryReadClient createBigQueryReadClient(Optional<String> optional) {
        try {
            InstantiatingGrpcChannelProvider.Builder builder = BigQueryReadSettings.defaultGrpcTransportProviderBuilder().setHeaderProvider((HeaderProvider)this.userAgentHeaderProvider);
            BigQueryProxyConfig bigQueryProxyConfig = this.bqConfig.getBigQueryProxyConfig();
            if (bigQueryProxyConfig.getProxyUri().isPresent()) {
                builder.setChannelConfigurator(BigQueryProxyTransporterBuilder.createGrpcChannelConfigurator(bigQueryProxyConfig.getProxyUri(), bigQueryProxyConfig.getProxyUsername(), bigQueryProxyConfig.getProxyPassword()));
            }
            optional.ifPresent(string -> {
                log.info("Overriding endpoint to: ", string);
                builder.setEndpoint(string);
            });
            BigQueryReadSettings.Builder builder2 = (BigQueryReadSettings.Builder)((BigQueryReadSettings.Builder)BigQueryReadSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)builder.build())).setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)this.credentials));
            return BigQueryReadClient.create((BigQueryReadSettings)builder2.build());
        }
        catch (IOException iOException) {
            throw new UncheckedIOException("Error creating BigQueryStorageClient", iOException);
        }
    }
}

