/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.cloud.bigquery.BigQueryError;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.TableId;
import com.google.common.base.Throwables;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BigQueryUtil {
    static final ImmutableSet<String> INTERNAL_ERROR_MESSAGES = ImmutableSet.of((Object)"HTTP/2 error code: INTERNAL_ERROR", (Object)"Connection closed with unknown cause", (Object)"Received unexpected EOS on DATA frame from server");
    private static final String PROJECT_PATTERN = "\\S+";
    private static final String DATASET_PATTERN = "\\w+";
    private static final String TABLE_PATTERN = "[\\S&&[^.:]]+";
    private static final Pattern QUALIFIED_TABLE_REGEX = Pattern.compile(String.format("^(((%s)[:.])?(%s)\\.)?(%s)$$", "\\S+", "\\w+", "[\\S&&[^.:]]+"));

    private BigQueryUtil() {
    }

    public static boolean isRetryable(Throwable throwable) {
        return Throwables.getCausalChain((Throwable)throwable).stream().anyMatch(BigQueryUtil::isRetryableInternalError);
    }

    static boolean isRetryableInternalError(Throwable throwable) {
        if (throwable instanceof StatusRuntimeException) {
            StatusRuntimeException statusRuntimeException = (StatusRuntimeException)throwable;
            return statusRuntimeException.getStatus().getCode() == Status.Code.INTERNAL && INTERNAL_ERROR_MESSAGES.stream().anyMatch(string -> statusRuntimeException.getMessage().contains((CharSequence)string));
        }
        return false;
    }

    static BigQueryException convertToBigQueryException(BigQueryError bigQueryError) {
        return new BigQueryException(0, bigQueryError.getMessage(), bigQueryError);
    }

    public static <T> Optional<T> firstPresent(Optional<T> ... optionalArray) {
        for (Optional<T> optional : optionalArray) {
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    public static TableId parseTableId(String string) {
        return BigQueryUtil.parseTableId(string, Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static TableId parseTableId(String string, Optional<String> optional, Optional<String> optional2) {
        return BigQueryUtil.parseTableId(string, optional, optional2, Optional.empty());
    }

    public static TableId parseTableId(String string, Optional<String> optional, Optional<String> optional2, Optional<String> optional3) {
        Matcher matcher = QUALIFIED_TABLE_REGEX.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Invalid Table ID '%s'. Must match '%s'", string, QUALIFIED_TABLE_REGEX));
        }
        String string4 = matcher.group(5);
        Optional<String> optional4 = Optional.ofNullable(matcher.group(4));
        Optional<String> optional5 = Optional.ofNullable(matcher.group(3));
        String string5 = optional3.map(string2 -> String.format("%s$%s", string4, string2)).orElse(string4);
        String string6 = (String)BigQueryUtil.firstPresent(optional4, optional).orElseThrow(() -> new IllegalArgumentException("'dataset' not parsed or provided."));
        return BigQueryUtil.firstPresent(optional5, optional2).map(string3 -> TableId.of((String)string3, (String)string6, (String)string5)).orElse(TableId.of((String)string6, (String)string5));
    }

    public static String friendlyTableName(TableId tableId) {
        return tableId.getProject() != null ? String.format("%s.%s.%s", tableId.getProject(), tableId.getDataset(), tableId.getTable()) : String.format("%s.%s", tableId.getDataset(), tableId.getTable());
    }

    public static void convertAndThrow(BigQueryError bigQueryError) {
        throw new BigQueryException(0, bigQueryError.getMessage(), bigQueryError);
    }

    public static List<String> optimizeLoadUriList(List<String> list, String string, String string2) {
        Pattern pattern = Pattern.compile("(" + string + "\\d*)\\d\\**(" + string2 + ")");
        ImmutableList.Builder builder = ImmutableList.builder();
        List<String> list2 = list;
        while (!list2.isEmpty()) {
            Multimap<String, String> multimap = BigQueryUtil.trimUris(pattern, list2);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string3 : multimap.keySet()) {
                Collection collection = multimap.get((Object)string3);
                if (collection.size() == 10) {
                    arrayList.add(string3);
                    continue;
                }
                builder.addAll((Iterable)collection);
            }
            multimap.clear();
            list2 = arrayList;
        }
        return builder.build();
    }

    private static Multimap<String, String> trimUris(Pattern pattern, List<String> list) {
        HashMultimap hashMultimap = HashMultimap.create();
        for (String string : list) {
            String string2 = pattern.matcher(string).replaceFirst("$1*$2");
            hashMultimap.put((Object)string2, (Object)string);
        }
        return hashMultimap;
    }
}

