/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import java.io.Serializable;
import java.time.Duration;

final class DurationTimer
implements Serializable {
    private long start = Long.MIN_VALUE;
    private long accumulatedNanos = 0L;
    private long samples = 0L;

    DurationTimer() {
    }

    public void start() {
        this.start = System.nanoTime();
    }

    public void finish() {
        long l = System.nanoTime();
        if (this.start != Long.MIN_VALUE) {
            this.accumulatedNanos += l - this.start;
            ++this.samples;
        }
        this.start = l;
    }

    public Duration getAccumulatedTime() {
        return Duration.ofNanos(this.accumulatedNanos);
    }

    public long getSamples() {
        return this.samples;
    }
}

