/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IteratorMultiplexer<T>
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(IteratorMultiplexer.class);
    private static final Object TERMINAL_SENTINEL = new Object();
    private final Iterator<T> iterator;
    private final int splits;
    private final QueueIterator<T>[] iterators;
    private Thread worker;

    public IteratorMultiplexer(Iterator<T> iterator, int n) {
        this.iterator = iterator;
        this.splits = n;
        this.iterators = new QueueIterator[n];
        for (int i = 0; i < n; ++i) {
            this.iterators[i] = new QueueIterator();
        }
    }

    @Override
    public void close() {
        if (this.worker != null) {
            this.worker.interrupt();
            try {
                this.worker.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("Interrupted while waiting on worker thread shutdown.", interruptedException);
            }
            this.worker = null;
        }
        for (int i = 0; i < this.splits; ++i) {
            this.iterators[i].markDone(null);
        }
    }

    void readAhead() {
        int n;
        Throwable throwable = null;
        try {
            n = 1;
            block3: while (n != 0) {
                for (int i = 0; i < this.splits; ++i) {
                    if (!this.iterator.hasNext()) {
                        n = 0;
                        continue block3;
                    }
                    T t = this.iterator.next();
                    ((QueueIterator)this.iterators[i]).sem.acquire();
                    ((QueueIterator)this.iterators[i]).queue.put(t);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            log.info("Worker was interrupted. Ending all iterators");
            throwable = new RuntimeException(interruptedException);
        }
        catch (Throwable throwable2) {
            log.info("Worker had exception. Ending all iterators", throwable);
            throwable = throwable2;
        }
        for (n = 0; n < this.splits; ++n) {
            this.iterators[n].markDone(throwable);
        }
    }

    public synchronized Iterator<T> getSplit(int n) {
        if (this.worker == null) {
            this.worker = new Thread(this::readAhead, "readahead-worker");
            this.worker.setDaemon(true);
            this.worker.start();
        }
        return this.iterators[n];
    }

    private class QueueIterator<T>
    implements Iterator<T> {
        private final ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue(2);
        private final Semaphore sem = new Semaphore(1);
        private Object t = null;

        private QueueIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.t == TERMINAL_SENTINEL) {
                return false;
            }
            try {
                this.t = this.queue.take();
                this.sem.release();
            }
            catch (InterruptedException interruptedException) {
                IteratorMultiplexer.this.worker.interrupt();
                this.t = TERMINAL_SENTINEL;
            }
            return this.t != TERMINAL_SENTINEL;
        }

        @Override
        public T next() {
            Preconditions.checkState((this.t != TERMINAL_SENTINEL ? 1 : 0) != 0, (Object)"No next message");
            if (this.t instanceof Throwable) {
                if (this.t instanceof RuntimeException) {
                    throw (RuntimeException)this.t;
                }
                throw new RuntimeException((Throwable)this.t);
            }
            Object object = this.t;
            this.t = null;
            return (T)object;
        }

        public synchronized void markDone(Throwable throwable) {
            if (this.t == TERMINAL_SENTINEL || this.t instanceof Exception) {
                return;
            }
            if (this.queue.remainingCapacity() > 0) {
                if (throwable != null) {
                    Preconditions.checkState((boolean)this.queue.offer(throwable), (Object)"Expected room for exception");
                } else {
                    Preconditions.checkState((boolean)this.queue.offer(TERMINAL_SENTINEL), (Object)"Expected room for sentinel");
                }
            }
        }
    }
}

