/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.cloud.bigquery.connector.common.BigQueryStorageReadRowsTracer;
import com.google.cloud.bigquery.connector.common.DurationTimer;
import java.time.Duration;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingBigQueryStorageReadRowsTracer
implements BigQueryStorageReadRowsTracer {
    private static final Logger log = LoggerFactory.getLogger(LoggingBigQueryStorageReadRowsTracer.class);
    private final String streamName;
    private final int logIntervalPowerOf2;
    Instant startTime;
    final DurationTimer parseTime = new DurationTimer();
    final DurationTimer sparkTime = new DurationTimer();
    final DurationTimer serviceTime = new DurationTimer();
    Instant endTime;
    long rows = 0L;
    long bytes = 0L;
    long linesLogged = 0L;

    LoggingBigQueryStorageReadRowsTracer(String string, int n) {
        this.streamName = string;
        this.logIntervalPowerOf2 = n;
    }

    @Override
    public void startStream() {
        this.startTime = Instant.now();
    }

    @Override
    public void rowsParseStarted() {
        this.parseTime.start();
    }

    @Override
    public void rowsParseFinished(long l) {
        this.rows += l;
        this.parseTime.finish();
    }

    @Override
    public void readRowsResponseRequested() {
        this.serviceTime.start();
    }

    @Override
    public void readRowsResponseObtained(long l) {
        this.bytes += l;
        this.serviceTime.finish();
    }

    @Override
    public void finished() {
        this.endTime = Instant.now();
        this.logData();
    }

    private static Duration average(DurationTimer durationTimer) {
        long l = durationTimer.getSamples();
        if (l == 0L) {
            return null;
        }
        return durationTimer.getAccumulatedTime().dividedBy(l);
    }

    private static String format(DurationTimer durationTimer) {
        long l = durationTimer.getSamples();
        if (l == 0L) {
            return "Not enough samples.";
        }
        Duration duration = LoggingBigQueryStorageReadRowsTracer.average(durationTimer);
        return String.format("Average: %s Samples: %d", duration.toString(), l);
    }

    private static String difference(DurationTimer durationTimer, DurationTimer durationTimer2) {
        if (durationTimer.getSamples() == 0L || durationTimer2.getSamples() == 0L) {
            return "Not enough samples.";
        }
        return String.format("Average: %s", LoggingBigQueryStorageReadRowsTracer.average(durationTimer).minus(LoggingBigQueryStorageReadRowsTracer.average(durationTimer2)).toString());
    }

    private static long perSecond(DurationTimer durationTimer, long l) {
        if (durationTimer.getSamples() == 0L) {
            return 0L;
        }
        Duration duration = durationTimer.getAccumulatedTime();
        double d = (double)duration.toMillis() / 1000.0;
        if (d != 0.0) {
            return (long)((double)l / d);
        }
        return 0L;
    }

    private void logData() {
        log.info("{}: Started: {} Ended: {} Parse Timings: {}  Time in Spark: {} Time waiting for service: {} Bytes/s: {} Rows/s: {}", new Object[]{this.streamName, this.startTime, this.endTime == null ? "" : this.endTime.toString(), LoggingBigQueryStorageReadRowsTracer.format(this.parseTime), LoggingBigQueryStorageReadRowsTracer.difference(this.sparkTime, this.parseTime), LoggingBigQueryStorageReadRowsTracer.format(this.serviceTime), LoggingBigQueryStorageReadRowsTracer.perSecond(this.serviceTime, this.bytes), LoggingBigQueryStorageReadRowsTracer.perSecond(this.parseTime, this.rows)});
        ++this.linesLogged;
    }

    @Override
    public void nextBatchNeeded() {
        this.sparkTime.finish();
        if ((this.sparkTime.getSamples() + 1L & (long)((1 << this.logIntervalPowerOf2) - 1)) == 0L) {
            this.logData();
        }
    }

    @Override
    public BigQueryStorageReadRowsTracer forkWithPrefix(String string) {
        return new LoggingBigQueryStorageReadRowsTracer("id-" + string + "-" + this.streamName, this.logIntervalPowerOf2);
    }

    String getStreamName() {
        return this.streamName;
    }
}

