/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class NonInterruptibleBlockingBytesChannel
implements ReadableByteChannel {
    private static final int TRANSFER_SIZE = 4096;
    private final InputStream is;
    private boolean closed = false;
    private byte[] transferBuffer = new byte[4096];

    public NonInterruptibleBlockingBytesChannel(InputStream inputStream) {
        this.is = inputStream;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n;
        int n2;
        int n3 = byteBuffer.remaining();
        int n4 = 0;
        for (n2 = 0; n2 < n3 && (n4 = this.is.read(this.transferBuffer, 0, n = Math.min(n3 - n2, 4096))) >= 0; n2 += n4) {
            byteBuffer.put(this.transferBuffer, 0, n4);
        }
        if (n4 < 0 && n2 == 0) {
            return -1;
        }
        return n2;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.is.close();
    }
}

