/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.cloud.bigquery.connector.common.BigQueryReadClientFactory;
import com.google.cloud.bigquery.connector.common.StreamCombiningIterator;
import com.google.cloud.bigquery.storage.v1.BigQueryReadClient;
import com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadRowsHelper
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ReadRowsHelper.class);
    private final Options options;
    private final BigQueryReadClientFactory bigQueryReadClientFactory;
    private final List<ReadRowsRequest.Builder> requests;
    private BigQueryReadClient client;
    private StreamCombiningIterator incomingStream;

    public ReadRowsHelper(BigQueryReadClientFactory bigQueryReadClientFactory, ReadRowsRequest.Builder builder, Options options) {
        this.bigQueryReadClientFactory = Objects.requireNonNull(bigQueryReadClientFactory, "bigQueryReadClientFactory cannot be null");
        this.requests = ImmutableList.of((Object)Objects.requireNonNull(builder, "request cannot be null"));
        this.options = options;
    }

    public ReadRowsHelper(BigQueryReadClientFactory bigQueryReadClientFactory, List<ReadRowsRequest.Builder> list, Options options) {
        this.bigQueryReadClientFactory = Objects.requireNonNull(bigQueryReadClientFactory, "bigQueryReadClientFactory cannot be null");
        this.requests = Objects.requireNonNull(list, "request cannot be null");
        this.options = options;
    }

    public Iterator<ReadRowsResponse> readRows() {
        if (this.client != null) {
            this.client.close();
        }
        this.client = this.bigQueryReadClientFactory.createBigQueryReadClient(this.options.getEndpoint());
        this.incomingStream = new StreamCombiningIterator(this.client, this.requests, this.options.prebufferResponses, this.options.getMaxReadRowsRetries());
        return this.incomingStream;
    }

    public String toString() {
        return this.requests.toString();
    }

    @Override
    public void close() {
        if (this.incomingStream != null) {
            try {
                this.incomingStream.cancel();
            }
            catch (Exception exception) {
                logger.debug("Error on cancel call", (Throwable)exception);
            }
            this.incomingStream = null;
        }
        if (!this.client.isShutdown()) {
            this.client.close();
        }
    }

    public static final class Options
    implements Serializable {
        private final int maxReadRowsRetries;
        private final String nullableEndpoint;
        private final int backgroundParsingThreads;
        private final int prebufferResponses;

        public Options(int n, Optional<String> optional, int n2, int n3) {
            this.maxReadRowsRetries = n;
            this.nullableEndpoint = optional.orElse(null);
            this.backgroundParsingThreads = n2;
            this.prebufferResponses = n3;
        }

        public int getMaxReadRowsRetries() {
            return this.maxReadRowsRetries;
        }

        public Optional<String> getEndpoint() {
            return Optional.ofNullable(this.nullableEndpoint);
        }

        public int numBackgroundThreads() {
            return this.backgroundParsingThreads;
        }

        public int numPrebufferResponses() {
            return this.prebufferResponses;
        }
    }
}

