/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.cloud.bigquery.connector.common.BigQueryStorageReadRowsTracer;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ReadRowsResponseInputStreamEnumeration
implements Enumeration<InputStream> {
    private final Iterator<ReadRowsResponse> responses;
    private ReadRowsResponse currentResponse;
    private final BigQueryStorageReadRowsTracer tracer;

    public ReadRowsResponseInputStreamEnumeration(Iterator<ReadRowsResponse> iterator, BigQueryStorageReadRowsTracer bigQueryStorageReadRowsTracer) {
        this.responses = iterator;
        this.tracer = bigQueryStorageReadRowsTracer;
        this.loadNextResponse();
    }

    @Override
    public boolean hasMoreElements() {
        return this.currentResponse != null;
    }

    @Override
    public InputStream nextElement() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException("No more responses");
        }
        ReadRowsResponse readRowsResponse = this.currentResponse;
        this.loadNextResponse();
        return readRowsResponse.getArrowRecordBatch().getSerializedRecordBatch().newInput();
    }

    void loadNextResponse() {
        this.tracer.readRowsResponseRequested();
        this.currentResponse = this.responses.hasNext() ? this.responses.next() : null;
        this.tracer.readRowsResponseObtained(this.currentResponse == null ? 0L : (long)this.currentResponse.getArrowRecordBatch().getSerializedRecordBatch().size());
    }
}

