/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.connector.common.BigQueryClient;
import com.google.cloud.bigquery.connector.common.BigQueryConnectorException;
import com.google.cloud.bigquery.connector.common.BigQueryErrorCode;
import com.google.cloud.bigquery.connector.common.BigQueryReadClientFactory;
import com.google.cloud.bigquery.connector.common.ReadSessionCreatorConfig;
import com.google.cloud.bigquery.connector.common.ReadSessionResponse;
import com.google.cloud.bigquery.storage.v1.BigQueryReadClient;
import com.google.cloud.bigquery.storage.v1.CreateReadSessionRequest;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Base64;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadSessionCreator {
    private static final int DEFAULT_BYTES_PER_PARTITION = 400000000;
    private static final Logger log = LoggerFactory.getLogger(ReadSessionCreator.class);
    private final ReadSessionCreatorConfig config;
    private final BigQueryClient bigQueryClient;
    private final BigQueryReadClientFactory bigQueryReadClientFactory;

    public ReadSessionCreator(ReadSessionCreatorConfig readSessionCreatorConfig, BigQueryClient bigQueryClient, BigQueryReadClientFactory bigQueryReadClientFactory) {
        this.config = readSessionCreatorConfig;
        this.bigQueryClient = bigQueryClient;
        this.bigQueryReadClientFactory = bigQueryReadClientFactory;
    }

    static int getMaxNumPartitionsRequested(OptionalInt optionalInt, StandardTableDefinition standardTableDefinition) {
        return optionalInt.orElse(Math.max((int)(standardTableDefinition.getNumBytes() / 400000000L), 1));
    }

    public ReadSessionResponse create(TableId tableId, ImmutableList<String> immutableList, Optional<String> optional) {
        TableInfo tableInfo = this.bigQueryClient.getTable(tableId);
        TableInfo tableInfo2 = this.getActualTable(tableInfo, immutableList, optional);
        StandardTableDefinition standardTableDefinition = (StandardTableDefinition)tableInfo2.getDefinition();
        try (BigQueryReadClient bigQueryReadClient = this.bigQueryReadClientFactory.createBigQueryReadClient(this.config.endpoint());){
            String string2 = this.toTablePath(tableInfo2.getTableId());
            CreateReadSessionRequest createReadSessionRequest = this.config.getRequestEncodedBase().map(string -> {
                try {
                    return CreateReadSessionRequest.parseFrom((byte[])Base64.getDecoder().decode((String)string));
                }
                catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                    throw new RuntimeException("Couldn't decode:" + string, invalidProtocolBufferException);
                }
            }).orElse(CreateReadSessionRequest.newBuilder().build());
            ReadSession.Builder builder = createReadSessionRequest.getReadSession().toBuilder();
            ReadSession.TableReadOptions.Builder builder2 = builder.getReadOptionsBuilder();
            if (!this.isInputTableAView(tableInfo)) {
                optional.ifPresent(arg_0 -> ((ReadSession.TableReadOptions.Builder)builder2).setRowRestriction(arg_0));
            }
            builder2.addAllSelectedFields(immutableList);
            ReadSession readSession = bigQueryReadClient.createReadSession(createReadSessionRequest.newBuilder().setParent("projects/" + this.bigQueryClient.getProjectId()).setReadSession(builder.setDataFormat(this.config.getReadDataFormat()).setReadOptions(builder2).setTable(string2).build()).setMaxStreamCount(ReadSessionCreator.getMaxNumPartitionsRequested(this.config.getMaxParallelism(), standardTableDefinition)).build());
            ReadSessionResponse readSessionResponse = new ReadSessionResponse(readSession, tableInfo2);
            return readSessionResponse;
        }
    }

    String toTablePath(TableId tableId) {
        return String.format("projects/%s/datasets/%s/tables/%s", tableId.getProject(), tableId.getDataset(), tableId.getTable());
    }

    TableInfo getActualTable(TableInfo tableInfo, ImmutableList<String> immutableList, Optional<String> optional) {
        String[] stringArray = (String[])optional.map(Stream::of).orElseGet(Stream::empty).toArray(String[]::new);
        return this.getActualTable(tableInfo, immutableList, stringArray);
    }

    TableInfo getActualTable(TableInfo tableInfo, ImmutableList<String> immutableList, String[] stringArray) {
        TableDefinition tableDefinition = tableInfo.getDefinition();
        TableDefinition.Type type = tableDefinition.getType();
        if (TableDefinition.Type.TABLE == type) {
            return tableInfo;
        }
        if (this.isInputTableAView(tableInfo)) {
            String string = this.bigQueryClient.createSql(tableInfo.getTableId(), immutableList, stringArray);
            log.debug("querySql is %s", (Object)string);
            return this.bigQueryClient.materializeViewToTable(string, tableInfo.getTableId(), this.config.getMaterializationExpirationTimeInMinutes());
        }
        throw new BigQueryConnectorException(BigQueryErrorCode.UNSUPPORTED, String.format("Table type '%s' of table '%s.%s' is not supported", type, tableInfo.getTableId().getDataset(), tableInfo.getTableId().getTable()));
    }

    private boolean isInputTableAView(TableInfo tableInfo) {
        TableDefinition tableDefinition = tableInfo.getDefinition();
        TableDefinition.Type type = tableDefinition.getType();
        if (TableDefinition.Type.VIEW == type || TableDefinition.Type.MATERIALIZED_VIEW == type) {
            if (!this.config.isViewsEnabled()) {
                throw new BigQueryConnectorException(BigQueryErrorCode.UNSUPPORTED, String.format("Views are not enabled. You can enable views by setting '%s' to true. Notice additional cost may occur.", this.config.getViewEnabledParamName()));
            }
            return true;
        }
        return false;
    }
}

