/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.cloud.bigquery.connector.common.ReadRowsHelper;
import com.google.cloud.bigquery.storage.v1.DataFormat;
import java.util.Optional;
import java.util.OptionalInt;

public class ReadSessionCreatorConfig {
    private final boolean viewsEnabled;
    private final Optional<String> materializationProject;
    private final Optional<String> materializationDataset;
    private final String viewEnabledParamName;
    private final int materializationExpirationTimeInMinutes;
    private final DataFormat readDataFormat;
    private final int maxReadRowsRetries;
    private final OptionalInt maxParallelism;
    private final int defaultParallelism;
    private final Optional<String> requestEncodedBase;
    private final Optional<String> endpoint;
    private final int backgroundParsingThreads;
    private final boolean pushAllFilters;
    private final int prebufferResponses;
    private final int streamsPerPartition;

    ReadSessionCreatorConfig(boolean bl, Optional<String> optional, Optional<String> optional2, int n, DataFormat dataFormat, int n2, String string, OptionalInt optionalInt, int n3, Optional<String> optional3, Optional<String> optional4, int n4, boolean bl2, int n5, int n6) {
        this.viewsEnabled = bl;
        this.materializationProject = optional;
        this.materializationDataset = optional2;
        this.viewEnabledParamName = string;
        this.materializationExpirationTimeInMinutes = n;
        this.readDataFormat = dataFormat;
        this.maxReadRowsRetries = n2;
        this.maxParallelism = optionalInt;
        this.defaultParallelism = n3;
        this.requestEncodedBase = optional3;
        this.endpoint = optional4;
        this.backgroundParsingThreads = n4;
        this.pushAllFilters = bl2;
        this.prebufferResponses = n5;
        this.streamsPerPartition = n6;
    }

    public boolean isViewsEnabled() {
        return this.viewsEnabled;
    }

    public Optional<String> getMaterializationProject() {
        return this.materializationProject;
    }

    public Optional<String> getMaterializationDataset() {
        return this.materializationDataset;
    }

    public String getViewEnabledParamName() {
        return this.viewEnabledParamName;
    }

    public int getMaterializationExpirationTimeInMinutes() {
        return this.materializationExpirationTimeInMinutes;
    }

    public DataFormat getReadDataFormat() {
        return this.readDataFormat;
    }

    public int getMaxReadRowsRetries() {
        return this.maxReadRowsRetries;
    }

    public OptionalInt getMaxParallelism() {
        return this.maxParallelism;
    }

    public int getDefaultParallelism() {
        return this.defaultParallelism;
    }

    public Optional<String> getRequestEncodedBase() {
        return this.requestEncodedBase;
    }

    public Optional<String> endpoint() {
        return this.endpoint;
    }

    public int backgroundParsingThreads() {
        return this.backgroundParsingThreads;
    }

    public boolean getPushAllFilters() {
        return this.pushAllFilters;
    }

    public ReadRowsHelper.Options toReadRowsHelperOptions() {
        return new ReadRowsHelper.Options(this.getMaxReadRowsRetries(), this.endpoint(), this.backgroundParsingThreads(), this.getPrebufferResponses());
    }

    public int streamsPerPartition() {
        return this.streamsPerPartition;
    }

    public int getPrebufferResponses() {
        return this.prebufferResponses;
    }
}

