/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.cloud.bigquery.connector.common.ReadSessionCreatorConfig;
import com.google.cloud.bigquery.storage.v1.DataFormat;
import java.util.Optional;
import java.util.OptionalInt;

public class ReadSessionCreatorConfigBuilder {
    private boolean viewsEnabled;
    private Optional<String> materializationProject = Optional.empty();
    private Optional<String> materializationDataset = Optional.empty();
    private int materializationExpirationTimeInMinutes = 120;
    private DataFormat readDataFormat = DataFormat.ARROW;
    private int maxReadRowsRetries = 10;
    private String viewEnabledParamName = "";
    private OptionalInt maxParallelism = OptionalInt.empty();
    private int defaultParallelism = 1000;
    private Optional<String> requestEncodedBase = Optional.empty();
    private Optional<String> endpoint = Optional.empty();
    private int backgroundParsingThreads = 0;
    private boolean pushAllFilters = true;
    int prebufferResponses = 1;
    int streamsPerPartition = 1;

    public ReadSessionCreatorConfigBuilder setViewsEnabled(boolean bl) {
        this.viewsEnabled = bl;
        return this;
    }

    public ReadSessionCreatorConfigBuilder setMaterializationProject(Optional<String> optional) {
        this.materializationProject = optional;
        return this;
    }

    public ReadSessionCreatorConfigBuilder setMaterializationDataset(Optional<String> optional) {
        this.materializationDataset = optional;
        return this;
    }

    public ReadSessionCreatorConfigBuilder setMaterializationExpirationTimeInMinutes(int n) {
        this.materializationExpirationTimeInMinutes = n;
        return this;
    }

    public ReadSessionCreatorConfigBuilder setReadDataFormat(DataFormat dataFormat) {
        this.readDataFormat = dataFormat;
        return this;
    }

    public ReadSessionCreatorConfigBuilder setMaxReadRowsRetries(int n) {
        this.maxReadRowsRetries = n;
        return this;
    }

    public ReadSessionCreatorConfigBuilder setViewEnabledParamName(String string) {
        this.viewEnabledParamName = string;
        return this;
    }

    public ReadSessionCreatorConfigBuilder setMaxParallelism(OptionalInt optionalInt) {
        this.maxParallelism = optionalInt;
        return this;
    }

    public ReadSessionCreatorConfigBuilder setDefaultParallelism(int n) {
        this.defaultParallelism = n;
        return this;
    }

    public ReadSessionCreatorConfigBuilder setRequestEncodedBase(Optional<String> optional) {
        this.requestEncodedBase = optional;
        return this;
    }

    public ReadSessionCreatorConfigBuilder setEndpoint(Optional<String> optional) {
        this.endpoint = optional;
        return this;
    }

    public ReadSessionCreatorConfigBuilder setBackgroundParsingThreads(int n) {
        this.backgroundParsingThreads = n;
        return this;
    }

    public ReadSessionCreatorConfigBuilder setPushAllFilters(boolean bl) {
        this.pushAllFilters = bl;
        return this;
    }

    public ReadSessionCreatorConfigBuilder setPrebufferReadRowsResponses(int n) {
        this.prebufferResponses = n;
        return this;
    }

    public ReadSessionCreatorConfigBuilder setStreamsPerPartition(int n) {
        this.streamsPerPartition = n;
        return this;
    }

    public ReadSessionCreatorConfig build() {
        return new ReadSessionCreatorConfig(this.viewsEnabled, this.materializationProject, this.materializationDataset, this.materializationExpirationTimeInMinutes, this.readDataFormat, this.maxReadRowsRetries, this.viewEnabledParamName, this.maxParallelism, this.defaultParallelism, this.requestEncodedBase, this.endpoint, this.backgroundParsingThreads, this.pushAllFilters, this.prebufferResponses, this.streamsPerPartition);
    }
}

