/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StreamController;
import com.google.cloud.bigquery.connector.common.BigQueryUtil;
import com.google.cloud.bigquery.storage.v1.BigQueryReadClient;
import com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class StreamCombiningIterator
implements Iterator<ReadRowsResponse> {
    private static final Object EOS = new Object();
    private final ArrayBlockingQueue<Object> responses;
    private final ArrayBlockingQueue<Observer> observersQueue;
    private final AtomicInteger observersLeft;
    private final int bufferEntriesPerStream;
    private final int numRetries;
    private final Object lock = new Object();
    private final BigQueryReadClient client;
    Object last;
    volatile boolean cancelled = false;
    private final Collection<Observer> observers;

    StreamCombiningIterator(BigQueryReadClient bigQueryReadClient, Collection<ReadRowsRequest.Builder> collection, int n, int n2) {
        this.client = bigQueryReadClient;
        this.observersLeft = new AtomicInteger(collection.size());
        this.bufferEntriesPerStream = n;
        Preconditions.checkArgument((this.bufferEntriesPerStream > 0 ? 1 : 0) != 0, (String)"bufferEntriesPerstream must be positive.  Received: %s", (int)this.bufferEntriesPerStream);
        this.responses = new ArrayBlockingQueue(collection.size() * this.bufferEntriesPerStream + 1);
        this.observersQueue = new ArrayBlockingQueue(collection.size() * this.bufferEntriesPerStream);
        this.numRetries = n2;
        this.observers = collection.stream().map(builder -> new Observer((ReadRowsRequest.Builder)builder)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void stopWithError(Throwable throwable) {
        Object object = this.lock;
        synchronized (object) {
            if (this.cancelled) {
                return;
            }
            try {
                this.completeStream(false);
            }
            finally {
                Preconditions.checkState((boolean)this.responses.add(throwable), (Object)"Responses should always have capacity to add element");
            }
        }
    }

    private boolean hasActiveObservers() {
        return this.observersLeft.get() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadRowsResponse next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            ReadRowsResponse readRowsResponse;
            Observer observer = this.observersQueue.poll();
            Preconditions.checkState((observer != null ? 1 : 0) != 0);
            observer.request();
            ReadRowsResponse readRowsResponse2 = readRowsResponse = (ReadRowsResponse)this.last;
            return readRowsResponse2;
        }
        finally {
            if (this.last != EOS) {
                this.last = null;
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this.last == null) {
            try {
                this.last = this.responses.take();
            }
            catch (InterruptedException interruptedException) {
                this.cancel();
                Thread.currentThread().interrupt();
                throw new RuntimeException(interruptedException);
            }
        }
        if (this.last instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)this.last;
            runtimeException.addSuppressed(new RuntimeException("Asynchronous task failed"));
            throw runtimeException;
        }
        if (this.last instanceof Throwable) {
            Throwable throwable = (Throwable)this.last;
            throw new UncheckedExecutionException(throwable);
        }
        return this.last != EOS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.lock;
        synchronized (object) {
            if (this.cancelled) {
                return;
            }
            this.completeStream(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeFinished() {
        Iterator<Observer> iterator = this.lock;
        synchronized (iterator) {
            if (this.cancelled) {
                return;
            }
            if (this.hasActiveObservers()) {
                return;
            }
            this.completeStream(true);
        }
        for (Observer observer : this.observers) {
            observer.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeStream(boolean bl) {
        this.cancelled = true;
        this.observersLeft.set(0);
        try {
            for (Observer observer : this.observers) {
                observer.cancel();
            }
        }
        finally {
            if (bl) {
                this.responses.add(EOS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newConnection(Observer observer, ReadRowsRequest.Builder builder) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.cancelled) {
                this.client.readRowsCallable().call((Object)builder.build(), (ResponseObserver)observer);
            }
        }
    }

    class Observer
    implements ResponseObserver<ReadRowsResponse> {
        private long readRowsCount = 0L;
        private int retries = 0;
        StreamController controller;
        AtomicInteger enqueuedCount = new AtomicInteger(0);
        private final Object controllerLock = new Object();
        ReadRowsRequest.Builder builder;

        Observer(ReadRowsRequest.Builder builder) {
            this.builder = builder;
            StreamCombiningIterator.this.newConnection(this, builder);
        }

        public void onResponse(ReadRowsResponse readRowsResponse) {
            this.readRowsCount += readRowsResponse.getRowCount();
            Preconditions.checkState((boolean)StreamCombiningIterator.this.observersQueue.add(this));
            Preconditions.checkState((boolean)StreamCombiningIterator.this.responses.add(readRowsResponse), (Object)"Expected capacity in responses");
            int n = this.enqueuedCount.incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onStart(StreamController streamController) {
            Object object = StreamCombiningIterator.this.lock;
            synchronized (object) {
                if (StreamCombiningIterator.this.cancelled) {
                    streamController.cancel();
                    return;
                }
                Object object2 = this.controllerLock;
                synchronized (object2) {
                    this.controller = streamController;
                    streamController.disableAutoInboundFlowControl();
                    int n = StreamCombiningIterator.this.bufferEntriesPerStream - this.enqueuedCount.get();
                    if (n > 0) {
                        streamController.request(n);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable throwable) {
            if (BigQueryUtil.isRetryable(throwable) && this.retries < StreamCombiningIterator.this.numRetries) {
                Object object = this.controllerLock;
                synchronized (object) {
                    this.controller = null;
                }
                this.builder.setOffset(this.readRowsCount);
                StreamCombiningIterator.this.newConnection(this, this.builder);
                ++this.retries;
            } else {
                StreamCombiningIterator.this.stopWithError(throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete() {
            Object object = this.controllerLock;
            synchronized (object) {
                this.controller = null;
            }
            int n = StreamCombiningIterator.this.observersLeft.decrementAndGet();
            StreamCombiningIterator.this.maybeFinished();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void request() {
            if (StreamCombiningIterator.this.cancelled) {
                return;
            }
            boolean bl = false;
            while (!bl) {
                Object object = this.controllerLock;
                synchronized (object) {
                    this.enqueuedCount.decrementAndGet();
                    if (this.controller == null) {
                        return;
                    }
                    try {
                        this.controller.request(1);
                        bl = true;
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Object object = this.controllerLock;
            synchronized (object) {
                if (this.controller != null) {
                    try {
                        this.controller.cancel();
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

