/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.connector.common.ArrowUtil;
import com.google.cloud.spark.bigquery.ArrowReaderIterator;
import com.google.cloud.spark.bigquery.ArrowSchemaConverter;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.arrow.compression.CommonsCompressionFactory;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.compression.CompressionCodec;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;

public class ArrowBinaryIterator
implements Iterator<InternalRow> {
    private static long maxAllocation = Long.MAX_VALUE;
    ArrowReaderIterator arrowReaderIterator;
    Iterator<InternalRow> currentIterator;
    List<String> columnsInOrder;
    Map<String, StructField> userProvidedFieldMap;

    public ArrowBinaryIterator(List<String> list, ByteString byteString, ByteString byteString2, Optional<StructType> optional) {
        BufferAllocator bufferAllocator = ArrowUtil.newRootAllocator(maxAllocation).newChildAllocator("ArrowBinaryIterator", 0L, maxAllocation);
        SequenceInputStream sequenceInputStream = new SequenceInputStream(new ByteArrayInputStream(byteString.toByteArray()), new ByteArrayInputStream(byteString2.toByteArray()));
        ArrowStreamReader arrowStreamReader = new ArrowStreamReader((InputStream)sequenceInputStream, bufferAllocator, (CompressionCodec.Factory)CommonsCompressionFactory.INSTANCE);
        this.arrowReaderIterator = new ArrowReaderIterator((ArrowReader)arrowStreamReader);
        this.currentIterator = ImmutableList.of().iterator();
        this.columnsInOrder = list;
        List list2 = Arrays.stream(optional.orElse(new StructType()).fields()).collect(Collectors.toList());
        this.userProvidedFieldMap = list2.stream().collect(Collectors.toMap(StructField::name, Function.identity()));
    }

    @Override
    public boolean hasNext() {
        while (!this.currentIterator.hasNext()) {
            if (!this.arrowReaderIterator.hasNext()) {
                return false;
            }
            this.currentIterator = this.toArrowRows(this.arrowReaderIterator.next(), this.columnsInOrder);
        }
        return this.currentIterator.hasNext();
    }

    @Override
    public InternalRow next() {
        return this.currentIterator.next();
    }

    private Iterator<InternalRow> toArrowRows(VectorSchemaRoot vectorSchemaRoot, List<String> list) {
        ColumnVector[] columnVectorArray = list.stream().map(string -> vectorSchemaRoot.getVector(string)).map(fieldVector -> new ArrowSchemaConverter((ValueVector)fieldVector, this.userProvidedFieldMap.get(fieldVector.getName()))).collect(Collectors.toList()).toArray(new ColumnVector[0]);
        ColumnarBatch columnarBatch = new ColumnarBatch(columnVectorArray);
        columnarBatch.setNumRows(vectorSchemaRoot.getRowCount());
        return columnarBatch.rowIterator();
    }
}

