/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.spark.bigquery.AvroBinaryIterator;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ArrowReaderIterator
implements Iterator<VectorSchemaRoot> {
    private static final Logger log = LoggerFactory.getLogger(AvroBinaryIterator.class);
    boolean closed = false;
    VectorSchemaRoot current = null;
    ArrowReader reader;

    public ArrowReaderIterator(ArrowReader arrowReader) {
        this.reader = arrowReader;
    }

    @Override
    public boolean hasNext() {
        if (this.current != null) {
            return true;
        }
        if (this.closed) {
            return false;
        }
        try {
            boolean bl = this.reader.loadNextBatch();
            if (bl) {
                this.current = this.reader.getVectorSchemaRoot();
            } else {
                this.ensureClosed();
            }
            return bl;
        }
        catch (IOException iOException) {
            throw new UncheckedIOException("Failed to load the next arrow batch", iOException);
        }
    }

    @Override
    public VectorSchemaRoot next() {
        VectorSchemaRoot vectorSchemaRoot = this.current;
        this.current = null;
        return vectorSchemaRoot;
    }

    private void ensureClosed() throws IOException {
        if (!this.closed) {
            this.reader.close();
            this.closed = true;
        }
    }
}

