/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.Decimal256Vector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.unsafe.types.UTF8String;

public class ArrowSchemaConverter
extends ColumnVector {
    private final ArrowVectorAccessor accessor;
    private ArrowSchemaConverter[] childColumns;

    public boolean hasNull() {
        return this.accessor.getNullCount() > 0;
    }

    public int numNulls() {
        return this.accessor.getNullCount();
    }

    public void close() {
        if (this.childColumns != null) {
            for (int i = 0; i < this.childColumns.length; ++i) {
                this.childColumns[i].close();
                this.childColumns[i] = null;
            }
            this.childColumns = null;
        }
        this.accessor.close();
    }

    public boolean isNullAt(int n) {
        return this.accessor.isNullAt(n);
    }

    public boolean getBoolean(int n) {
        return this.accessor.getBoolean(n);
    }

    public byte getByte(int n) {
        return this.accessor.getByte(n);
    }

    public short getShort(int n) {
        return this.accessor.getShort(n);
    }

    public int getInt(int n) {
        return this.accessor.getInt(n);
    }

    public long getLong(int n) {
        return this.accessor.getLong(n);
    }

    public float getFloat(int n) {
        return this.accessor.getFloat(n);
    }

    public double getDouble(int n) {
        return this.accessor.getDouble(n);
    }

    public Decimal getDecimal(int n, int n2, int n3) {
        if (this.isNullAt(n)) {
            return null;
        }
        return this.accessor.getDecimal(n, n2, n3);
    }

    public UTF8String getUTF8String(int n) {
        if (this.isNullAt(n)) {
            return null;
        }
        return this.accessor.getUTF8String(n);
    }

    public byte[] getBinary(int n) {
        if (this.isNullAt(n)) {
            return null;
        }
        return this.accessor.getBinary(n);
    }

    public ColumnarArray getArray(int n) {
        if (this.isNullAt(n)) {
            return null;
        }
        return this.accessor.getArray(n);
    }

    public ColumnarMap getMap(int n) {
        throw new UnsupportedOperationException();
    }

    public ArrowSchemaConverter getChild(int n) {
        return this.childColumns[n];
    }

    private static DataType fromArrowType(ArrowType arrowType) {
        switch (arrowType.getTypeID()) {
            case Int: {
                return DataTypes.LongType;
            }
            case Bool: {
                return DataTypes.BooleanType;
            }
            case FloatingPoint: {
                return DataTypes.DoubleType;
            }
            case Binary: {
                return DataTypes.BinaryType;
            }
            case Utf8: {
                return DataTypes.StringType;
            }
            case Date: {
                return DataTypes.DateType;
            }
            case Time: 
            case Timestamp: {
                return DataTypes.TimestampType;
            }
            case Decimal: {
                return DataTypes.createDecimalType();
            }
        }
        throw new UnsupportedOperationException("Unsupported data type " + arrowType.toString());
    }

    private static DataType fromArrowField(Field field) {
        if (field.getType().getTypeID() == ArrowType.ArrowTypeID.List) {
            Field field2 = (Field)field.getChildren().get(0);
            DataType dataType = ArrowSchemaConverter.fromArrowField(field2);
            return new ArrayType(dataType, field2.isNullable());
        }
        if (field.getType().getTypeID() == ArrowType.ArrowTypeID.Struct) {
            List list = field.getChildren();
            StructField[] structFieldArray = new StructField[list.size()];
            int n = 0;
            for (Field field3 : field.getChildren()) {
                DataType dataType = ArrowSchemaConverter.fromArrowField(field3);
                structFieldArray[n++] = new StructField(field3.getName(), dataType, field3.isNullable(), Metadata.empty());
            }
            return new StructType(structFieldArray);
        }
        return ArrowSchemaConverter.fromArrowType(field.getType());
    }

    public ArrowSchemaConverter(ValueVector valueVector, StructField structField) {
        super(ArrowSchemaConverter.fromArrowField(valueVector.getField()));
        if (valueVector instanceof BitVector) {
            this.accessor = new BooleanAccessor((BitVector)valueVector);
        } else if (valueVector instanceof BigIntVector) {
            this.accessor = new LongAccessor((BigIntVector)valueVector);
        } else if (valueVector instanceof Float8Vector) {
            this.accessor = new DoubleAccessor((Float8Vector)valueVector);
        } else if (valueVector instanceof DecimalVector) {
            this.accessor = new DecimalAccessor((DecimalVector)valueVector);
        } else if (valueVector instanceof Decimal256Vector) {
            this.accessor = new Decimal256Accessor((Decimal256Vector)valueVector);
        } else if (valueVector instanceof VarCharVector) {
            this.accessor = new StringAccessor((VarCharVector)valueVector);
        } else if (valueVector instanceof VarBinaryVector) {
            this.accessor = new BinaryAccessor((VarBinaryVector)valueVector);
        } else if (valueVector instanceof DateDayVector) {
            this.accessor = new DateAccessor((DateDayVector)valueVector);
        } else if (valueVector instanceof TimeMicroVector) {
            this.accessor = new TimeMicroVectorAccessor((TimeMicroVector)valueVector);
        } else if (valueVector instanceof TimeStampMicroVector) {
            this.accessor = new TimestampMicroVectorAccessor((TimeStampMicroVector)valueVector);
        } else if (valueVector instanceof TimeStampMicroTZVector) {
            this.accessor = new TimestampMicroTZVectorAccessor((TimeStampMicroTZVector)valueVector);
        } else if (valueVector instanceof ListVector) {
            ListVector listVector = (ListVector)valueVector;
            this.accessor = new ArrayAccessor(listVector, structField);
        } else if (valueVector instanceof StructVector) {
            StructVector structVector = (StructVector)valueVector;
            this.accessor = new StructAccessor(structVector);
            if (structField != null) {
                List list = Arrays.stream(((StructType)structField.dataType()).fields()).collect(Collectors.toList());
                this.childColumns = new ArrowSchemaConverter[list.size()];
                Map<String, ValueVector> map = structVector.getChildrenFromFields().stream().collect(Collectors.toMap(ValueVector::getName, fieldVector -> fieldVector));
                for (int i = 0; i < this.childColumns.length; ++i) {
                    StructField structField2 = (StructField)list.get(i);
                    this.childColumns[i] = new ArrowSchemaConverter(map.get(structField2.name()), structField2);
                }
            } else {
                this.childColumns = new ArrowSchemaConverter[structVector.size()];
                for (int i = 0; i < this.childColumns.length; ++i) {
                    this.childColumns[i] = new ArrowSchemaConverter(structVector.getVectorById(i), null);
                }
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private static class StructAccessor
    extends ArrowVectorAccessor {
        StructAccessor(StructVector structVector) {
            super((ValueVector)structVector);
        }
    }

    private static class ArrayAccessor
    extends ArrowVectorAccessor {
        private final ListVector accessor;
        private final ArrowSchemaConverter arrayData;

        ArrayAccessor(ListVector listVector, StructField structField) {
            super((ValueVector)listVector);
            this.accessor = listVector;
            StructField structField2 = null;
            if (structField != null) {
                ArrayType arrayType = (ArrayType)structField.dataType();
                structField2 = new StructField(listVector.getDataVector().getName(), arrayType.elementType(), arrayType.containsNull(), Metadata.empty());
            }
            this.arrayData = new ArrowSchemaConverter((ValueVector)listVector.getDataVector(), structField2);
        }

        @Override
        final boolean isNullAt(int n) {
            if (this.accessor.getValueCount() > 0 && this.accessor.getValidityBuffer().capacity() == 0L) {
                return false;
            }
            return super.isNullAt(n);
        }

        @Override
        final ColumnarArray getArray(int n) {
            ArrowBuf arrowBuf = this.accessor.getOffsetBuffer();
            int n2 = n * 4;
            int n3 = arrowBuf.getInt((long)n2);
            int n4 = arrowBuf.getInt((long)(n2 + 4));
            return new ColumnarArray((ColumnVector)this.arrayData, n3, n4 - n3);
        }
    }

    private static class TimestampMicroTZVectorAccessor
    extends ArrowVectorAccessor {
        private final TimeStampMicroTZVector accessor;

        TimestampMicroTZVectorAccessor(TimeStampMicroTZVector timeStampMicroTZVector) {
            super((ValueVector)timeStampMicroTZVector);
            this.accessor = timeStampMicroTZVector;
        }

        @Override
        final long getLong(int n) {
            return this.accessor.get(n);
        }
    }

    private static class TimestampMicroVectorAccessor
    extends ArrowVectorAccessor {
        private final TimeStampMicroVector accessor;
        private static final int ONE_THOUSAND = 1000;
        private static final int ONE_MILLION = 1000000;
        private static final int ONE_BILLION = 1000000000;

        TimestampMicroVectorAccessor(TimeStampMicroVector timeStampMicroVector) {
            super((ValueVector)timeStampMicroVector);
            this.accessor = timeStampMicroVector;
        }

        @Override
        final long getLong(int n) {
            return this.accessor.get(n);
        }

        @Override
        final UTF8String getUTF8String(int n) {
            long l = this.accessor.get(n);
            long l2 = l / 1000000L;
            int n2 = (int)(l % 1000000L) * 1000;
            if (n2 < 0) {
                --l2;
                n2 += 1000000000;
            }
            LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(l2, n2, ZoneOffset.UTC);
            return UTF8String.fromString((String)localDateTime.toString());
        }
    }

    private static class TimeMicroVectorAccessor
    extends ArrowVectorAccessor {
        private final TimeMicroVector accessor;

        TimeMicroVectorAccessor(TimeMicroVector timeMicroVector) {
            super((ValueVector)timeMicroVector);
            this.accessor = timeMicroVector;
        }

        @Override
        final long getLong(int n) {
            return this.accessor.get(n);
        }
    }

    private static class DateAccessor
    extends ArrowVectorAccessor {
        private final DateDayVector accessor;

        DateAccessor(DateDayVector dateDayVector) {
            super((ValueVector)dateDayVector);
            this.accessor = dateDayVector;
        }

        @Override
        final int getInt(int n) {
            return this.accessor.get(n);
        }
    }

    private static class BinaryAccessor
    extends ArrowVectorAccessor {
        private final VarBinaryVector accessor;

        BinaryAccessor(VarBinaryVector varBinaryVector) {
            super((ValueVector)varBinaryVector);
            this.accessor = varBinaryVector;
        }

        @Override
        final byte[] getBinary(int n) {
            return this.accessor.getObject(n);
        }
    }

    private static class StringAccessor
    extends ArrowVectorAccessor {
        private final VarCharVector accessor;

        StringAccessor(VarCharVector varCharVector) {
            super((ValueVector)varCharVector);
            this.accessor = varCharVector;
        }

        @Override
        final UTF8String getUTF8String(int n) {
            if (this.accessor.isSet(n) == 0) {
                return null;
            }
            ArrowBuf arrowBuf = this.accessor.getOffsetBuffer();
            int n2 = n * 4;
            int n3 = arrowBuf.getInt((long)n2);
            int n4 = arrowBuf.getInt((long)(n2 + 4));
            return UTF8String.fromAddress(null, (long)(this.accessor.getDataBuffer().memoryAddress() + (long)n3), (int)(n4 - n3));
        }
    }

    private static class Decimal256Accessor
    extends ArrowVectorAccessor {
        private final Decimal256Vector accessor;

        Decimal256Accessor(Decimal256Vector decimal256Vector) {
            super((ValueVector)decimal256Vector);
            this.accessor = decimal256Vector;
        }

        @Override
        UTF8String getUTF8String(int n) {
            if (this.isNullAt(n)) {
                return null;
            }
            BigDecimal bigDecimal = this.accessor.getObject(n);
            return UTF8String.fromString((String)bigDecimal.toPlainString());
        }
    }

    private static class DecimalAccessor
    extends ArrowVectorAccessor {
        private final DecimalVector accessor;

        DecimalAccessor(DecimalVector decimalVector) {
            super((ValueVector)decimalVector);
            this.accessor = decimalVector;
        }

        @Override
        final Decimal getDecimal(int n, int n2, int n3) {
            if (this.isNullAt(n)) {
                return null;
            }
            return Decimal.apply((BigDecimal)this.accessor.getObject(n), (int)n2, (int)n3);
        }
    }

    private static class DoubleAccessor
    extends ArrowVectorAccessor {
        private final Float8Vector accessor;

        DoubleAccessor(Float8Vector float8Vector) {
            super((ValueVector)float8Vector);
            this.accessor = float8Vector;
        }

        @Override
        final double getDouble(int n) {
            return this.accessor.get(n);
        }
    }

    private static class LongAccessor
    extends ArrowVectorAccessor {
        private final BigIntVector accessor;

        LongAccessor(BigIntVector bigIntVector) {
            super((ValueVector)bigIntVector);
            this.accessor = bigIntVector;
        }

        @Override
        byte getByte(int n) {
            return (byte)this.getLong(n);
        }

        @Override
        short getShort(int n) {
            return (short)this.getLong(n);
        }

        @Override
        int getInt(int n) {
            return (int)this.getLong(n);
        }

        @Override
        final long getLong(int n) {
            return this.accessor.get(n);
        }
    }

    private static class BooleanAccessor
    extends ArrowVectorAccessor {
        private final BitVector accessor;

        BooleanAccessor(BitVector bitVector) {
            super((ValueVector)bitVector);
            this.accessor = bitVector;
        }

        @Override
        final boolean getBoolean(int n) {
            return this.accessor.get(n) == 1;
        }
    }

    private static abstract class ArrowVectorAccessor {
        private final ValueVector vector;

        ArrowVectorAccessor(ValueVector valueVector) {
            this.vector = valueVector;
        }

        boolean isNullAt(int n) {
            return this.vector.isNull(n);
        }

        final int getNullCount() {
            return this.vector.getNullCount();
        }

        final void close() {
            this.vector.close();
        }

        boolean getBoolean(int n) {
            throw new UnsupportedOperationException();
        }

        byte getByte(int n) {
            throw new UnsupportedOperationException();
        }

        short getShort(int n) {
            throw new UnsupportedOperationException();
        }

        int getInt(int n) {
            throw new UnsupportedOperationException();
        }

        long getLong(int n) {
            throw new UnsupportedOperationException();
        }

        float getFloat(int n) {
            throw new UnsupportedOperationException();
        }

        double getDouble(int n) {
            throw new UnsupportedOperationException();
        }

        Decimal getDecimal(int n, int n2, int n3) {
            throw new UnsupportedOperationException();
        }

        UTF8String getUTF8String(int n) {
            throw new UnsupportedOperationException();
        }

        byte[] getBinary(int n) {
            throw new UnsupportedOperationException();
        }

        ColumnarArray getArray(int n) {
            throw new UnsupportedOperationException();
        }
    }
}

