/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.spark.bigquery.SchemaConverters;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroBinaryIterator
implements Iterator<InternalRow> {
    private static final Logger log = LoggerFactory.getLogger(AvroBinaryIterator.class);
    GenericDatumReader reader;
    List<String> columnsInOrder;
    BinaryDecoder in;
    com.google.cloud.bigquery.Schema bqSchema;
    Optional<StructType> userProvidedSchema;

    public AvroBinaryIterator(com.google.cloud.bigquery.Schema schema, List<String> list, Schema schema2, ByteString byteString, Optional<StructType> optional) {
        this.reader = new GenericDatumReader(schema2);
        this.bqSchema = schema;
        this.columnsInOrder = list;
        this.in = new DecoderFactory().binaryDecoder(byteString.toByteArray(), null);
        this.userProvidedSchema = optional;
    }

    @Override
    public boolean hasNext() {
        try {
            return !this.in.isEnd();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public InternalRow next() {
        try {
            return SchemaConverters.convertToInternalRow(this.bqSchema, this.columnsInOrder, (GenericRecord)this.reader.read(null, (Decoder)this.in), this.userProvidedSchema);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }
}

