/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.util.Utf8;
import org.apache.spark.bigquery.BigNumericUDT;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.UserDefinedType;

public class AvroSchemaConverter {
    private static final Schema NULL = Schema.create((Schema.Type)Schema.Type.NULL);
    private static final Conversions.DecimalConversion DECIMAL_CONVERSIONS = new Conversions.DecimalConversion();

    public static Schema sparkSchemaToAvroSchema(StructType structType) {
        return AvroSchemaConverter.sparkTypeToRawAvroType((DataType)structType, false, "root");
    }

    static Schema sparkTypeToRawAvroType(DataType dataType, boolean bl, String string) {
        SchemaBuilder.TypeBuilder typeBuilder = SchemaBuilder.builder();
        Schema schema = AvroSchemaConverter.sparkTypeToRawAvroType(dataType, string, (SchemaBuilder.TypeBuilder<Schema>)typeBuilder);
        if (bl) {
            schema = Schema.createUnion((Schema[])new Schema[]{schema, NULL});
        }
        return schema;
    }

    static Schema sparkTypeToRawAvroType(DataType dataType, String string, SchemaBuilder.TypeBuilder<Schema> typeBuilder) {
        if (dataType instanceof BinaryType) {
            return (Schema)typeBuilder.bytesType();
        }
        if (dataType instanceof ByteType || dataType instanceof ShortType || dataType instanceof IntegerType || dataType instanceof LongType) {
            return (Schema)typeBuilder.longType();
        }
        if (dataType instanceof BooleanType) {
            return (Schema)typeBuilder.booleanType();
        }
        if (dataType instanceof FloatType || dataType instanceof DoubleType) {
            return (Schema)typeBuilder.doubleType();
        }
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            if (decimalType.precision() <= 38 && decimalType.scale() <= 9) {
                return LogicalTypes.decimal((int)decimalType.precision(), (int)decimalType.scale()).addToSchema((Schema)typeBuilder.bytesType());
            }
            throw new IllegalArgumentException("Decimal type is too wide to fit in BigQuery Numeric format");
        }
        if (dataType instanceof BigNumericUDT) {
            return LogicalTypes.decimal((int)77, (int)38).addToSchema((Schema)typeBuilder.bytesType());
        }
        if (dataType instanceof StringType) {
            return (Schema)typeBuilder.stringType();
        }
        if (dataType instanceof TimestampType) {
            return LogicalTypes.timestampMicros().addToSchema((Schema)typeBuilder.longType());
        }
        if (dataType instanceof DateType) {
            return LogicalTypes.date().addToSchema((Schema)typeBuilder.intType());
        }
        if (dataType instanceof ArrayType) {
            return (Schema)typeBuilder.array().items(AvroSchemaConverter.sparkTypeToRawAvroType(((ArrayType)dataType).elementType(), ((ArrayType)dataType).containsNull(), string));
        }
        if (dataType instanceof StructType) {
            SchemaBuilder.FieldAssembler fieldAssembler = typeBuilder.record(string).fields();
            for (StructField structField : ((StructType)dataType).fields()) {
                Schema schema = AvroSchemaConverter.sparkTypeToRawAvroType(structField.dataType(), structField.nullable(), structField.name());
                fieldAssembler.name(structField.name()).type(schema).noDefault();
            }
            return (Schema)fieldAssembler.endRecord();
        }
        if (dataType instanceof UserDefinedType) {
            DataType dataType2 = ((UserDefinedType)dataType).sqlType();
            return AvroSchemaConverter.sparkTypeToRawAvroType(dataType2, string, typeBuilder);
        }
        if (dataType instanceof MapType) {
            throw new IllegalArgumentException("MapType is unsupported.");
        }
        throw new IllegalArgumentException("Data type not supported: " + dataType.simpleString());
    }

    public static GenericData.Record sparkRowToAvroGenericData(InternalRow internalRow, StructType structType, Schema schema) {
        StructConverter structConverter = new StructConverter(structType, schema);
        return structConverter.convert(internalRow);
    }

    static Schema resolveNullableType(Schema schema2, boolean bl) {
        if (bl && schema2.getType() != Schema.Type.NULL) {
            List list = schema2.getTypes();
            Preconditions.checkArgument((list.size() == 2 ? 1 : 0) != 0, (Object)"Avro nullable filed should be represented by a union of size 2");
            Optional<Schema> optional = list.stream().filter(schema -> schema.getType() != Schema.Type.NULL).findFirst();
            return optional.orElseThrow(() -> new IllegalArgumentException("No actual type has been found in " + schema2));
        }
        return schema2;
    }

    static Converter createConverterFor(DataType dataType, Schema schema) {
        if (dataType instanceof NullType && schema.getType() == Schema.Type.NULL) {
            return (specializedGetters, n) -> null;
        }
        if (dataType instanceof BooleanType && schema.getType() == Schema.Type.BOOLEAN) {
            return (specializedGetters, n) -> specializedGetters.getBoolean(n);
        }
        if (dataType instanceof ByteType && schema.getType() == Schema.Type.LONG) {
            return (specializedGetters, n) -> (long)specializedGetters.getByte(n);
        }
        if (dataType instanceof ShortType && schema.getType() == Schema.Type.LONG) {
            return (specializedGetters, n) -> (long)specializedGetters.getShort(n);
        }
        if (dataType instanceof IntegerType && schema.getType() == Schema.Type.LONG) {
            return (specializedGetters, n) -> (long)specializedGetters.getInt(n);
        }
        if (dataType instanceof LongType && schema.getType() == Schema.Type.LONG) {
            return (specializedGetters, n) -> specializedGetters.getLong(n);
        }
        if (dataType instanceof FloatType && schema.getType() == Schema.Type.DOUBLE) {
            return (specializedGetters, n) -> (double)specializedGetters.getFloat(n);
        }
        if (dataType instanceof DoubleType && schema.getType() == Schema.Type.DOUBLE) {
            return (specializedGetters, n) -> specializedGetters.getDouble(n);
        }
        if (dataType instanceof DecimalType && schema.getType() == Schema.Type.BYTES) {
            DecimalType decimalType = (DecimalType)dataType;
            return (specializedGetters, n) -> {
                Decimal decimal = specializedGetters.getDecimal(n, decimalType.precision(), decimalType.scale());
                return DECIMAL_CONVERSIONS.toBytes(decimal.toJavaBigDecimal(), schema, (LogicalType)LogicalTypes.decimal((int)decimalType.precision(), (int)decimalType.scale()));
            };
        }
        if (dataType instanceof BigNumericUDT && schema.getType() == Schema.Type.BYTES) {
            return (specializedGetters, n) -> DECIMAL_CONVERSIONS.toBytes(new BigDecimal(specializedGetters.getUTF8String(n).toString()), schema, (LogicalType)LogicalTypes.decimal((int)77, (int)38));
        }
        if (dataType instanceof StringType && schema.getType() == Schema.Type.STRING) {
            return (specializedGetters, n) -> new Utf8(specializedGetters.getUTF8String(n).getBytes());
        }
        if (dataType instanceof BinaryType && schema.getType() == Schema.Type.FIXED) {
            int n3 = schema.getFixedSize();
            return (specializedGetters, n2) -> {
                byte[] byArray = specializedGetters.getBinary(n2);
                if (byArray.length != n3) {
                    throw new IllegalArgumentException(String.format("Cannot write %s bytes of binary data into FIXED Type with size of %s bytes", byArray.length, n3));
                }
                return new GenericData.Fixed(schema, byArray);
            };
        }
        if (dataType instanceof BinaryType && schema.getType() == Schema.Type.BYTES) {
            return (specializedGetters, n) -> ByteBuffer.wrap(specializedGetters.getBinary(n));
        }
        if (dataType instanceof DateType && schema.getType() == Schema.Type.INT) {
            return (specializedGetters, n) -> specializedGetters.getInt(n);
        }
        if (dataType instanceof TimestampType && schema.getType() == Schema.Type.LONG) {
            return (specializedGetters, n) -> specializedGetters.getLong(n);
        }
        if (dataType instanceof ArrayType && schema.getType() == Schema.Type.ARRAY) {
            DataType dataType2 = ((ArrayType)dataType).elementType();
            boolean bl = ((ArrayType)dataType).containsNull();
            Converter converter = AvroSchemaConverter.createConverterFor(dataType2, AvroSchemaConverter.resolveNullableType(schema.getElementType(), bl));
            return (specializedGetters, n) -> {
                ArrayData arrayData = specializedGetters.getArray(n);
                int n2 = arrayData.numElements();
                Object[] objectArray = new Object[n2];
                for (int i = 0; i < n2; ++i) {
                    objectArray[i] = bl && arrayData.isNullAt(i) ? null : converter.convert((SpecializedGetters)arrayData, i);
                }
                return Arrays.asList(objectArray);
            };
        }
        if (dataType instanceof StructType && schema.getType() == Schema.Type.RECORD) {
            StructType structType = (StructType)dataType;
            StructConverter structConverter = new StructConverter(structType, schema);
            int n4 = structType.length();
            return (specializedGetters, n2) -> structConverter.convert(specializedGetters.getStruct(n2, n4));
        }
        if (dataType instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType;
            return AvroSchemaConverter.createConverterFor(userDefinedType.sqlType(), schema);
        }
        throw new IllegalArgumentException(String.format("Cannot convert Catalyst type %s to Avro type %s", dataType, schema));
    }

    static class StructConverter {
        private final StructType sparkStruct;
        private final Schema avroStruct;

        StructConverter(StructType structType, Schema schema) {
            this.sparkStruct = structType;
            this.avroStruct = schema;
            Preconditions.checkArgument((schema.getType() == Schema.Type.RECORD && schema.getFields().size() == structType.length() ? 1 : 0) != 0, (String)"Cannot convert Catalyst type %s to Avro type %s.", (Object)structType, (Object)schema);
        }

        GenericData.Record convert(InternalRow internalRow) {
            int n = this.sparkStruct.length();
            Converter[] converterArray = new Converter[n];
            StructField[] structFieldArray = this.sparkStruct.fields();
            Schema.Field[] fieldArray = this.avroStruct.getFields().toArray(new Schema.Field[n]);
            GenericData.Record record = new GenericData.Record(this.avroStruct);
            for (int i = 0; i < n; ++i) {
                if (internalRow.isNullAt(i)) {
                    record.put(i, null);
                    continue;
                }
                Converter converter = AvroSchemaConverter.createConverterFor(structFieldArray[i].dataType(), AvroSchemaConverter.resolveNullableType(fieldArray[i].schema(), structFieldArray[i].nullable()));
                record.put(i, converter.convert((SpecializedGetters)internalRow, i));
            }
            return record;
        }
    }

    @FunctionalInterface
    static interface Converter {
        public Object convert(SpecializedGetters var1, int var2);
    }
}

